/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.CopyInformee;
import net.sf.saxon.event.EventSource;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.LocationCopier;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.event.NamePoolConverter;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceivingContentHandler;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.Transmitter;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventIteratorToReceiver;
import net.sf.saxon.evpull.PullEventSource;
import net.sf.saxon.expr.number.Numberer_en;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.ExternalObjectModel;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StandardErrorHandler;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.pull.PullPushCopier;
import net.sf.saxon.pull.PullSource;
import net.sf.saxon.pull.StaxBridge;
import net.sf.saxon.trans.XPathException;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public abstract class Sender {
    private static Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static Class staxSourceClass;

    private Sender() {
    }

    public static void send(Source source, Receiver receiver, ParseOptions options) throws XPathException {
        Controller controller;
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        options = options == null ? new ParseOptions(pipe.getParseOptions()) : new ParseOptions(options);
        if (source instanceof AugmentedSource) {
            options.merge(((AugmentedSource)source).getParseOptions());
            source = ((AugmentedSource)source).getContainedSource();
        }
        Configuration config = pipe.getConfiguration();
        options.applyDefaults(config);
        receiver.setSystemId(source.getSystemId());
        Receiver next = receiver;
        int schemaValidation = options.getSchemaValidationMode();
        List<FilterFactory> filters = options.getFilters();
        if (filters != null) {
            for (int i = filters.size() - 1; i >= 0; --i) {
                ProxyReceiver filter = filters.get(i).makeFilter(next);
                filter.setSystemId(source.getSystemId());
                next = filter;
            }
        }
        if (options.getStripSpace() == 2) {
            next = new Stripper(AllElementsSpaceStrippingRule.getInstance(), receiver);
        } else if (options.getStripSpace() == 4 && (controller = pipe.getController()) != null) {
            next = controller.makeStripper(next);
        }
        if (source instanceof NodeInfo) {
            int kind;
            NodeInfo ns = (NodeInfo)source;
            String baseURI = ns.getBaseURI();
            if (schemaValidation != 3) {
                next = config.getDocumentValidator(next, baseURI, options);
            }
            if ((kind = ns.getNodeKind()) != 9 && kind != 1) {
                throw new IllegalArgumentException("Sender can only handle document or element nodes");
            }
            next.setSystemId(baseURI);
            Sender.sendDocumentInfo(ns, next);
            return;
        }
        if (source instanceof PullSource) {
            Sender.sendPullSource((PullSource)source, next, options);
            return;
        }
        if (source instanceof PullEventSource) {
            Sender.sendPullEventSource((PullEventSource)source, next, options);
            return;
        }
        if (source instanceof EventSource) {
            ((EventSource)source).send(next);
            return;
        }
        if (source instanceof Transmitter) {
            ((Transmitter)source).transmit(next);
            return;
        }
        if (source instanceof SAXSource) {
            Sender.sendSAXSource((SAXSource)source, next, options);
            return;
        }
        if (source instanceof StreamSource) {
            StreamSource ss = (StreamSource)source;
            boolean dtdValidation = options.getDTDValidationMode() == 1;
            Source ps = Configuration.getPlatform().getParserSource(pipe, ss, schemaValidation, dtdValidation, options.getStripSpace());
            if (ps == ss) {
                String url = source.getSystemId();
                InputSource is = new InputSource(url);
                is.setCharacterStream(ss.getReader());
                is.setByteStream(ss.getInputStream());
                boolean reuseParser = false;
                XMLReader parser = options.getXMLReader();
                if (parser == null) {
                    parser = config.getSourceParser();
                    if (options.getEntityResolver() != null && parser.getEntityResolver() == null) {
                        parser.setEntityResolver(options.getEntityResolver());
                    }
                    reuseParser = true;
                }
                SAXSource sax = new SAXSource(parser, is);
                sax.setSystemId(source.getSystemId());
                Sender.sendSAXSource(sax, next, options);
                if (reuseParser) {
                    config.reuseSourceParser(parser);
                }
            } else {
                Sender.send(ps, next, options);
            }
            return;
        }
        if (staxSourceClass != null && staxSourceClass.isAssignableFrom(source.getClass())) {
            XMLStreamReader reader = null;
            try {
                Method getReaderMethod = staxSourceClass.getMethod("getXMLStreamReader", EMPTY_CLASS_ARRAY);
                reader = (XMLStreamReader)getReaderMethod.invoke((Object)source, new Object[0]);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (reader == null) {
                throw new XPathException("Saxon can only handle a StAXSource that wraps an XMLStreamReader");
            }
            StaxBridge bridge = new StaxBridge();
            bridge.setXMLStreamReader(reader);
            Sender.sendPullSource(new PullSource(bridge), next, options);
            return;
        }
        next = Sender.makeValidator(next, source.getSystemId(), options);
        Source newSource = config.getSourceResolver().resolveSource(source, config);
        if (newSource instanceof StreamSource || newSource instanceof SAXSource || newSource instanceof Transmitter || newSource instanceof NodeInfo || newSource instanceof PullSource || newSource instanceof AugmentedSource || newSource instanceof EventSource) {
            Sender.send(newSource, next, options);
        }
        List<ExternalObjectModel> externalObjectModels = config.getExternalObjectModels();
        for (ExternalObjectModel externalObjectModel : externalObjectModels) {
            ExternalObjectModel model = externalObjectModel;
            boolean done = model.sendSource(source, next);
            if (!done) continue;
            return;
        }
        throw new XPathException("A source of type " + source.getClass().getName() + " is not supported in this environment");
    }

    private static void sendDocumentInfo(NodeInfo top, Receiver receiver) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        NamePool targetNamePool = pipe.getConfiguration().getNamePool();
        if (top.getNamePool() != targetNamePool) {
            receiver = new NamePoolConverter(receiver, top.getNamePool(), targetNamePool);
        }
        LocationCopier copier = new LocationCopier(top instanceof DocumentInfo);
        pipe.setComponent(CopyInformee.class.getName(), copier);
        pipe.setLocationProvider(copier);
        receiver.open();
        receiver.startDocument(0);
        top.copy(receiver, 6, 0);
        receiver.endDocument();
        receiver.close();
    }

    private static void sendSAXSource(SAXSource source, Receiver receiver, ParseOptions options) throws XPathException {
        ReceivingContentHandler ce;
        boolean dtdRecover;
        ErrorHandler errorHandler;
        ErrorListener listener;
        Configuration config;
        boolean reuseParser;
        XMLReader parser;
        PipelineConfiguration pipe;
        block44: {
            pipe = receiver.getPipelineConfiguration();
            parser = source.getXMLReader();
            reuseParser = false;
            config = pipe.getConfiguration();
            listener = options.getErrorListener();
            if (listener == null) {
                listener = pipe.getErrorListener();
            }
            if ((errorHandler = options.getErrorHandler()) == null) {
                errorHandler = new StandardErrorHandler(listener);
            }
            if (parser == null) {
                parser = options.getXMLReader();
            }
            if (parser == null) {
                SAXSource ss = new SAXSource();
                ss.setInputSource(source.getInputSource());
                ss.setSystemId(source.getSystemId());
                parser = config.getSourceParser();
                parser.setErrorHandler(errorHandler);
                if (options.getEntityResolver() != null && parser.getEntityResolver() == null) {
                    parser.setEntityResolver(options.getEntityResolver());
                }
                ss.setXMLReader(parser);
                source = ss;
                reuseParser = true;
            } else {
                Sender.configureParser(parser);
                if (parser.getErrorHandler() == null) {
                    parser.setErrorHandler(errorHandler);
                }
            }
            if (!pipe.isExpandAttributeDefaults()) {
                try {
                    parser.setFeature("http://xml.org/sax/features/use-attributes2", true);
                }
                catch (SAXNotRecognizedException err) {
                }
                catch (SAXNotSupportedException err) {
                    // empty catch block
                }
            }
            boolean dtdValidation = options.getDTDValidationMode() == 1 || options.getDTDValidationMode() == 2;
            dtdRecover = options.getDTDValidationMode() == 2;
            try {
                parser.setFeature("http://xml.org/sax/features/validation", dtdValidation);
            }
            catch (SAXNotRecognizedException err) {
                if (dtdValidation) {
                    throw new XPathException("XML Parser does not recognize request for DTD validation", err);
                }
            }
            catch (SAXNotSupportedException err) {
                if (!dtdValidation) break block44;
                throw new XPathException("XML Parser does not support DTD validation", err);
            }
        }
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            boolean tryAgain = false;
            try {
                parser.setFeature("http://apache.org/xml/features/xinclude-aware", true);
            }
            catch (SAXNotRecognizedException err) {
                tryAgain = true;
            }
            catch (SAXNotSupportedException err) {
                tryAgain = true;
            }
            if (tryAgain) {
                try {
                    parser.setFeature("http://apache.org/xml/features/xinclude", true);
                }
                catch (SAXNotRecognizedException err) {
                    throw new XPathException("Selected XML parser " + parser.getClass().getName() + " does not recognize request for XInclude processing", err);
                }
                catch (SAXNotSupportedException err) {
                    throw new XPathException("Selected XML parser " + parser.getClass().getName() + " does not support XInclude processing", err);
                }
            }
        }
        receiver = Sender.makeValidator(receiver, source.getSystemId(), options);
        ContentHandler ch = parser.getContentHandler();
        if (ch instanceof ReceivingContentHandler && config.isCompatible(((ReceivingContentHandler)ch).getConfiguration())) {
            ce = (ReceivingContentHandler)ch;
            ce.reset();
        } else {
            ce = new ReceivingContentHandler();
            parser.setContentHandler(ce);
            parser.setDTDHandler(ce);
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", ce);
            }
            catch (SAXNotSupportedException err) {
            }
            catch (SAXNotRecognizedException err) {
                // empty catch block
            }
        }
        ce.setReceiver(receiver);
        ce.setPipelineConfiguration(pipe);
        try {
            parser.parse(source.getInputSource());
        }
        catch (SAXException err) {
            Exception nested = err.getException();
            if (nested instanceof XPathException) {
                throw (XPathException)nested;
            }
            if (nested instanceof RuntimeException) {
                throw (RuntimeException)nested;
            }
            if (errorHandler instanceof StandardErrorHandler && ((StandardErrorHandler)errorHandler).getFatalErrorCount() == 0 || err instanceof SAXParseException && ((SAXParseException)err).getSystemId() == null && source.getSystemId() != null) {
                XPathException de = new XPathException("Error reported by XML parser processing " + source.getSystemId() + ": " + err.getMessage(), err);
                try {
                    listener.fatalError(de);
                    de.setHasBeenReported(true);
                }
                catch (TransformerException e) {
                    // empty catch block
                }
                throw de;
            }
            XPathException de = new XPathException(err);
            de.setErrorCode("SXXP0003");
            de.setHasBeenReported(true);
            throw de;
        }
        catch (IOException err) {
            throw new XPathException("I/O error reported by XML parser processing " + source.getSystemId() + ": " + err.getMessage(), err);
        }
        if (errorHandler instanceof StandardErrorHandler) {
            int errs = ((StandardErrorHandler)errorHandler).getFatalErrorCount();
            if (errs > 0) {
                throw new XPathException("The XML parser reported " + errs + (errs == 1 ? " error" : " errors"));
            }
            errs = ((StandardErrorHandler)errorHandler).getErrorCount();
            if (errs > 0) {
                String message = "The XML parser reported " + new Numberer_en().toWords(errs).toLowerCase() + " validation error" + (errs == 1 ? "" : "s");
                if (dtdRecover) {
                    message = message + ". Processing continues, because recovery from validation errors was requested";
                    try {
                        listener.warning(new XPathException(message));
                    }
                    catch (TransformerException e) {}
                } else {
                    throw new XPathException(message);
                }
            }
        }
        if (reuseParser) {
            config.reuseSourceParser(parser);
        }
    }

    private static Receiver makeValidator(Receiver receiver, String systemId, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        Configuration config = pipe.getConfiguration();
        int sv = options.getSchemaValidationMode();
        if (sv != 3 && sv != 0) {
            Controller controller = pipe.getController();
            if (controller != null && !controller.getExecutable().isSchemaAware() && sv != 4) {
                throw new XPathException("Cannot use schema-validated input documents when the query/stylesheet is not schema-aware");
            }
            receiver = config.getDocumentValidator(receiver, systemId, options);
        }
        return receiver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendPullSource(PullSource source, Receiver receiver, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = Sender.makeValidator(receiver, source.getSystemId(), options);
        PullProvider provider = source.getPullProvider();
        if (provider instanceof LocationProvider) {
            pipe.setLocationProvider((LocationProvider)((Object)provider));
        }
        provider.setPipelineConfiguration(pipe);
        receiver.setPipelineConfiguration(pipe);
        PullPushCopier copier = new PullPushCopier(provider, receiver);
        try {
            copier.copy();
        }
        finally {
            if (options.isPleaseCloseAfterUse()) {
                provider.close();
            }
        }
    }

    private static void sendPullEventSource(PullEventSource source, Receiver receiver, ParseOptions options) throws XPathException {
        PipelineConfiguration pipe = receiver.getPipelineConfiguration();
        boolean xInclude = options.isXIncludeAware();
        if (xInclude) {
            throw new XPathException("XInclude processing is not supported with a pull parser");
        }
        receiver = Sender.makeValidator(receiver, source.getSystemId(), options);
        receiver.open();
        EventIterator provider = source.getEventIterator();
        if (provider instanceof LocationProvider) {
            pipe.setLocationProvider((LocationProvider)((Object)provider));
        }
        receiver.setPipelineConfiguration(pipe);
        SequenceReceiver out = receiver instanceof SequenceReceiver ? (SequenceReceiver)receiver : new TreeReceiver(receiver);
        EventIteratorToReceiver.copy(provider, out);
        receiver.close();
    }

    public static void configureParser(XMLReader parser) throws XPathException {
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespaces' feature", err);
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespaces' feature to true", err);
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotSupportedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not recognize the 'namespace-prefixes' feature", err);
        }
        catch (SAXNotRecognizedException err) {
            throw new XPathException("The SAX2 parser " + parser.getClass().getName() + " does not support setting the 'namespace-prefixes' feature to false", err);
        }
    }

    static {
        try {
            staxSourceClass = Class.forName("javax.xml.transform.stax.StAXSource");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

