import leather


def scatterplot(self, x=0, y=1, path=None, width=None, height=None):
    """
    Render a scatterplot using :class:`leather.Chart`.

    :param x:
        The name or index of a column to plot as the x-axis. Defaults to the
        first column in the table.
    :param y:
        The name or index of a column to plot as the y-axis. Defaults to the
        second column in the table.
    :param path:
        If specified, the resulting SVG will be saved to this location. If
        :code:`None` and running in IPython, then the SVG will be rendered
        inline. Otherwise, the SVG data will be returned as a string.
    :param width:
        The width of the output SVG.
    :param height:
        The height of the output SVG.
    """
    if type(x) is int:
        x_name = self.column_names[x]
    else:
        x_name = x

    if type(y) is int:
        y_name = self.column_names[y]
    else:
        y_name = y

    chart = leather.Chart()
    chart.add_x_axis(name=x_name)
    chart.add_y_axis(name=y_name)
    chart.add_dots(self, x=x, y=y)

    return chart.to_svg(path=path, width=width, height=height)
