<?php

namespace Drupal\inline_form_errors\Hook;

use Drupal\inline_form_errors\RenderElementHelper;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for inline_form_errors.
 */
class InlineFormErrorsHooks {

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match) {
    switch ($route_name) {
      case 'help.page.inline_form_errors':
        $output = '';
        $output .= '<h2>' . t('About') . '</h2>';
        $output .= '<p>' . t('The Inline Form Errors module makes it easier for users to identify which errors need to be resolved by providing a summary of all errors and by placing the individual error messages next to the form elements themselves. For more information, see the <a href=":inline_form_error">online documentation for the Inline Form Errors module</a>.', [
          ':inline_form_error' => 'https://www.drupal.org/docs/8/core/modules/inline-form-errors',
        ]) . '</p>';
        $output .= '<h2>' . t('Uses') . '</h2>';
        $output .= '<dl>';
        $output .= '<dt>' . t('Displaying error messages') . '</dt>';
        $output .= '<dd>' . t('When a form is not filled in correctly (for example, if a required field is left blank), a warning message is displayed at the top of the form. This message links to the affected form elements, and individual error messages are displayed next to each form element.') . '</dd>';
        $output .= '<dt>' . t('Displaying error messages in browsers with HTML5 form validation') . '</dt>';
        $output .= '<dd>' . t('In browsers that support HTML5 form validation, users will first see the error messages generated by their browser. In this case, the inline form error messages are only displayed after the HTML5 validation errors have been resolved.') . '</dd>';
        return $output;
    }
  }

  /**
   * Implements hook_element_info_alter().
   */
  #[Hook('element_info_alter')]
  public function elementInfoAlter(array &$info): void {
    \Drupal::classResolver(RenderElementHelper::class)->alterElementInfo($info);
  }

}
