/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.web;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import org.opensolaris.opengrok.OpenGrokLogger;

public class EftarFile {
    public static final int RECORD_LENGTH = 14;
    private long offset;
    private Node root;

    public static long myHash(String name) {
        if (name == null || name.length() == 0) {
            return 0L;
        }
        long hash = 2861L;
        int n = name.length();
        if (n > 100) {
            n = 100;
        }
        for (int i = 0; i < n; ++i) {
            hash = (hash * 641L + (long)(name.charAt(i) * 2969) + hash << 6) % 9322397L;
        }
        return hash;
    }

    private void write(Node n, DataOutputStream out) throws IOException {
        if (n.tag != null) {
            out.write(n.tag.getBytes());
            this.offset += (long)n.tag.length();
        }
        for (Node childnode : n.children.values()) {
            out.writeLong(childnode.hash);
            if (childnode.children.size() > 0) {
                out.writeShort((short)(childnode.childOffset - this.offset));
                out.writeShort((short)childnode.children.size());
            } else {
                out.writeShort(0);
                if (childnode.tag == null) {
                    out.writeShort(0);
                } else {
                    out.writeShort((short)childnode.tag.length());
                }
            }
            if (childnode.tag == null) {
                out.writeShort(0);
            } else {
                out.writeShort((short)(childnode.tagOffset - this.offset));
            }
            this.offset += 14L;
        }
        for (Node childnode : n.children.values()) {
            this.write(childnode, out);
        }
    }

    private void traverse(Node n) {
        if (n.tag == null) {
            n.tagOffset = 0L;
        } else {
            n.tagOffset = this.offset;
            this.offset += (long)n.tag.length();
        }
        if (n.children.size() > 0) {
            n.childOffset = this.offset;
            this.offset += (long)(14 * n.children.size());
        } else {
            n.childOffset = 0L;
        }
        for (Node childnode : n.children.values()) {
            this.traverse(childnode);
        }
    }

    public void readInput(String tagsPath) throws IOException {
        try (BufferedReader r = new BufferedReader(new FileReader(tagsPath));){
            this.readInput(r);
        }
    }

    private void readInput(BufferedReader r) throws IOException {
        String line;
        if (this.root == null) {
            this.root = new Node(1L, null);
        }
        while ((line = r.readLine()) != null) {
            int tab = line.indexOf(9);
            if (tab <= 0) continue;
            String path = line.substring(0, tab);
            String desc = line.substring(tab + 1);
            StringTokenizer toks = new StringTokenizer(path, "\\/");
            Node n = this.root;
            while (toks.hasMoreTokens()) {
                n = n.put(EftarFile.myHash(toks.nextToken()), null);
            }
            n.tag = desc;
        }
    }

    public void write(String outPath) throws FileNotFoundException, IOException {
        this.offset = 14L;
        this.traverse(this.root);
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outPath)));){
            out.writeLong(24115L);
            out.writeShort(14);
            out.writeShort(this.root.children.size());
            out.writeShort(0);
            this.offset = 14L;
            this.write(this.root, out);
        }
    }

    public void create(String[] args) throws IOException, FileNotFoundException {
        for (int i = 0; i < args.length - 1; ++i) {
            this.readInput(args[i]);
        }
        this.write(args[args.length - 1]);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage inputFile [inputFile ...] outputFile");
            System.exit(1);
        }
        try {
            EftarFile ef = new EftarFile();
            ef.create(args);
        }
        catch (Exception e) {
            OpenGrokLogger.getLogger().log(Level.WARNING, "EftarFile error", e);
        }
    }

    class FNode {
        public long offset;
        public long hash;
        public int childOffset;
        public int numChildren;
        public int tagOffset;

        public FNode(RandomAccessFile f) throws Throwable {
            this.offset = f.getFilePointer();
            this.hash = f.readLong();
            this.childOffset = f.readUnsignedShort();
            this.numChildren = f.readUnsignedShort();
            this.tagOffset = f.readUnsignedShort();
        }

        public FNode(long hash, long offset, int childOffset, int num, int tagOffset) {
            this.hash = hash;
            this.offset = offset;
            this.childOffset = childOffset;
            this.numChildren = num;
            this.tagOffset = tagOffset;
        }

        public FNode get(long hash, RandomAccessFile f) throws Throwable {
            if (this.childOffset == 0) {
                return null;
            }
            return this.sbinSearch(this.offset + (long)this.childOffset, this.numChildren, hash, f);
        }

        private FNode sbinSearch(long start, int len, long hash, RandomAccessFile f) throws Throwable {
            int b = 0;
            int e = len;
            while (b <= e) {
                int m = (b + e) / 2;
                f.seek(start + (long)(m * 14));
                long mhash = f.readLong();
                if (hash > mhash) {
                    b = m + 1;
                    continue;
                }
                if (hash < mhash) {
                    e = m - 1;
                    continue;
                }
                return new FNode(mhash, f.getFilePointer() - 8L, f.readUnsignedShort(), f.readUnsignedShort(), f.readUnsignedShort());
            }
            return null;
        }
    }

    class Node {
        public long hash;
        public String tag;
        public Map<Long, Node> children;
        public long tagOffset;
        public long childOffset;
        public long myOffset;

        public Node(long hash, String tag) {
            this.hash = hash;
            this.tag = tag;
            this.children = new TreeMap<Long, Node>();
        }

        public Node put(long hash, String desc) {
            if (this.children.get(hash) == null) {
                this.children.put(hash, new Node(hash, desc));
            }
            return this.children.get(hash);
        }

        public Node get(long hash) {
            return this.children.get(hash);
        }
    }
}

