/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.search.context;

import org.opensolaris.opengrok.search.context.LineMatcher;

public class WildCardMatcher
extends LineMatcher {
    final String pattern;
    public static final char WILDCARD_STRING = '*';
    public static final char WILDCARD_CHAR = '?';

    public WildCardMatcher(String pattern, boolean caseInsensitive) {
        super(caseInsensitive);
        this.pattern = this.normalizeString(pattern);
    }

    @Override
    public int match(String token) {
        String tokenToMatch = this.normalizeString(token);
        return WildCardMatcher.wildcardEquals(this.pattern, 0, tokenToMatch, 0) ? 1 : 0;
    }

    public static boolean wildcardEquals(String pattern, int patternIdx, String string, int stringIdx) {
        int p = patternIdx;
        int s = stringIdx;
        while (true) {
            boolean pEnd;
            boolean sEnd = s >= string.length();
            boolean bl = pEnd = p >= pattern.length();
            if (sEnd) {
                boolean justWildcardsLeft = true;
                int wildcardSearchPos = p;
                while (wildcardSearchPos < pattern.length() && justWildcardsLeft) {
                    char wildchar = pattern.charAt(wildcardSearchPos);
                    if (wildchar != '?' && wildchar != '*') {
                        justWildcardsLeft = false;
                        continue;
                    }
                    if (wildchar == '?') {
                        return false;
                    }
                    ++wildcardSearchPos;
                }
                if (justWildcardsLeft) {
                    return true;
                }
            }
            if (sEnd || pEnd) break;
            if (pattern.charAt(p) != '?') {
                if (pattern.charAt(p) == '*') {
                    while (p < pattern.length() && pattern.charAt(p) == '*') {
                        ++p;
                    }
                    for (int i = string.length(); i >= s; --i) {
                        if (!WildCardMatcher.wildcardEquals(pattern, p, string, i)) continue;
                        return true;
                    }
                    break;
                }
                if (pattern.charAt(p) != string.charAt(s)) break;
            }
            ++p;
            ++s;
        }
        return false;
    }
}

