/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok.history;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opensolaris.opengrok.OpenGrokLogger;
import org.opensolaris.opengrok.history.History;
import org.opensolaris.opengrok.history.HistoryEntry;
import org.opensolaris.opengrok.history.HistoryException;
import org.opensolaris.opengrok.history.SSCMRepository;
import org.opensolaris.opengrok.util.Executor;

public class SSCMHistoryParser
implements Executor.StreamHandler {
    private final SSCMRepository repository;
    private static final String ACTION_PATTERN = "[a-z][a-z ]+";
    private static final String USER_PATTERN = "\\w+";
    private static final String VERSION_PATTERN = "\\d+";
    private static final String TIME_PATTERN = "\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{2} [AP]M";
    private static final String COMMENT_START_PATTERN = "Comments - ";
    private static final Pattern HISTORY_PATTERN = Pattern.compile("^([a-z][a-z ]+)(?:\\[(.*?)\\])?\\s+(\\w+)\\s+(\\d+)\\s+(\\d{1,2}/\\d{1,2}/\\d{4} \\d{1,2}:\\d{2} [AP]M)$\\s*(?:Comments - )?", 8);
    private static final String NEWLINE = System.getProperty("line.separator");
    private History history;

    SSCMHistoryParser(SSCMRepository repository) {
        this.repository = repository;
    }

    @Override
    public void processStream(InputStream input) throws IOException {
        String line;
        DateFormat df = this.repository.getDateFormat();
        this.history = new History();
        BufferedReader in = new BufferedReader(new InputStreamReader(input));
        StringBuilder total = new StringBuilder(input.available());
        while ((line = in.readLine()) != null) {
            total.append(line).append(NEWLINE);
        }
        ArrayList<HistoryEntry> entries = new ArrayList<HistoryEntry>();
        HistoryEntry entry = null;
        int prevEntryEnd = 0;
        long revisionCounter = 0L;
        Matcher matcher = HISTORY_PATTERN.matcher(total);
        while (matcher.find()) {
            if (entry != null) {
                if (matcher.start() != prevEntryEnd) {
                    entry.appendMessage(total.substring(prevEntryEnd, matcher.start()).replaceAll("(\\r?\\n){2}", " $1").trim());
                }
                entries.add(0, entry);
                entry = null;
            }
            String revision = matcher.group(4);
            String author = matcher.group(3);
            String context = matcher.group(2);
            String date = matcher.group(5);
            long currentRevision = 0L;
            try {
                currentRevision = Long.parseLong(revision);
            }
            catch (NumberFormatException ex) {
                OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to parse revision: '" + revision + "'", ex);
            }
            if (revisionCounter < currentRevision) {
                revisionCounter = currentRevision;
                entry = new HistoryEntry();
                if (context != null) {
                    entry.appendMessage("[" + context + "] ");
                }
                entry.setAuthor(author);
                entry.setRevision(revision);
                try {
                    entry.setDate(df.parse(date));
                }
                catch (ParseException ex) {
                    OpenGrokLogger.getLogger().log(Level.WARNING, "Failed to parse date: '" + date + "'", ex);
                }
                entry.setActive(true);
            }
            prevEntryEnd = matcher.end();
        }
        if (entry != null) {
            if (total.length() != prevEntryEnd) {
                entry.appendMessage(total.substring(prevEntryEnd).replaceAll("(\\r?\\n){2}", " $1").trim());
            }
            entries.add(0, entry);
        }
        this.history.setHistoryEntries(entries);
    }

    History parse(File file, String sinceRevision) throws HistoryException {
        try {
            Executor executor = this.repository.getHistoryLogExecutor(file, sinceRevision);
            int status = executor.exec(true, this);
            if (status != 0) {
                throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\" Exit code: " + status);
            }
        }
        catch (IOException e) {
            throw new HistoryException("Failed to get history for: \"" + file.getAbsolutePath() + "\"", e);
        }
        return this.history;
    }

    History parse(String buffer) throws IOException {
        this.processStream(new ByteArrayInputStream(buffer.getBytes("UTF-8")));
        return this.history;
    }
}

