/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.opengrok;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.opensolaris.opengrok.ConsoleFormatter;
import org.opensolaris.opengrok.FileLogFormatter;

public final class OpenGrokLogger {
    private static int LOGFILESIZELIMIT = 1000000;
    private static int LOGFILESCOUNT = 30;
    private static final Logger log = Logger.getLogger("org.opensolaris.opengrok");
    private static Level consoleLevel = Level.WARNING;
    private static Level fileLevel = Level.FINE;
    private static String filepath = "";

    public static String getFileLogPath() {
        return filepath;
    }

    public static Logger getLogger() {
        return log;
    }

    public static void setConsoleLogLevel(Level level) {
        Handler[] handlers = log.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler h = handlers[i];
            if (!(h instanceof ConsoleHandler)) continue;
            h.setLevel(level);
            consoleLevel = level;
        }
    }

    public static Level getConsoleLogLevel() {
        return consoleLevel;
    }

    public static void setOGConsoleLogLevel(Level level) {
        Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
        while (e.hasMoreElements()) {
            String loggerName = e.nextElement();
            Logger l = Logger.getLogger(loggerName);
            Handler[] h = l.getHandlers();
            if (!loggerName.startsWith("org.opensolaris.opengrok")) {
                for (int i = 0; i < h.length; ++i) {
                    Handler hi = h[i];
                    if (!(hi instanceof ConsoleHandler)) continue;
                    hi.setLevel(level);
                }
            }
            h = l.getHandlers();
        }
    }

    public static void setFileLogLevel(Level level) {
        Handler[] handlers = log.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler h = handlers[i];
            if (!(h instanceof FileHandler)) continue;
            h.setLevel(level);
            fileLevel = level;
        }
    }

    public static Level getFileLogLevel() {
        return fileLevel;
    }

    public static void setFileLogPath(String path) throws IOException {
        File jlp;
        if (path != null && !(jlp = new File(path)).exists() && !jlp.mkdirs()) {
            throw new IOException("could not make logpath: " + jlp.getAbsolutePath());
        }
        StringBuffer logfile = path == null ? new StringBuffer("%t") : new StringBuffer(path);
        filepath = logfile.toString();
        logfile.append(File.separatorChar).append("opengrok%g.%u.log");
        Handler[] handlers = log.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            Handler h = handlers[i];
            if (!(h instanceof FileHandler)) continue;
            FileHandler fh = (FileHandler)h;
            FileHandler nfh = new FileHandler(logfile.toString(), LOGFILESIZELIMIT, LOGFILESCOUNT);
            nfh.setLevel(fh.getLevel());
            nfh.setFormatter(new FileLogFormatter());
            log.addHandler(nfh);
            log.removeHandler(fh);
        }
    }

    public static String setupLogger(String logpath, Level filelevel, Level consolelevel) throws IOException {
        System.out.println("Logging to " + logpath);
        if (logpath != null) {
            File jlp = new File(logpath);
            if (!jlp.exists() && !jlp.mkdirs()) {
                throw new RuntimeException("could not make logpath: " + jlp.getAbsolutePath());
            }
            if (!jlp.canWrite() && !Level.OFF.equals(filelevel)) {
                throw new IOException("logpath not writeable " + jlp.getAbsolutePath());
            }
        }
        OpenGrokLogger.clearForeignHandlers();
        StringBuffer logfile = logpath == null ? new StringBuffer("%t") : new StringBuffer(logpath);
        filepath = logfile.toString();
        logfile.append(File.separatorChar).append("opengrok%g.%u.log");
        try {
            FileHandler fh = new FileHandler(logfile.toString(), LOGFILESIZELIMIT, LOGFILESCOUNT);
            fh.setLevel(filelevel);
            fileLevel = filelevel;
            fh.setFormatter(new FileLogFormatter());
            log.addHandler(fh);
            ConsoleHandler ch = new ConsoleHandler();
            ch.setLevel(consolelevel);
            consoleLevel = consolelevel;
            ch.setFormatter(new ConsoleFormatter());
            log.addHandler(ch);
        }
        catch (Exception ex1) {
            System.err.println("Exception logging " + ex1);
            throw new IOException("Exception setting up logging " + ex1);
        }
        log.setLevel(filelevel);
        return logpath;
    }

    private static void clearForeignHandlers() {
        Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
        while (e.hasMoreElements()) {
            String loggerName = e.nextElement();
            Logger l = Logger.getLogger(loggerName);
            Handler[] h = l.getHandlers();
            if (!loggerName.startsWith("org.opensolaris.opengrok")) {
                for (int i = 0; i < h.length; ++i) {
                    l.removeHandler(h[i]);
                }
            }
            Handler[] handlerArray = l.getHandlers();
        }
    }

    private OpenGrokLogger() {
    }
}

