#include "mtl/matrix.h"
#include "mtl/mtl.h"
#include "mtl/utils.h"

/*
  Sample Out:
A
10x10
[
[0,0,2,0,4,0,6,0,8,0],
[10,0,12,0,14,0,16,0,18,0],
[20,0,22,0,24,0,26,0,28,0],
[30,0,32,0,34,0,36,0,38,0],
[40,0,42,0,44,0,46,0,48,0],
[50,0,52,0,54,0,56,0,58,0],
[60,0,62,0,64,0,66,0,68,0],
[70,0,72,0,74,0,76,0,78,0],
[80,0,82,0,84,0,86,0,88,0],
[90,0,92,0,94,0,96,0,98,0]
]
B
10x10
[
[0,0,2,0,4,0,6,0,8,0],
[10,0,12,0,14,0,16,0,18,0],
[20,0,22,0,24,0,26,0,28,0],
[30,0,32,0,34,0,36,0,38,0],
[40,0,42,0,44,0,46,0,48,0],
[50,0,52,0,54,0,56,0,58,0],
[60,0,62,0,64,0,66,0,68,0],
[70,0,72,0,74,0,76,0,78,0],
[80,0,82,0,84,0,86,0,88,0],
[90,0,92,0,94,0,96,0,98,0]
]
C
10x10
[
[0,0,2,0,4,0,6,0,8,0],
[10,0,12,0,14,0,16,0,18,0],
[20,0,22,0,24,0,26,0,28,0],
[30,0,32,0,34,0,36,0,38,0],
[40,0,42,0,44,0,46,0,48,0],
[50,0,52,0,54,0,56,0,58,0],
[60,0,62,0,64,0,66,0,68,0],
[70,0,72,0,74,0,76,0,78,0],
[80,0,82,0,84,0,86,0,88,0],
[90,0,92,0,94,0,96,0,98,0]
]
D
10x10
[
[0,0,2,0,4,0,6,0,8,0],
[10,0,12,0,14,0,16,0,18,0],
[20,0,22,0,24,0,26,0,28,0],
[30,0,32,0,34,0,36,0,38,0],
[40,0,42,0,44,0,46,0,48,0],
[50,0,52,0,54,0,56,0,58,0],
[60,0,62,0,64,0,66,0,68,0],
[70,0,72,0,74,0,76,0,78,0],
[80,0,82,0,84,0,86,0,88,0],
[90,0,92,0,94,0,96,0,98,0]
]
E
10x10
[
[0,0,2,0,4,0,6,0,8,0],
[10,0,12,0,14,0,16,0,18,0],
[20,0,22,0,24,0,26,0,28,0],
[30,0,32,0,34,0,36,0,38,0],
[40,0,42,0,44,0,46,0,48,0],
[50,0,52,0,54,0,56,0,58,0],
[60,0,62,0,64,0,66,0,68,0],
[70,0,72,0,74,0,76,0,78,0],
[80,0,82,0,84,0,86,0,88,0],
[90,0,92,0,94,0,96,0,98,0]
]

 */

using namespace mtl;

int
main()
{
  typedef matrix<double, rectangle<>, 
                 compressed<>, row_major>::type SparseRowMat;

  typedef matrix<double, rectangle<>, 
                 compressed<>, column_major>::type SparseColMat;

  typedef matrix<double, rectangle<>,
                 array< compressed<> >, row_major>::type SparseArrayMat;
    
  const int M = 10;
  const int N = 10;

  SparseRowMat A(M,N), B(M,N), C(M,N);
  SparseColMat D(M, N);

  SparseArrayMat E(M, N);

  int step = N / 5;


  for (int i = 0; i < M; ++i)
    for (int j = 0; j < N; j += step)
      A(i,j) = double(i * N + j);

  for (int j = 0; j < N; j += step)
    for (int i = 0; i < M; ++i)
      B(i,j) = double(i * N + j);

  copy(B, C);

  copy(C, D);

  copy(C, E);

  std::cout << "A" << std::endl;
  print_all_matrix(A);
  std::cout << "B" << std::endl;
  print_all_matrix(B);
  std::cout << "C" << std::endl;
  print_all_matrix(C);
  std::cout << "D" << std::endl;
  print_all_matrix(D);
  std::cout << "E" << std::endl;
  print_all_matrix(E);

  return 0;
}
