/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtRealSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirInconsistentTypeParameterHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.SourceNavigator;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0002!\"B\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004J(\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J(\u0010\u0016\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J \u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u001b\u001a\u00020\u001c*\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001dH\u0002J \u0010 \u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002#$\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterChecker;", "mppKind", "Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/MppCheckerKind;)V", "classKinds", "", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "check", "", "declaration", "containingDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkFinalUpperBounds", "checkExtensionFunctionTypeBound", "checkTypeAliasBound", "checkOnlyOneTypeParameterBound", "checkBoundUniqueness", "checkConflictingBounds", "checkDynamicBounds", "isRelated", "", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "checkInconsistentTypeParameterBounds", "Regular", "ForExpectClass", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,203:1\n37#2:204\n37#2:205\n1863#3,2:206\n1863#3,2:208\n774#3:210\n865#3,2:211\n1863#3,2:213\n1663#3,8:215\n3193#3,10:223\n774#3:233\n865#3,2:234\n774#3:236\n865#3,2:237\n1663#3,8:239\n1863#3,2:247\n1863#3,2:249\n1557#3:251\n1628#3,3:252\n1863#3,2:255\n1863#3:257\n1863#3,2:258\n1864#3:260\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker\n*L\n75#1:204\n76#1:205\n78#1:206,2\n86#1:208,2\n100#1:210\n100#1:211,2\n100#1:213,2\n107#1:215,8\n108#1:223,10\n115#1:233\n115#1:234,2\n131#1:236\n131#1:237,2\n132#1:239,8\n134#1:247,2\n142#1:249,2\n163#1:251\n163#1:252,3\n170#1:255,2\n149#1:257\n151#1:258,2\n149#1:260\n*E\n"})
public abstract class FirTypeParameterBoundsChecker
extends FirDeclarationChecker<FirTypeParameter> {
    @NotNull
    private final Set<ClassKind> classKinds;

    private FirTypeParameterBoundsChecker(MppCheckerKind mppKind) {
        super(mppKind);
        ClassKind[] classKindArray = new ClassKind[]{ClassKind.CLASS, ClassKind.ENUM_CLASS, ClassKind.OBJECT};
        this.classKinds = SetsKt.setOf(classKindArray);
    }

    protected final void check(@NotNull FirTypeParameter declaration, @NotNull FirDeclaration containingDeclaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(containingDeclaration, "containingDeclaration");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        if (containingDeclaration instanceof FirConstructor) {
            return;
        }
        this.checkFinalUpperBounds(declaration, containingDeclaration, context, reporter);
        this.checkExtensionFunctionTypeBound(declaration, context, reporter);
        FirMemberDeclaration firMemberDeclaration = containingDeclaration instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration : null;
        if (!(firMemberDeclaration != null ? FirHelpersKt.isInlineOnly(firMemberDeclaration, context.getSession()) : false)) {
            this.checkOnlyOneTypeParameterBound(declaration, context, reporter);
        }
        this.checkBoundUniqueness(declaration, context, reporter);
        this.checkConflictingBounds(declaration, context, reporter);
        this.checkTypeAliasBound(declaration, containingDeclaration, context, reporter);
        this.checkDynamicBounds(declaration, context, reporter);
        this.checkInconsistentTypeParameterBounds(declaration, context, reporter);
    }

    private final void checkFinalUpperBounds(FirTypeParameter declaration, FirDeclaration containingDeclaration, CheckerContext context, DiagnosticReporter reporter) {
        boolean $i$f$isOverride;
        FirMemberDeclaration $this$isOverride$iv;
        if (containingDeclaration instanceof FirSimpleFunction) {
            $this$isOverride$iv = (FirMemberDeclaration)containingDeclaration;
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        if (containingDeclaration instanceof FirProperty) {
            $this$isOverride$iv = (FirMemberDeclaration)containingDeclaration;
            $i$f$isOverride = false;
            if ($this$isOverride$iv.getStatus().isOverride()) {
                return;
            }
        }
        Iterable $this$forEach$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (TypeUtilsKt.canHaveSubtypesAccordingToK1(bound.getConeType(), context.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getFINAL_UPPER_BOUND(), (Object)bound.getConeType(), (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkExtensionFunctionTypeBound(FirTypeParameter declaration, CheckerContext context, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (!TypeUtilsKt.isExtensionFunctionType(bound, context.getSession())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getUPPER_BOUND_IS_EXTENSION_FUNCTION_TYPE(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeAliasBound(FirTypeParameter declaration, FirDeclaration containingDeclaration, CheckerContext context, DiagnosticReporter reporter) {
        if (containingDeclaration instanceof FirTypeAlias) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = declaration.getBounds();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirTypeRef it = (FirTypeRef)element$iv$iv;
                boolean bl = false;
                KtSourceElement ktSourceElement = it.getSource();
                if (!Intrinsics.areEqual(ktSourceElement != null ? ktSourceElement.getKind() : null, KtRealSourceElementKind.INSTANCE)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeRef bound = (FirTypeRef)element$iv;
                boolean bl = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getBOUND_ON_TYPE_ALIAS_PARAMETER_NOT_ALLOWED(), (DiagnosticContext)context, null, 8, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(FirTypeParameter declaration, CheckerContext context, DiagnosticReporter reporter) {
        Iterable $this$distinctBy$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$distinctBy = false;
        HashSet<ConeKotlinType> set$iv = new HashSet<ConeKotlinType>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)e$iv;
            boolean bl = false;
            ConeKotlinType key$iv = it.getConeType();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List bounds = list$iv;
        Iterable $this$partition$iv = bounds;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            boolean bl2 = it.getConeType() instanceof ConeTypeParameterType ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List boundWithParam = pair.component1();
        List otherBounds = pair.component2();
        if (boundWithParam.size() > 1 || boundWithParam.size() == 1 && !((Collection)otherBounds).isEmpty()) {
            KtSourceElement ktSourceElement;
            void $this$filterTo$iv$iv;
            SourceNavigator $this$checkOnlyOneTypeParameterBound_u24lambda_u247 = SourceNavigator.Companion.forElement(declaration);
            boolean bl = false;
            Iterable $this$filter$iv = bounds;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                boolean bl3 = false;
                if (!$this$checkOnlyOneTypeParameterBound_u24lambda_u247.isInTypeConstraint(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set constraintBounds = CollectionsKt.toSet((List)destination$iv$iv);
            if (bounds.size() == 2) {
                FirResolvedTypeRef boundDecl;
                FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.firstOrNull(otherBounds);
                if (firResolvedTypeRef == null) {
                    firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.last(boundWithParam);
                }
                ktSourceElement = constraintBounds.contains(boundDecl = firResolvedTypeRef) ? boundDecl.getSource() : declaration.getSource();
            } else {
                ktSourceElement = declaration.getSource();
            }
            KtSourceElement reportOn = ktSourceElement;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)reportOn, FirErrors.INSTANCE.getBOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkBoundUniqueness(FirTypeParameter declaration, CheckerContext context, DiagnosticReporter reporter) {
        FirResolvedTypeRef bound;
        FirResolvedTypeRef it;
        void $this$filterTo$iv$iv;
        Set seenClasses = new LinkedHashSet();
        Iterable $this$filter$iv = declaration.getSymbol().getResolvedBounds();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (FirResolvedTypeRef)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof FirErrorTypeRef))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allNonErrorBounds = (List)destination$iv$iv;
        Iterable $this$distinctBy$iv = allNonErrorBounds;
        boolean $i$f$distinctBy = false;
        HashSet<ClassId> set$iv = new HashSet<ClassId>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            ClassId key$iv;
            it = (FirResolvedTypeRef)e$iv;
            boolean bl = false;
            Object object = FirHelpersKt.fullyExpandedClassId(it.getConeType(), context.getSession());
            if (object == null) {
                object = it.getConeType();
            }
            if (!set$iv.add(key$iv = object)) continue;
            list$iv.add(e$iv);
        }
        List uniqueBounds = list$iv;
        Iterable $this$forEach$iv = uniqueBounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirRegularClassSymbol symbol;
            bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (ToSymbolUtilsKt.toRegularClassSymbol(bound.getConeType(), context.getSession()) == null) continue;
            boolean bl2 = false;
            if (!this.classKinds.contains((Object)symbol.getClassKind()) || !seenClasses.add(symbol) || seenClasses.size() <= 1) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getONLY_ONE_CLASS_BOUND_ALLOWED(), (DiagnosticContext)context, null, 8, null);
        }
        $this$forEach$iv = CollectionsKt.minus((Iterable)allNonErrorBounds, uniqueBounds);
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            bound = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getREPEATED_BOUND(), (DiagnosticContext)context, null, 8, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConflictingBounds(FirTypeParameter declaration, CheckerContext context, DiagnosticReporter reporter) {
        block5: {
            block4: {
                Collection<ConeKotlinType> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Object object = CollectionsKt.singleOrNull(declaration.getBounds());
                if (object != null && (object = FirTypeUtilsKt.getConeType((FirTypeRef)object)) != null ? ConeBuiltinTypeUtilsKt.isNothing((ConeKotlinType)object) : false) break block4;
                if (declaration.getBounds().size() < 2) break block5;
                Iterable iterable = declaration.getSymbol().getResolvedBounds();
                FirTypeParameterBoundsChecker firTypeParameterBoundsChecker = this;
                CheckerContext checkerContext = context;
                boolean $i$f$map = false;
                void var6_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getConeType());
                }
                collection = (List)destination$iv$iv;
                if (!FirTypeParameterBoundsChecker.checkConflictingBounds$anyConflictingTypes(checkerContext, firTypeParameterBoundsChecker, (List<? extends ConeKotlinType>)collection)) break block5;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getCONFLICTING_UPPER_BOUNDS(), (Object)declaration.getSymbol(), (DiagnosticContext)context, null, 16, null);
        }
    }

    private final void checkDynamicBounds(FirTypeParameter declaration, CheckerContext context, DiagnosticReporter reporter) {
        Iterable $this$forEach$iv = declaration.getBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeRef bound = (FirTypeRef)element$iv;
            boolean bl = false;
            if (!(FirTypeUtilsKt.getConeType(bound) instanceof ConeDynamicType)) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)bound.getSource(), FirErrors.INSTANCE.getDYNAMIC_UPPER_BOUND(), (DiagnosticContext)context, null, 8, null);
        }
    }

    private final boolean isRelated(KotlinTypeMarker $this$isRelated, TypeCheckerProviderContext context, KotlinTypeMarker type2) {
        return TypeUtilsKt.isSubtypeOf($this$isRelated, context, type2) || FirHelpersKt.isSupertypeOf($this$isRelated, context, type2);
    }

    private final void checkInconsistentTypeParameterBounds(FirTypeParameter declaration, CheckerContext context, DiagnosticReporter reporter) {
        if (declaration.getBounds().size() <= 1) {
            return;
        }
        List firTypeRefClasses = new ArrayList();
        Set firRegularClassesSet = new LinkedHashSet();
        for (FirResolvedTypeRef bound : declaration.getSymbol().getResolvedBounds()) {
            FirRegularClassSymbol classSymbol;
            if (FirHelpersKt.toRegularClassSymbol(bound, context.getSession()) == null) continue;
            if (!firRegularClassesSet.add(classSymbol)) {
                return;
            }
            firTypeRefClasses.add(TuplesKt.to(bound, classSymbol));
        }
        FirInconsistentTypeParameterHelpersKt.checkInconsistentTypeParameters(firTypeRefClasses, context, reporter, declaration.getSource(), false);
    }

    private static final boolean checkConflictingBounds$anyConflictingTypes(CheckerContext $context, FirTypeParameterBoundsChecker this$0, List<? extends ConeKotlinType> types2) {
        Iterable $this$forEach$iv = types2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConeKotlinType type2 = (ConeKotlinType)element$iv;
            boolean bl = false;
            if (TypeUtilsKt.canHaveSubtypesAccordingToK1(type2, $context.getSession())) continue;
            Iterable $this$forEach$iv2 = types2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                ConeKotlinType otherType = (ConeKotlinType)element$iv2;
                boolean bl2 = false;
                if (Intrinsics.areEqual(type2, otherType) || this$0.isRelated(type2, TypeComponentsKt.getTypeContext($context.getSession()), otherType)) continue;
                return true;
            }
        }
        return false;
    }

    public /* synthetic */ FirTypeParameterBoundsChecker(MppCheckerKind mppKind, DefaultConstructorMarker $constructor_marker) {
        this(mppKind);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,203:1\n34#2:204\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$ForExpectClass\n*L\n36#1:204\n*E\n"})
    public static final class ForExpectClass
    extends FirTypeParameterBoundsChecker {
        @NotNull
        public static final ForExpectClass INSTANCE = new ForExpectClass();

        private ForExpectClass() {
            super(MppCheckerKind.Common, null);
        }

        @Override
        public void check(@NotNull FirTypeParameter declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirDeclaration firDeclaration = CollectionsKt.lastOrNull(context.getContainingDeclarations());
            if (firDeclaration == null) {
                return;
            }
            FirDeclaration containingDeclaration = firDeclaration;
            FirMemberDeclaration firMemberDeclaration = containingDeclaration instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (!bl) {
                return;
            }
            this.check(declaration, containingDeclaration, context, reporter);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nFirTypeParameterBoundsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,203:1\n34#2:204\n*S KotlinDebug\n*F\n+ 1 FirTypeParameterBoundsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirTypeParameterBoundsChecker$Regular\n*L\n28#1:204\n*E\n"})
    public static final class Regular
    extends FirTypeParameterBoundsChecker {
        @NotNull
        public static final Regular INSTANCE = new Regular();

        private Regular() {
            super(MppCheckerKind.Platform, null);
        }

        @Override
        public void check(@NotNull FirTypeParameter declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
            boolean bl;
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            FirDeclaration firDeclaration = CollectionsKt.lastOrNull(context.getContainingDeclarations());
            if (firDeclaration == null) {
                return;
            }
            FirDeclaration containingDeclaration = firDeclaration;
            FirMemberDeclaration firMemberDeclaration = containingDeclaration instanceof FirMemberDeclaration ? (FirMemberDeclaration)containingDeclaration : null;
            if (firMemberDeclaration != null) {
                FirMemberDeclaration $this$isExpect$iv = firMemberDeclaration;
                boolean $i$f$isExpect = false;
                bl = $this$isExpect$iv.getStatus().isExpect();
            } else {
                bl = false;
            }
            if (bl) {
                return;
            }
            this.check(declaration, containingDeclaration, context, reporter);
        }
    }
}

