/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.LoggingContext;
import org.jetbrains.kotlin.backend.common.linkage.issues.ChecksKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseConfig;
import org.jetbrains.kotlin.backend.common.phaser.PhaserState;
import org.jetbrains.kotlin.backend.common.phaser.SimpleNamedCompilerPhase;
import org.jetbrains.kotlin.backend.wasm.DebugInformation;
import org.jetbrains.kotlin.backend.wasm.LoweredIrWithExtraArtifacts;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmCompilerResult;
import org.jetbrains.kotlin.backend.wasm.WasmLoweringPhasesKt;
import org.jetbrains.kotlin.backend.wasm.export.ExportModelGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsHelpersKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.JsModuleAndQualifierReference;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledFileFragment;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmCompiledModuleFragment;
import org.jetbrains.kotlin.backend.wasm.lower.MarkAdditionalExportedDeclarationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.SourceMapGenerator;
import org.jetbrains.kotlin.cli.common.CommonCompilerPerformanceManager;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.IrModuleInfo;
import org.jetbrains.kotlin.ir.backend.js.MainModule;
import org.jetbrains.kotlin.ir.backend.js.WholeWorldStageController;
import org.jetbrains.kotlin.ir.backend.js.export.ExportModelToTsDeclarations;
import org.jetbrains.kotlin.ir.backend.js.export.ExportedModule;
import org.jetbrains.kotlin.ir.backend.js.export.TypeScriptFragment;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsIrLinker;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.StageController;
import org.jetbrains.kotlin.ir.util.ExternalDependenciesGenerator;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.wasm.WasmTarget;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.wasm.config.WasmConfigurationKeys;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmModule;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToBinary;
import org.jetbrains.kotlin.wasm.ir.convertors.WasmIrToText;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u00a2\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001aP\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001a4\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0010\u001ae\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\"2\b\b\u0002\u0010&\u001a\u00020\u00102\b\b\u0002\u0010'\u001a\u00020\u00102\b\b\u0002\u0010(\u001a\u00020\u00102\b\b\u0002\u0010)\u001a\u00020\u0010\u00a2\u0006\u0004\b*\u0010+\u001a$\u0010,\u001a\u00020\"*\u00020-2\u0006\u0010.\u001a\u00020\"2\u0010\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003000\u001f\u001a@\u00101\u001a\u00020\"2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\"0\r2\f\u00103\u001a\b\u0012\u0004\u0012\u0002040\r2\u0006\u0010.\u001a\u00020\"2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\r2\u0006\u00107\u001a\u00020\u0010\u001aD\u00108\u001a\u00020\"2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\"0\r2\u0006\u00109\u001a\u00020\"2\f\u00105\u001a\b\u0012\u0004\u0012\u0002060:2\u0010\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003000\u001f2\u0006\u0010;\u001a\u00020\u0010\u001a&\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\u001d2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u0010\u001a\u0018\u0010A\u001a\u00020\"2\u0010\u0010/\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u0003000\u001f\u00a8\u0006B"}, d2={"compileToLoweredIr", "Lorg/jetbrains/kotlin/backend/wasm/LoweredIrWithExtraArtifacts;", "irModuleInfo", "Lorg/jetbrains/kotlin/ir/backend/js/IrModuleInfo;", "mainModule", "Lorg/jetbrains/kotlin/ir/backend/js/MainModule;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "performanceManager", "Lorg/jetbrains/kotlin/cli/common/CommonCompilerPerformanceManager;", "phaseConfig", "Lorg/jetbrains/kotlin/backend/common/phaser/PhaseConfig;", "exportedDeclarations", "", "Lorg/jetbrains/kotlin/name/FqName;", "generateTypeScriptFragment", "", "propertyLazyInitialization", "lowerPreservingTags", "", "modules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "context", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "controller", "Lorg/jetbrains/kotlin/ir/backend/js/WholeWorldStageController;", "isIncremental", "compileWasm", "Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "wasmCompiledFileFragments", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledFileFragment;", "moduleName", "", "typeScriptFragment", "Lorg/jetbrains/kotlin/ir/backend/js/export/TypeScriptFragment;", "baseFileName", "emitNameSection", "generateWat", "generateSourceMaps", "useDebuggerCustomFormatters", "compileWasm-quGr1d0", "(Ljava/util/List;Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Ljava/lang/String;Ljava/lang/String;ZZZZ)Lorg/jetbrains/kotlin/backend/wasm/WasmCompilerResult;", "generateAsyncWasiWrapper", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment;", "wasmFilePath", "exports", "Lorg/jetbrains/kotlin/wasm/ir/WasmExport;", "generateAsyncJsWrapper", "jsModuleImports", "jsFuns", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmCompiledModuleFragment$JsCodeSnippet;", "jsModuleAndQualifierReferences", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/JsModuleAndQualifierReference;", "useJsTag", "generateEsmExportsWrapper", "asyncWrapperFileName", "", "useCustomFormatters", "writeCompilationResult", "result", "dir", "Ljava/io/File;", "fileNameBase", "generateExports", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nwasmCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 wasmCompiler.kt\norg/jetbrains/kotlin/backend/wasm/WasmCompilerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,519:1\n1863#2,2:520\n1872#2,2:523\n1863#2,2:525\n1874#2:527\n1863#2,2:530\n1557#2:532\n1628#2,3:533\n1557#2:536\n1628#2,3:537\n774#2:540\n865#2,2:541\n1557#2:543\n1628#2,3:544\n1663#2,8:547\n1053#2:555\n827#2:556\n855#2,2:557\n227#3:522\n227#3:528\n227#3:529\n189#3:559\n1#4:560\n*S KotlinDebug\n*F\n+ 1 wasmCompiler.kt\norg/jetbrains/kotlin/backend/wasm/WasmCompilerKt\n*L\n84#1:520,2\n131#1:523,2\n133#1:525,2\n131#1:527\n200#1:530,2\n280#1:532\n280#1:533,3\n412#1:536\n412#1:537,3\n419#1:540\n419#1:541,2\n420#1:543\n420#1:544,3\n431#1:547,8\n433#1:555\n501#1:556\n501#1:557,2\n94#1:522\n165#1:528\n168#1:529\n502#1:559\n*E\n"})
public final class WasmCompilerKt {
    @NotNull
    public static final LoweredIrWithExtraArtifacts compileToLoweredIr(@NotNull IrModuleInfo irModuleInfo, @NotNull MainModule mainModule, @NotNull CompilerConfiguration configuration2, @Nullable CommonCompilerPerformanceManager performanceManager2, @NotNull PhaseConfig phaseConfig, @NotNull Set<FqName> exportedDeclarations, boolean generateTypeScriptFragment, boolean propertyLazyInitialization) {
        String typeScriptFragment;
        WasmBackendContext context;
        List<IrModuleFragment> allModules;
        block12: {
            TypeScriptFragment typeScriptFragment2;
            List<IrModuleFragment> list;
            Intrinsics.checkNotNullParameter(irModuleInfo, "irModuleInfo");
            Intrinsics.checkNotNullParameter(mainModule, "mainModule");
            Intrinsics.checkNotNullParameter(configuration2, "configuration");
            Intrinsics.checkNotNullParameter(phaseConfig, "phaseConfig");
            Intrinsics.checkNotNullParameter(exportedDeclarations, "exportedDeclarations");
            IrModuleFragment moduleFragment = irModuleInfo.component1();
            List<IrModuleFragment> dependencyModules = irModuleInfo.component2();
            IrBuiltIns irBuiltIns = irModuleInfo.component3();
            SymbolTable symbolTable = irModuleInfo.component4();
            JsIrLinker irLinker = irModuleInfo.component5();
            MainModule mainModule2 = mainModule;
            if (mainModule2 instanceof MainModule.SourceFiles) {
                list = CollectionsKt.plus((Collection)dependencyModules, (Iterable)CollectionsKt.listOf(moduleFragment));
            } else if (mainModule2 instanceof MainModule.Klib) {
                list = dependencyModules;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            allModules = list;
            ModuleDescriptor moduleDescriptor = moduleFragment.getDescriptor();
            context = new WasmBackendContext(moduleDescriptor, irBuiltIns, symbolTable, moduleFragment, propertyLazyInitialization, configuration2);
            new ExternalDependenciesGenerator(symbolTable, CollectionsKt.listOf(irLinker)).generateUnboundSymbolsAsDependencies();
            Iterable $this$forEach$iv = allModules;
            boolean $i$f$forEach = false;
            Iterator<Object> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                IrModuleFragment it = (IrModuleFragment)element$iv;
                boolean bl = false;
                PatchDeclarationParentsKt.patchDeclarationParents$default(it, null, 1, null);
            }
            irLinker.postProcess(true);
            ChecksKt.checkNoUnboundSymbols(irLinker, symbolTable, "at the end of IR linkage process");
            irLinker.clear();
            for (IrModuleFragment module2 : allModules) {
                for (IrFile file2 : module2.getFiles()) {
                    MarkAdditionalExportedDeclarationsKt.markExportedDeclarations(context, file2, exportedDeclarations);
                }
            }
            boolean $i$f$runIf = false;
            if (generateTypeScriptFragment) {
                boolean bl = false;
                ExportedModule exportModel = new ExportModelGenerator(context).generateExport((Iterable<? extends IrModuleFragment>)allModules);
                ExportModelToTsDeclarations exportModelToDtsTranslator = new ExportModelToTsDeclarations();
                String fragment = exportModelToDtsTranslator.generateTypeScriptFragment-2EUUaHo(ModuleKind.ES, exportModel.getDeclarations());
                typeScriptFragment2 = TypeScriptFragment.box-impl(TypeScriptFragment.constructor-impl(exportModelToDtsTranslator.generateTypeScript("", ModuleKind.ES, CollectionsKt.listOf(TypeScriptFragment.box-impl(fragment)))));
            } else {
                typeScriptFragment2 = null;
            }
            typeScriptFragment = typeScriptFragment2 != null ? typeScriptFragment2.unbox-impl() : null;
            CommonCompilerPerformanceManager commonCompilerPerformanceManager = performanceManager2;
            if (commonCompilerPerformanceManager != null) {
                commonCompilerPerformanceManager.notifyIRTranslationFinished();
            }
            CommonCompilerPerformanceManager commonCompilerPerformanceManager2 = performanceManager2;
            if (commonCompilerPerformanceManager2 != null) {
                commonCompilerPerformanceManager2.notifyGenerationStarted();
            }
            CommonCompilerPerformanceManager commonCompilerPerformanceManager3 = performanceManager2;
            if (commonCompilerPerformanceManager3 != null) {
                commonCompilerPerformanceManager3.notifyIRLoweringStarted();
            }
            Iterable iterable = allModules;
            StageController stageController = context.getIrFactory().getStageController();
            Intrinsics.checkNotNull(stageController, "null cannot be cast to non-null type org.jetbrains.kotlin.ir.backend.js.WholeWorldStageController");
            WasmCompilerKt.lowerPreservingTags(iterable, context, phaseConfig, (WholeWorldStageController)stageController, false);
            CommonCompilerPerformanceManager commonCompilerPerformanceManager4 = performanceManager2;
            if (commonCompilerPerformanceManager4 == null) break block12;
            commonCompilerPerformanceManager4.notifyIRLoweringFinished();
        }
        return new LoweredIrWithExtraArtifacts(allModules, context, typeScriptFragment, null);
    }

    public static /* synthetic */ LoweredIrWithExtraArtifacts compileToLoweredIr$default(IrModuleInfo irModuleInfo, MainModule mainModule, CompilerConfiguration compilerConfiguration, CommonCompilerPerformanceManager commonCompilerPerformanceManager, PhaseConfig phaseConfig, Set set, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x20) != 0) {
            set = SetsKt.emptySet();
        }
        return WasmCompilerKt.compileToLoweredIr(irModuleInfo, mainModule, compilerConfiguration, commonCompilerPerformanceManager, phaseConfig, set, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void lowerPreservingTags(@NotNull Iterable<? extends IrModuleFragment> modules2, @NotNull WasmBackendContext context, @NotNull PhaseConfig phaseConfig, @NotNull WholeWorldStageController controller, boolean isIncremental) {
        Intrinsics.checkNotNullParameter(modules2, "modules");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(phaseConfig, "phaseConfig");
        Intrinsics.checkNotNullParameter(controller, "controller");
        controller.setCurrentStage(0);
        PhaserState phaserState = new PhaserState(null, 0, 0, null, 15, null);
        List<SimpleNamedCompilerPhase<WasmBackendContext, IrModuleFragment, IrModuleFragment>> wasmLowerings = WasmLoweringPhasesKt.getWasmLowerings(isIncremental);
        Iterable $this$forEachIndexed$iv = wasmLowerings;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            SimpleNamedCompilerPhase simpleNamedCompilerPhase = (SimpleNamedCompilerPhase)item$iv;
            int i = n;
            boolean bl = false;
            controller.setCurrentStage(i + 1);
            Iterable<? extends IrModuleFragment> $this$forEach$iv = modules2;
            boolean $i$f$forEach = false;
            Iterator<? extends IrModuleFragment> iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                void lowering;
                IrModuleFragment element$iv;
                IrModuleFragment module2 = element$iv = iterator2.next();
                boolean bl2 = false;
                lowering.invoke(phaseConfig, phaserState, (LoggingContext)context, module2);
            }
        }
        controller.setCurrentStage(wasmLowerings.size() + 1);
    }

    @NotNull
    public static final WasmCompilerResult compileWasm-quGr1d0(@NotNull List<WasmCompiledFileFragment> wasmCompiledFileFragments, @NotNull String moduleName, @NotNull CompilerConfiguration configuration2, @Nullable String typeScriptFragment, @NotNull String baseFileName, boolean emitNameSection, boolean generateWat, boolean generateSourceMaps, boolean useDebuggerCustomFormatters) {
        String string2;
        SourceMapGenerator sourceMapGeneratorForText;
        SourceMapGenerator sourceMapGenerator;
        SourceMapGenerator sourceMapGenerator2;
        Intrinsics.checkNotNullParameter(wasmCompiledFileFragments, "wasmCompiledFileFragments");
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(configuration2, "configuration");
        Intrinsics.checkNotNullParameter(baseFileName, "baseFileName");
        boolean useJsTag = configuration2.getBoolean(WasmConfigurationKeys.WASM_USE_JS_TAG);
        boolean isWasmJsTarget = configuration2.get(WasmConfigurationKeys.WASM_TARGET) != WasmTarget.WASI;
        WasmCompiledModuleFragment wasmCompiledModuleFragment = new WasmCompiledModuleFragment(wasmCompiledFileFragments, configuration2.getBoolean(WasmConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS), isWasmJsTarget && useJsTag);
        wasmCompiledModuleFragment.createInterfaceTablesAndLinkTableSymbols();
        WasmModule linkedModule = wasmCompiledModuleFragment.linkWasmCompiledFragments();
        boolean $i$f$runIf = false;
        if (generateSourceMaps) {
            boolean bl = false;
            sourceMapGenerator2 = new SourceMapGenerator(baseFileName + ".wasm", configuration2);
        } else {
            sourceMapGenerator2 = null;
        }
        SourceMapGenerator sourceMapGeneratorForBinary = sourceMapGenerator2;
        boolean condition$iv = generateWat && generateSourceMaps;
        boolean $i$f$runIf2 = false;
        if (condition$iv) {
            boolean bl = false;
            sourceMapGenerator = new SourceMapGenerator(baseFileName + ".wat", configuration2);
        } else {
            sourceMapGenerator = sourceMapGeneratorForText = null;
        }
        if (generateWat) {
            WasmIrToText watGenerator = new WasmIrToText(sourceMapGeneratorForText, false, 2, null);
            watGenerator.appendWasmModule(linkedModule);
            string2 = watGenerator.toString();
        } else {
            string2 = null;
        }
        String wat = string2;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        WasmIrToBinary wasmIrToBinary = new WasmIrToBinary(os, linkedModule, moduleName, emitNameSection, sourceMapGeneratorForBinary, false, 32, null);
        wasmIrToBinary.appendWasmModule();
        byte[] byteArray = os.toByteArray();
        String jsUninstantiatedWrapper = null;
        String jsWrapper = null;
        if (isWasmJsTarget) {
            Set jsModuleImports = new LinkedHashSet();
            Set jsFuns = new LinkedHashSet();
            Set jsModuleAndQualifierReferences = new LinkedHashSet();
            Iterable $this$forEach$iv = wasmCompiledFileFragments;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WasmCompiledFileFragment fragment = (WasmCompiledFileFragment)element$iv;
                boolean bl = false;
                jsModuleImports.addAll(fragment.getJsModuleImports().values());
                jsFuns.addAll(fragment.getJsFuns().values());
                jsModuleAndQualifierReferences.addAll((Collection)fragment.getJsModuleAndQualifierReferences());
            }
            jsUninstantiatedWrapper = WasmCompilerKt.generateAsyncJsWrapper(jsModuleImports, jsFuns, "./" + baseFileName + ".wasm", jsModuleAndQualifierReferences, useJsTag);
            jsWrapper = WasmCompilerKt.generateEsmExportsWrapper(jsModuleImports, "./" + baseFileName + ".uninstantiated.mjs", jsModuleAndQualifierReferences, linkedModule.getExports(), useDebuggerCustomFormatters);
        } else {
            jsUninstantiatedWrapper = null;
            jsWrapper = WasmCompilerKt.generateAsyncWasiWrapper(wasmCompiledModuleFragment, "./" + baseFileName + ".wasm", linkedModule.getExports());
        }
        Intrinsics.checkNotNull(byteArray);
        SourceMapGenerator sourceMapGenerator3 = sourceMapGeneratorForBinary;
        SourceMapGenerator sourceMapGenerator4 = sourceMapGeneratorForText;
        DebugInformation debugInformation = new DebugInformation(sourceMapGenerator3 != null ? sourceMapGenerator3.generate() : null, sourceMapGenerator4 != null ? sourceMapGenerator4.generate() : null);
        String string3 = typeScriptFragment;
        if (string3 == null) {
            string3 = null;
        }
        return new WasmCompilerResult(wat, jsUninstantiatedWrapper, jsWrapper, byteArray, debugInformation, string3);
    }

    public static /* synthetic */ WasmCompilerResult compileWasm-quGr1d0$default(List list, String string2, CompilerConfiguration compilerConfiguration, String string3, String string4, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        if ((n & 0x40) != 0) {
            bl2 = false;
        }
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        if ((n & 0x100) != 0) {
            bl4 = false;
        }
        return WasmCompilerKt.compileWasm-quGr1d0(list, string2, compilerConfiguration, string3, string4, bl, bl2, bl3, bl4);
    }

    @NotNull
    public static final String generateAsyncWasiWrapper(@NotNull WasmCompiledModuleFragment $this$generateAsyncWasiWrapper, @NotNull String wasmFilePath, @NotNull List<? extends WasmExport<?>> exports) {
        Intrinsics.checkNotNullParameter($this$generateAsyncWasiWrapper, "<this>");
        Intrinsics.checkNotNullParameter(wasmFilePath, "wasmFilePath");
        Intrinsics.checkNotNullParameter(exports, "exports");
        return "\nimport { WASI } from 'wasi';\nimport { argv, env } from 'node:process';\n\nconst wasi = new WASI({ version: 'preview1', args: argv, env, });\n\nconst fs = await import('node:fs');\nconst url = await import('node:url');\nconst wasmBuffer = fs.readFileSync(url.fileURLToPath(import.meta.resolve('" + wasmFilePath + "')));\nconst wasmModule = new WebAssembly.Module(wasmBuffer);\nconst wasmInstance = new WebAssembly.Instance(wasmModule, wasi.getImportObject());\n\nwasi.initialize(wasmInstance);\n\nconst exports = wasmInstance.exports\n" + WasmCompilerKt.generateExports(exports) + '\n';
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateAsyncJsWrapper(@NotNull Set<String> jsModuleImports, @NotNull Set<WasmCompiledModuleFragment.JsCodeSnippet> jsFuns, @NotNull String wasmFilePath, @NotNull Set<JsModuleAndQualifierReference> jsModuleAndQualifierReferences, boolean useJsTag) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(jsModuleImports, "jsModuleImports");
        Intrinsics.checkNotNullParameter(jsFuns, "jsFuns");
        Intrinsics.checkNotNullParameter(wasmFilePath, "wasmFilePath");
        Intrinsics.checkNotNullParameter(jsModuleAndQualifierReferences, "jsModuleAndQualifierReferences");
        String jsCodeBody = CollectionsKt.joinToString$default(jsFuns, ",\n", null, null, 0, null, WasmCompilerKt::generateAsyncJsWrapper$lambda$7, 30, null);
        String jsCodeBodyIndented = StringsKt.prependIndent(jsCodeBody, "        ");
        String imports = CollectionsKt.joinToString$default(CollectionsKt.sorted(CollectionsKt.toList((Iterable)jsModuleImports)), "", null, null, 0, null, WasmCompilerKt::generateAsyncJsWrapper$lambda$8, 30, null);
        Iterable iterable = jsModuleAndQualifierReferences;
        boolean $i$f$map = false;
        void var11_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            StringBuilder stringBuilder;
            void it;
            JsModuleAndQualifierReference jsModuleAndQualifierReference = (JsModuleAndQualifierReference)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String module2 = it.getModule();
            String qualifier = it.getQualifier();
            StringBuilder $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append("    const ");
            $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(it.getJsVariableName());
            $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(" = ");
            if (module2 != null) {
                $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append("imports[" + JsHelpersKt.toJsStringLiteral(module2) + ']');
                if (qualifier != null) {
                    $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(".");
                }
            }
            if (qualifier != null) {
                $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(qualifier);
            }
            $this$generateAsyncJsWrapper_u24lambda_u2410_u24lambda_u249.append(";");
            collection.add(stringBuilder.toString());
        }
        String referencesToQualifiedAndImportedDeclarations = CollectionsKt.joinToString$default(CollectionsKt.sorted((List)destination$iv$iv), "\n", null, null, 0, null, null, 62, null);
        CharSequence pathJsStringLiteral = JsHelpersKt.toJsStringLiteral(wasmFilePath);
        return "\nexport async function instantiate(imports={}, runInitializer=true) {\n    const cachedJsObjects = new WeakMap();\n    // ref must be non-null\n    function getCachedJsObject(ref, ifNotCached) {\n        if (typeof ref !== 'object' && typeof ref !== 'function') return ifNotCached;\n        const cached = cachedJsObjects.get(ref);\n        if (cached !== void 0) return cached;\n        cachedJsObjects.set(ref, ifNotCached);\n        return ifNotCached;\n    }\n\n" + referencesToQualifiedAndImportedDeclarations + "\n    \n    const js_code = {\n" + jsCodeBodyIndented + "\n    }\n    \n    // Placed here to give access to it from externals (js_code)\n    let wasmInstance;\n    let require; \n    let wasmExports;\n\n    const isNodeJs = (typeof process !== 'undefined') && (process.release.name === 'node');\n    const isDeno = !isNodeJs && (typeof Deno !== 'undefined')\n    const isStandaloneJsVM =\n        !isDeno && !isNodeJs && (\n            typeof d8 !== 'undefined' // V8\n            || typeof inIon !== 'undefined' // SpiderMonkey\n            || typeof jscOptions !== 'undefined' // JavaScriptCore\n        );\n    const isBrowser = !isNodeJs && !isDeno && !isStandaloneJsVM && (typeof window !== 'undefined' || typeof self !== 'undefined');\n    \n    if (!isNodeJs && !isDeno && !isStandaloneJsVM && !isBrowser) {\n      throw \"Supported JS engine not detected\";\n    }\n    \n    const wasmFilePath = " + pathJsStringLiteral + ";\n    const importObject = {\n        js_code,\n        intrinsics: {\n            " + (useJsTag ? "js_error_tag: WebAssembly.JSTag" : "") + "\n        },\n" + imports + "\n    };\n    \n    try {\n      if (isNodeJs) {\n        const module = await import(/* webpackIgnore: true */'node:module');\n        const importMeta = import.meta;\n        require = module.default.createRequire(importMeta.url);\n        const fs = require('fs');\n        const url = require('url');\n        const filepath = import.meta.resolve(wasmFilePath);\n        const wasmBuffer = fs.readFileSync(url.fileURLToPath(filepath));\n        const wasmModule = new WebAssembly.Module(wasmBuffer);\n        wasmInstance = new WebAssembly.Instance(wasmModule, importObject);\n      }\n      \n      if (isDeno) {\n        const path = await import(/* webpackIgnore: true */'https://deno.land/std/path/mod.ts');\n        const binary = Deno.readFileSync(path.fromFileUrl(import.meta.resolve(wasmFilePath)));\n        const module = await WebAssembly.compile(binary);\n        wasmInstance = await WebAssembly.instantiate(module, importObject);\n      }\n      \n      if (isStandaloneJsVM) {\n        const wasmBuffer = read(wasmFilePath, 'binary');\n        const wasmModule = new WebAssembly.Module(wasmBuffer);\n        wasmInstance = new WebAssembly.Instance(wasmModule, importObject);\n      }\n      \n      if (isBrowser) {\n        wasmInstance = (await WebAssembly.instantiateStreaming(fetch(new URL(" + pathJsStringLiteral + ",import.meta.url).href), importObject)).instance;\n      }\n    } catch (e) {\n      if (e instanceof WebAssembly.CompileError) {\n        let text = `Please make sure that your runtime environment supports the latest version of Wasm GC and Exception-Handling proposals.\nFor more information, see https://kotl.in/wasm-help\n`;\n        if (isBrowser) {\n          console.error(text);\n        } else {\n          const t = \"\\n\" + text;\n          if (typeof console !== \"undefined\" && console.log !== void 0) \n            console.log(t);\n          else \n            print(t);\n        }\n      }\n      throw e;\n    }\n    \n    wasmExports = wasmInstance.exports;\n    if (runInitializer) {\n        wasmExports._initialize();\n    }\n\n    return { instance: wasmInstance,  exports: wasmExports };\n}\n";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateEsmExportsWrapper(@NotNull Set<String> jsModuleImports, @NotNull String asyncWrapperFileName, @NotNull Set<JsModuleAndQualifierReference> jsModuleAndQualifierReferences, @NotNull List<? extends WasmExport<?>> exports, boolean useCustomFormatters) {
        void $this$sortedBy$iv;
        Iterable $this$distinctBy$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        void $this$map$iv2;
        Intrinsics.checkNotNullParameter(jsModuleImports, "jsModuleImports");
        Intrinsics.checkNotNullParameter(asyncWrapperFileName, "asyncWrapperFileName");
        Intrinsics.checkNotNullParameter(jsModuleAndQualifierReferences, "jsModuleAndQualifierReferences");
        Intrinsics.checkNotNullParameter(exports, "exports");
        Iterable iterable = jsModuleImports;
        boolean $i$f$map22 = false;
        void var8_8 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String moduleSpecifier = ((Object)JsHelpersKt.toJsStringLiteral((String)it)).toString();
            String importVariableString = JsModuleAndQualifierReference.Companion.encode((String)it);
            collection.add(TuplesKt.to(moduleSpecifier, importVariableString));
        }
        List importedModules = (List)destination$iv$iv;
        Iterable $i$f$map22 = jsModuleAndQualifierReferences;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JsModuleAndQualifierReference it = (JsModuleAndQualifierReference)element$iv$iv;
            boolean bl = false;
            if (!(it.getModule() != null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map32 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String module2;
            JsModuleAndQualifierReference it = (JsModuleAndQualifierReference)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            Intrinsics.checkNotNull(it.getModule());
            String stringLiteral = ((Object)JsHelpersKt.toJsStringLiteral(module2)).toString();
            collection.add(TuplesKt.to(stringLiteral, it.getQualifier() != null ? it.getImportVariableName() : it.getJsVariableName()));
        }
        List referencesToImportedDeclarations = (List)destination$iv$iv2;
        Iterable $i$f$map32 = CollectionsKt.plus((Collection)importedModules, (Iterable)referencesToImportedDeclarations);
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Pair it = (Pair)e$iv;
            boolean bl = false;
            String key$iv = (String)it.getFirst();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        $this$distinctBy$iv = list$iv;
        boolean $i$f$sortedBy = false;
        List allModules = CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                it = (Pair)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)((String)it.getFirst())));
            }
        });
        String importsImportedSection = CollectionsKt.joinToString$default(allModules, "\n", null, null, 0, null, WasmCompilerKt::generateEsmExportsWrapper$lambda$17, 30, null);
        String imports = CollectionsKt.joinToString$default(allModules, ",\n", null, null, 0, null, WasmCompilerKt::generateEsmExportsWrapper$lambda$18, 30, null);
        return '\n' + importsImportedSection + "\nimport { instantiate } from " + JsHelpersKt.toJsStringLiteral(asyncWrapperFileName) + ";\n" + (useCustomFormatters ? "import \"./custom-formatters.js\"" : "") + "\n\nconst exports = (await instantiate({\n" + imports + "\n})).exports;\n" + WasmCompilerKt.generateExports(exports) + '\n';
    }

    public static final void writeCompilationResult(@NotNull WasmCompilerResult result2, @NotNull File dir2, @NotNull String fileNameBase, boolean useDebuggerCustomFormatters) {
        Object object;
        Object it;
        Intrinsics.checkNotNullParameter(result2, "result");
        Intrinsics.checkNotNullParameter(dir2, "dir");
        Intrinsics.checkNotNullParameter(fileNameBase, "fileNameBase");
        dir2.mkdirs();
        if (result2.getWat() != null) {
            FilesKt.writeText$default(new File(dir2, fileNameBase + ".wat"), result2.getWat(), null, 2, null);
        }
        FilesKt.writeBytes(new File(dir2, fileNameBase + ".wasm"), result2.getWasm());
        if (result2.getJsUninstantiatedWrapper() != null) {
            FilesKt.writeText$default(new File(dir2, fileNameBase + ".uninstantiated.mjs"), result2.getJsUninstantiatedWrapper(), null, 2, null);
        }
        FilesKt.writeText$default(new File(dir2, fileNameBase + ".mjs"), result2.getJsWrapper(), null, 2, null);
        Object object2 = result2.getDebugInformation();
        if (object2 != null && (object2 = ((DebugInformation)object2).getSourceMapForBinary()) != null) {
            it = object2;
            boolean bl = false;
            FilesKt.writeText$default(new File(dir2, fileNameBase + ".wasm.map"), (String)it, null, 2, null);
        }
        if ((object = result2.getDebugInformation()) != null && (object = ((DebugInformation)object).getSourceMapForText()) != null) {
            it = object;
            boolean bl = false;
            FilesKt.writeText$default(new File(dir2, fileNameBase + ".wat.map"), (String)it, null, 2, null);
        }
        if (useDebuggerCustomFormatters) {
            String fileName = "custom-formatters.js";
            ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
            InputStream customFormattersInputStream = systemClassLoader.getResourceAsStream(fileName);
            Object[] objectArray = new String[]{fileName};
            Path path = Paths.get(dir2.getPath(), (String[])objectArray);
            objectArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(customFormattersInputStream, path, (CopyOption[])objectArray);
        }
        if (result2.getDts() != null) {
            FilesKt.writeText$default(new File(dir2, fileNameBase + ".d.ts"), result2.getDts(), null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String generateExports(@NotNull List<? extends WasmExport<?>> exports) {
        String string2;
        String string3;
        String string4;
        String string5;
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullParameter(exports, "exports");
        Iterable $this$filterNot$iv = exports;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            WasmExport it = (WasmExport)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default(it.getName(), "__callFunction_", false, 2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Collection $this$ifNotEmpty$iv = (List)destination$iv$iv;
        boolean $i$f$ifNotEmpty = false;
        if (!$this$ifNotEmpty$iv.isEmpty()) {
            List $this$generateExports_u24lambda_u2423 = (List)$this$ifNotEmpty$iv;
            boolean bl = false;
            string5 = CollectionsKt.joinToString$default($this$generateExports_u24lambda_u2423, ",\n", null, null, 0, null, WasmCompilerKt::generateExports$lambda$23$lambda$22, 30, null);
        } else {
            string5 = string4 = null;
        }
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            string3 = StringsKt.trimMargin$default("\n            |const {\n                |" + it + "\n            |}\n        ", null, 1, null);
        } else {
            string3 = null;
        }
        String exportNames = string3;
        StringBuilder stringBuilder = new StringBuilder().append('\n');
        String string6 = exportNames;
        if (string6 != null) {
            void it;
            $this$ifNotEmpty$iv = string6;
            StringBuilder stringBuilder2 = stringBuilder;
            boolean bl = false;
            string2 = "export " + (String)it + " = exports;";
            stringBuilder = stringBuilder2;
        } else {
            string2 = null;
        }
        return stringBuilder.append(string2).append('\n').toString();
    }

    private static final CharSequence generateAsyncJsWrapper$lambda$7(WasmCompiledModuleFragment.JsCodeSnippet it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return JsHelpersKt.toJsStringLiteral(it.getImportName().getOwner()) + " : " + it.getJsCode();
    }

    private static final CharSequence generateAsyncJsWrapper$lambda$8(String it) {
        Intrinsics.checkNotNullParameter(it, "it");
        CharSequence moduleSpecifier = JsHelpersKt.toJsStringLiteral(it);
        return "        " + moduleSpecifier + ": imports[" + moduleSpecifier + "],\n";
    }

    private static final CharSequence generateEsmExportsWrapper$lambda$17(Pair it) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(it, "it");
        StringBuilder $this$generateEsmExportsWrapper_u24lambda_u2417_u24lambda_u2416 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$generateEsmExportsWrapper_u24lambda_u2417_u24lambda_u2416.append("import * as ");
        $this$generateEsmExportsWrapper_u24lambda_u2417_u24lambda_u2416.append((String)it.getSecond());
        $this$generateEsmExportsWrapper_u24lambda_u2417_u24lambda_u2416.append(" from ");
        $this$generateEsmExportsWrapper_u24lambda_u2417_u24lambda_u2416.append((String)it.getFirst());
        $this$generateEsmExportsWrapper_u24lambda_u2417_u24lambda_u2416.append(";");
        return stringBuilder.toString();
    }

    private static final CharSequence generateEsmExportsWrapper$lambda$18(Pair it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "    " + (String)it.getFirst() + ": " + (String)it.getSecond();
    }

    private static final CharSequence generateExports$lambda$23$lambda$22(WasmExport it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return "    " + it.getName();
    }
}

