/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.util;

public final class CharsetNames {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String normalize(String csName) {
        char d;
        if (csName == null || csName.length() < 3) {
            return csName;
        }
        boolean gotCsPrefix = false;
        char c = csName.charAt(0);
        if (!(c != 'c' && c != 'C' || (d = csName.charAt(1)) != 's' && d != 'S')) {
            csName = csName.substring(2);
            c = csName.charAt(0);
            gotCsPrefix = true;
        }
        switch (c) {
            case 'A': 
            case 'a': {
                if (csName != "ASCII" && !CharsetNames.equalEncodings(csName, "ASCII")) return csName;
                return "US-ASCII";
            }
            case 'C': 
            case 'c': {
                if (!CharsetNames.encodingStartsWith(csName, "cs")) return csName;
                return csName;
            }
            case 'E': 
            case 'e': {
                if (!csName.startsWith("EBCDIC") && !csName.startsWith("ebcdic")) return csName;
                return "EBCDIC";
            }
            case 'I': 
            case 'i': {
                if (csName == "ISO-8859-1" || CharsetNames.equalEncodings(csName, "ISO-8859-1") || CharsetNames.equalEncodings(csName, "ISO-Latin1")) {
                    return "ISO-8859-1";
                }
                if (!CharsetNames.encodingStartsWith(csName, "ISO-10646")) return csName;
                int ix = csName.indexOf("10646");
                String suffix = csName.substring(ix + 5);
                if (CharsetNames.equalEncodings(suffix, "UCS-Basic")) {
                    return "US-ASCII";
                }
                if (CharsetNames.equalEncodings(suffix, "Unicode-Latin1")) {
                    return "ISO-8859-1";
                }
                if (CharsetNames.equalEncodings(suffix, "UCS-2")) {
                    return "UTF-16";
                }
                if (CharsetNames.equalEncodings(suffix, "UCS-4")) {
                    return "UTF-32";
                }
                if (CharsetNames.equalEncodings(suffix, "UTF-1")) {
                    return "US-ASCII";
                }
                if (CharsetNames.equalEncodings(suffix, "J-1")) {
                    return "US-ASCII";
                }
                if (!CharsetNames.equalEncodings(suffix, "US-ASCII")) return csName;
                return "US-ASCII";
            }
            case 'J': 
            case 'j': {
                if (!CharsetNames.equalEncodings(csName, "JIS_Encoding")) return csName;
                return "Shift_JIS";
            }
            case 'S': 
            case 's': {
                if (!CharsetNames.equalEncodings(csName, "Shift_JIS")) return csName;
                return "Shift_JIS";
            }
            case 'U': 
            case 'u': {
                if (csName.length() < 2) return csName;
                switch (csName.charAt(1)) {
                    case 'C': 
                    case 'c': {
                        if (CharsetNames.equalEncodings(csName, "UCS-2")) {
                            return "UTF-16";
                        }
                        if (!CharsetNames.equalEncodings(csName, "UCS-4")) return csName;
                        return "UTF-32";
                    }
                    case 'N': 
                    case 'n': {
                        if (!gotCsPrefix) return csName;
                        if (CharsetNames.equalEncodings(csName, "Unicode")) {
                            return "UTF-16";
                        }
                        if (CharsetNames.equalEncodings(csName, "UnicodeAscii")) {
                            return "ISO-8859-1";
                        }
                        if (!CharsetNames.equalEncodings(csName, "UnicodeAscii")) return csName;
                        return "US-ASCII";
                    }
                    case 'S': 
                    case 's': {
                        if (!CharsetNames.equalEncodings(csName, "US-ASCII")) return csName;
                        return "US-ASCII";
                    }
                    case 'T': 
                    case 't': {
                        if (csName == "UTF-8" || CharsetNames.equalEncodings(csName, "UTF-8")) {
                            return "UTF-8";
                        }
                        if (CharsetNames.equalEncodings(csName, "UTF-16BE")) {
                            return "UTF-16BE";
                        }
                        if (CharsetNames.equalEncodings(csName, "UTF-16LE")) {
                            return "UTF-16LE";
                        }
                        if (CharsetNames.equalEncodings(csName, "UTF-16")) {
                            return "UTF-16";
                        }
                        if (CharsetNames.equalEncodings(csName, "UTF-32BE")) {
                            return "UTF-32BE";
                        }
                        if (CharsetNames.equalEncodings(csName, "UTF-32LE")) {
                            return "UTF-32LE";
                        }
                        if (CharsetNames.equalEncodings(csName, "UTF-32")) {
                            return "UTF-32";
                        }
                        if (!CharsetNames.equalEncodings(csName, "UTF")) return csName;
                        return "UTF-16";
                    }
                }
            }
        }
        return csName;
    }

    public static boolean equalEncodings(String str1, String str2) {
        int len1 = str1.length();
        int len2 = str2.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 || i2 < len2) {
            int c2;
            int c1 = i1 >= len1 ? 65536 : (int)str1.charAt(i1++);
            if (c1 == (c2 = i2 >= len2 ? 65536 : (int)str2.charAt(i2++))) continue;
            while (c1 <= 32 || c1 == 95 || c1 == 45) {
                c1 = i1 >= len1 ? 65536 : (int)str1.charAt(i1++);
            }
            while (c2 <= 32 || c2 == 95 || c2 == 45) {
                c2 = i2 >= len2 ? 65536 : (int)str2.charAt(i2++);
            }
            if (c1 == c2) continue;
            if (c1 == 65536 || c2 == 65536) {
                return false;
            }
            if (Character.toLowerCase((char)c1) == Character.toLowerCase((char)c2)) continue;
            return false;
        }
        return true;
    }

    public static boolean encodingStartsWith(String enc, String prefix) {
        int len1 = enc.length();
        int len2 = prefix.length();
        int i1 = 0;
        int i2 = 0;
        while (i1 < len1 || i2 < len2) {
            int c2;
            int c1 = i1 >= len1 ? 65536 : (int)enc.charAt(i1++);
            if (c1 == (c2 = i2 >= len2 ? 65536 : (int)prefix.charAt(i2++))) continue;
            while (c1 <= 32 || c1 == 95 || c1 == 45) {
                c1 = i1 >= len1 ? 65536 : (int)enc.charAt(i1++);
            }
            while (c2 <= 32 || c2 == 95 || c2 == 45) {
                c2 = i2 >= len2 ? 65536 : (int)prefix.charAt(i2++);
            }
            if (c1 == c2) continue;
            if (c2 == 65536) {
                return true;
            }
            if (c1 == 65536) {
                return false;
            }
            if (Character.toLowerCase((char)c1) == Character.toLowerCase((char)c2)) continue;
            return false;
        }
        return true;
    }
}

