/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.transforms.util.RegexValidator;

public class SinkConnectorConfig
extends ConnectorConfig {
    public static final String TOPICS_CONFIG = "topics";
    private static final String TOPICS_DOC = "List of topics to consume, separated by commas";
    public static final String TOPICS_DEFAULT = "";
    private static final String TOPICS_DISPLAY = "Topics";
    public static final String TOPICS_REGEX_CONFIG = "topics.regex";
    private static final String TOPICS_REGEX_DOC = "Regular expression giving topics to consume. Under the hood, the regex is compiled to a <code>java.util.regex.Pattern</code>. Only one of topics or topics.regex should be specified.";
    public static final String TOPICS_REGEX_DEFAULT = "";
    private static final String TOPICS_REGEX_DISPLAY = "Topics regex";
    static ConfigDef config = ConnectorConfig.configDef().define("topics", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.HIGH, "List of topics to consume, separated by commas", "Common", 4, ConfigDef.Width.LONG, "Topics").define("topics.regex", ConfigDef.Type.STRING, (Object)"", (ConfigDef.Validator)new RegexValidator(), ConfigDef.Importance.HIGH, "Regular expression giving topics to consume. Under the hood, the regex is compiled to a <code>java.util.regex.Pattern</code>. Only one of topics or topics.regex should be specified.", "Common", 4, ConfigDef.Width.LONG, "Topics regex");

    public static ConfigDef configDef() {
        return config;
    }

    public SinkConnectorConfig(Plugins plugins, Map<String, String> props) {
        super(plugins, config, props);
    }

    public static void validate(Map<String, String> props) {
        boolean hasTopicsConfig = SinkConnectorConfig.hasTopicsConfig(props);
        boolean hasTopicsRegexConfig = SinkConnectorConfig.hasTopicsRegexConfig(props);
        if (hasTopicsConfig && hasTopicsRegexConfig) {
            throw new ConfigException("topics and topics.regex are mutually exclusive options, but both are set.");
        }
        if (!hasTopicsConfig && !hasTopicsRegexConfig) {
            throw new ConfigException("Must configure one of topics or topics.regex");
        }
    }

    public static boolean hasTopicsConfig(Map<String, String> props) {
        String topicsStr = props.get(TOPICS_CONFIG);
        return topicsStr != null && !topicsStr.trim().isEmpty();
    }

    public static boolean hasTopicsRegexConfig(Map<String, String> props) {
        String topicsRegexStr = props.get(TOPICS_REGEX_CONFIG);
        return topicsRegexStr != null && !topicsRegexStr.trim().isEmpty();
    }
}

