/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Map;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeLogDirsRequest;
import org.apache.kafka.common.requests.DescribeLogDirsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u000f\tQB)Z:de&\u0014W\rT8h\t&\u00148OU3rk\u0016\u001cH\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001AQ!\u0005\u0001\u0005BI\t!B\\;n\u0005J|7.\u001a:t+\u0005\u0019\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"aA%oi\")!\u0004\u0001C!%\u0005YAn\\4ESJ\u001cu.\u001e8u\u0011\u001da\u0002A1A\u0005\u0002u\tQ\u0001^8qS\u000e,\u0012A\b\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\nA\u0001\\1oO*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u0019\u0019FO]5oO\"1q\u0005\u0001Q\u0001\ny\ta\u0001^8qS\u000e\u0004\u0003bB\u0015\u0001\u0005\u0004%\tAE\u0001\ra\u0006\u0014H/\u001b;j_:tU/\u001c\u0005\u0007W\u0001\u0001\u000b\u0011B\n\u0002\u001bA\f'\u000f^5uS>tg*^7!\u0011\u001di\u0003A1A\u0005\u00029\n1\u0001\u001e91+\u0005y\u0003C\u0001\u00199\u001b\u0005\t$B\u0001\u001a4\u0003\u0019\u0019w.\\7p]*\u0011Q\u0001\u000e\u0006\u0003kY\na!\u00199bG\",'\"A\u001c\u0002\u0007=\u0014x-\u0003\u0002:c\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007BB\u001e\u0001A\u0003%q&\u0001\u0003uaB\u0002\u0003bB\u001f\u0001\u0005\u0004%\tAL\u0001\u0004iB\f\u0004BB \u0001A\u0003%q&\u0001\u0003uaF\u0002\u0003\"B!\u0001\t\u0003\u0011\u0015A\u0007;fgR$Um]2sS\n,Gj\\4ESJ\u001c(+Z9vKN$H#A\"\u0011\u0005Q!\u0015BA#\u0016\u0005\u0011)f.\u001b;)\u0005\u0001;\u0005C\u0001%L\u001b\u0005I%B\u0001&7\u0003\u0015QWO\\5u\u0013\ta\u0015J\u0001\u0003UKN$\b")
public class DescribeLogDirsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final int partitionNum;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);

    @Override
    public int numBrokers() {
        return 1;
    }

    @Override
    public int logDirCount() {
        return 2;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionNum() {
        return this.partitionNum;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    @Test
    public void testDescribeLogDirsRequest() {
        String onlineDir = new File((String)((KafkaServer)this.servers().head()).config().logDirs().head()).getAbsolutePath();
        String offlineDir = new File((String)((IterableLike)((KafkaServer)this.servers().head()).config().logDirs().tail()).head()).getAbsolutePath();
        ((KafkaServer)this.servers().head()).replicaManager().handleLogDirFailure(offlineDir);
        this.createTopic(this.topic(), this.partitionNum(), 1, this.createTopic$default$4());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 10, TestUtils$.MODULE$.produceMessages$default$4(), TestUtils$.MODULE$.produceMessages$default$5());
        DescribeLogDirsRequest request = (DescribeLogDirsRequest)new DescribeLogDirsRequest.Builder(null).build();
        ByteBuffer response = this.connectAndSend((AbstractRequest)request, ApiKeys.DESCRIBE_LOG_DIRS, this.controllerSocketServer(), this.connectAndSend$default$4(), this.connectAndSend$default$5());
        Map logDirInfos = DescribeLogDirsResponse.parse((ByteBuffer)response, (short)request.version()).logDirInfos();
        Assert.assertEquals((long)this.logDirCount(), (long)logDirInfos.size());
        Assert.assertEquals((Object)Errors.KAFKA_STORAGE_ERROR, (Object)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)offlineDir)).error);
        Assert.assertEquals((long)0L, (long)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)offlineDir)).replicaInfos.size());
        Assert.assertEquals((Object)Errors.NONE, (Object)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).error);
        DescribeLogDirsResponse.ReplicaInfo replicaInfo0 = (DescribeLogDirsResponse.ReplicaInfo)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).replicaInfos.get(this.tp0());
        DescribeLogDirsResponse.ReplicaInfo replicaInfo1 = (DescribeLogDirsResponse.ReplicaInfo)((DescribeLogDirsResponse.LogDirInfo)logDirInfos.get((Object)onlineDir)).replicaInfos.get(this.tp1());
        LogManager qual$1 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$1 = this.tp0();
        boolean x$2 = qual$1.getLog$default$2();
        Log log0 = (Log)qual$1.getLog(x$1, x$2).get();
        LogManager qual$2 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$3 = this.tp1();
        boolean x$4 = qual$2.getLog$default$2();
        Log log1 = (Log)qual$2.getLog(x$3, x$4).get();
        Assert.assertEquals((long)log0.size(), (long)replicaInfo0.size);
        Assert.assertEquals((long)log1.size(), (long)replicaInfo1.size);
        LogManager qual$3 = ((KafkaServer)this.servers().head()).logManager();
        TopicPartition x$5 = this.tp0();
        boolean x$6 = qual$3.getLog$default$2();
        Assert.assertTrue((((Log)qual$3.getLog(x$5, x$6).get()).logEndOffset() > 0L ? 1 : 0) != 0);
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).replicaManager().getLogEndOffsetLag(this.tp0(), log0.logEndOffset(), false), (long)replicaInfo0.offsetLag);
        Assert.assertEquals((long)((KafkaServer)this.servers().head()).replicaManager().getLogEndOffsetLag(this.tp1(), log1.logEndOffset(), false), (long)replicaInfo1.offsetLag);
    }

    public DescribeLogDirsRequestTest() {
        this.topic = "topic";
        this.partitionNum = 2;
    }
}

