/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp.jingle;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.conference.source.ConferenceSourceMap;
import org.jitsi.jicofo.xmpp.JingleUtilsKt;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.jingle.JingleIqRequestHandler;
import org.jitsi.jicofo.xmpp.jingle.JingleRequestHandler;
import org.jitsi.jicofo.xmpp.jingle.JingleSessionKt;
import org.jitsi.jicofo.xmpp.jingle.JingleStats;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jingle.ContentPacketExtension;
import org.jitsi.xmpp.extensions.jingle.GroupPacketExtension;
import org.jitsi.xmpp.extensions.jingle.JingleAction;
import org.jitsi.xmpp.extensions.jingle.JingleIQ;
import org.jitsi.xmpp.extensions.jingle.JinglePacketFactory;
import org.jitsi.xmpp.extensions.jingle.Reason;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaError;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u00014B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010 \u001a\u00020!J*\u0010\"\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0$2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010(\u001a\u00020\rJ\u0010\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020\u001fJ\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001dJ*\u0010.\u001a\u00020\r2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020'0$2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u00032\u0006\u00103\u001a\u00020\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jitsi/jicofo/xmpp/jingle/JingleSession;", "", "sid", "", "remoteJid", "Lorg/jxmpp/jid/Jid;", "jingleIqRequestHandler", "Lorg/jitsi/jicofo/xmpp/jingle/JingleIqRequestHandler;", "connection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "requestHandler", "Lorg/jitsi/jicofo/xmpp/jingle/JingleRequestHandler;", "encodeSourcesAsJson", "", "(Ljava/lang/String;Lorg/jxmpp/jid/Jid;Lorg/jitsi/jicofo/xmpp/jingle/JingleIqRequestHandler;Lorg/jivesoftware/smack/AbstractXMPPConnection;Lorg/jitsi/jicofo/xmpp/jingle/JingleRequestHandler;Z)V", "localJid", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getLogger", "()Lorg/jitsi/utils/logging2/Logger;", "getRemoteJid", "()Lorg/jxmpp/jid/Jid;", "getSid", "()Ljava/lang/String;", "state", "Lorg/jitsi/jicofo/xmpp/jingle/JingleSession$State;", "addSource", "", "sources", "Lorg/jitsi/jicofo/conference/source/ConferenceSourceMap;", "createAddSourceIq", "Lorg/jitsi/xmpp/extensions/jingle/JingleIQ;", "debugState", "Lorg/jitsi/utils/OrderedJsonObject;", "initiateSession", "contents", "", "Lorg/jitsi/xmpp/extensions/jingle/ContentPacketExtension;", "additionalExtensions", "Lorg/jivesoftware/smack/packet/ExtensionElement;", "isActive", "processIq", "Lorg/jivesoftware/smack/packet/StanzaError;", "iq", "removeSource", "sourcesToRemove", "replaceTransport", "terminate", "reason", "Lorg/jitsi/xmpp/extensions/jingle/Reason;", "message", "sendIq", "State", "jicofo-common"})
public final class JingleSession {
    @NotNull
    private final String sid;
    @NotNull
    private final Jid remoteJid;
    @NotNull
    private final JingleIqRequestHandler jingleIqRequestHandler;
    @NotNull
    private final AbstractXMPPConnection connection;
    @NotNull
    private final JingleRequestHandler requestHandler;
    private final boolean encodeSourcesAsJson;
    @NotNull
    private State state;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Jid localJid;

    /*
     * WARNING - void declaration
     */
    public JingleSession(@NotNull String sid, @NotNull Jid remoteJid, @NotNull JingleIqRequestHandler jingleIqRequestHandler, @NotNull AbstractXMPPConnection connection, @NotNull JingleRequestHandler requestHandler, boolean encodeSourcesAsJson) {
        void $this$logger_u24lambda_u2d0;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)sid, (String)"sid");
        Intrinsics.checkNotNullParameter((Object)remoteJid, (String)"remoteJid");
        Intrinsics.checkNotNullParameter((Object)jingleIqRequestHandler, (String)"jingleIqRequestHandler");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)requestHandler, (String)"requestHandler");
        this.sid = sid;
        this.remoteJid = remoteJid;
        this.jingleIqRequestHandler = jingleIqRequestHandler;
        this.connection = connection;
        this.requestHandler = requestHandler;
        this.encodeSourcesAsJson = encodeSourcesAsJson;
        this.state = State.PENDING;
        Logger logger2 = logger = LoggerExtensionsKt.createLogger$default((Object)this, null, null, (int)3, null);
        JingleSession jingleSession = this;
        boolean bl = false;
        $this$logger_u24lambda_u2d0.addContext("remoteJid", this.remoteJid.toString());
        $this$logger_u24lambda_u2d0.addContext("sid", this.sid);
        jingleSession.logger = logger;
        EntityFullJid entityFullJid = this.connection.getUser();
        Intrinsics.checkNotNullExpressionValue((Object)entityFullJid, (String)"connection.user");
        this.localJid = (Jid)entityFullJid;
    }

    @NotNull
    public final String getSid() {
        return this.sid;
    }

    @NotNull
    public final Jid getRemoteJid() {
        return this.remoteJid;
    }

    public final boolean isActive() {
        return this.state == State.ACTIVE;
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @Nullable
    public final StanzaError processIq(@NotNull JingleIQ iq) {
        StanzaError stanzaError;
        Intrinsics.checkNotNullParameter((Object)iq, (String)"iq");
        JingleAction jingleAction = iq.getAction();
        if (jingleAction == null) {
            return StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.bad_request).setConditionText("Missing 'action'").build();
        }
        JingleAction action = jingleAction;
        JingleStats.Companion.stanzaReceived(action);
        if (this.state == State.ENDED) {
            return StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.gone).setConditionText("session ended").build();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[action.ordinal()]) {
            case 1: {
                this.state = State.ACTIVE;
                List list = iq.getContentList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"iq.contentList");
                StanzaError error = this.requestHandler.onSessionAccept(this, list);
                if (error != null) {
                    this.state = State.ENDED;
                }
                return error;
            }
            case 2: {
                stanzaError = this.requestHandler.onSessionInfo(this, iq);
                break;
            }
            case 3: {
                StanzaError stanzaError2;
                StanzaError it = stanzaError2 = this.requestHandler.onSessionTerminate(this, iq);
                boolean bl = false;
                this.state = State.ENDED;
                stanzaError = stanzaError2;
                break;
            }
            case 4: {
                List list = iq.getContentList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"iq.contentList");
                stanzaError = this.requestHandler.onTransportAccept(this, list);
                break;
            }
            case 5: {
                List list = iq.getContentList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"iq.contentList");
                stanzaError = this.requestHandler.onTransportInfo(this, list);
                break;
            }
            case 6: {
                this.requestHandler.onTransportReject(this, iq);
                stanzaError = null;
                break;
            }
            case 7: 
            case 8: {
                List list = iq.getContentList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"iq.contentList");
                stanzaError = this.requestHandler.onAddSource(this, list);
                break;
            }
            case 9: 
            case 10: {
                List list = iq.getContentList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"iq.contentList");
                stanzaError = this.requestHandler.onRemoveSource(this, list);
                break;
            }
            default: {
                this.logger.warn((Object)("unsupported action " + action));
                stanzaError = StanzaError.getBuilder((StanzaError.Condition)StanzaError.Condition.feature_not_implemented).setConditionText("Unsupported 'action'").build();
            }
        }
        return stanzaError;
    }

    public final void terminate(@NotNull Reason reason, @Nullable String message, boolean sendIq) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        this.logger.info((Object)("Terminating session with " + this.remoteJid + ", reason=" + reason + ", sendIq=" + sendIq));
        State oldState = this.state;
        this.state = State.ENDED;
        if (oldState == State.ENDED) {
            this.logger.warn((Object)"Terminating session which is already in state ENDED");
        }
        if (sendIq) {
            if (oldState == State.ENDED) {
                this.logger.warn((Object)("Not sending session-terminate for session in state " + this.state));
            } else {
                JingleIQ terminate = JinglePacketFactory.createSessionTerminate((Jid)this.localJid, (Jid)this.remoteJid, (String)this.sid, (Reason)reason, (String)message);
                XMPPConnection xMPPConnection = (XMPPConnection)this.connection;
                Intrinsics.checkNotNullExpressionValue((Object)terminate, (String)"terminate");
                UtilKt.tryToSendStanza(xMPPConnection, (Stanza)terminate);
                JingleStats.Companion.stanzaSent(JingleAction.SESSION_TERMINATE);
            }
        }
        this.jingleIqRequestHandler.removeSession(this);
    }

    public final boolean replaceTransport(@NotNull List<? extends ContentPacketExtension> contents, @NotNull List<? extends ExtensionElement> additionalExtensions, @NotNull ConferenceSourceMap sources) throws SmackException.NotConnectedException {
        boolean bl;
        IQ response;
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        Intrinsics.checkNotNullParameter(additionalExtensions, (String)"additionalExtensions");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        this.logger.info((Object)("Sending transport-replace, sources=" + sources + "."));
        if (this.state != State.ACTIVE) {
            this.logger.error((Object)("Sending transport-replace for session in state " + this.state));
        }
        List contentsWithSources = this.encodeSourcesAsJson ? contents : JingleSessionKt.access$toContents(sources, contents);
        JingleIQ jingleIq = JingleUtilsKt.createTransportReplace(this.localJid, this, contentsWithSources);
        jingleIq.addExtension((ExtensionElement)GroupPacketExtension.createBundleGroup((List)jingleIq.getContentList()));
        Iterable $this$forEach$iv = additionalExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtensionElement it = (ExtensionElement)element$iv;
            boolean bl2 = false;
            jingleIq.addExtension(it);
        }
        if (this.encodeSourcesAsJson) {
            jingleIq.addExtension((ExtensionElement)JingleSessionKt.toJsonMessageExtension(sources));
        }
        JingleAction jingleAction = jingleIq.getAction();
        Intrinsics.checkNotNullExpressionValue((Object)jingleAction, (String)"jingleIq.action");
        JingleStats.Companion.stanzaSent(jingleAction);
        IQ iQ = response = UtilKt.sendIqAndGetResponse(this.connection, (IQ)jingleIq);
        if ((iQ != null ? iQ.getType() : null) == IQ.Type.result) {
            bl = true;
        } else {
            IQ iQ2 = response;
            this.logger.error((Object)("Unexpected response to transport-replace: " + (iQ2 != null ? iQ2.toXML() : null)));
            bl = false;
        }
        return bl;
    }

    public final void removeSource(@NotNull ConferenceSourceMap sourcesToRemove) {
        JingleIQ jingleIQ;
        Intrinsics.checkNotNullParameter((Object)sourcesToRemove, (String)"sourcesToRemove");
        JingleIQ $this$removeSource_u24lambda_u2d3 = jingleIQ = new JingleIQ(JingleAction.SOURCEREMOVE, this.sid);
        boolean bl = false;
        $this$removeSource_u24lambda_u2d3.setFrom(this.localJid);
        $this$removeSource_u24lambda_u2d3.setType(IQ.Type.set);
        $this$removeSource_u24lambda_u2d3.setTo(this.remoteJid);
        JingleIQ removeSourceIq = jingleIQ;
        if (this.encodeSourcesAsJson) {
            removeSourceIq.addExtension((ExtensionElement)JingleSessionKt.toJsonMessageExtension(sourcesToRemove));
        } else {
            Iterable $this$forEach$iv = sourcesToRemove.toJingle();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ContentPacketExtension it = (ContentPacketExtension)element$iv;
                boolean bl2 = false;
                removeSourceIq.addContent(it);
            }
        }
        this.logger.debug(() -> JingleSession.removeSource$lambda-5(sourcesToRemove));
        if (this.state != State.ACTIVE) {
            this.logger.error((Object)("Sending source-remove for session in state " + this.state));
        }
        UtilKt.tryToSendStanza((XMPPConnection)this.connection, (Stanza)removeSourceIq);
        JingleStats.Companion.stanzaSent(JingleAction.SOURCEREMOVE);
    }

    public final void addSource(@NotNull ConferenceSourceMap sources) {
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        this.logger.debug(() -> JingleSession.addSource$lambda-6(sources));
        JingleStats.Companion.stanzaSent(JingleAction.SOURCEADD);
        if (this.state != State.ACTIVE) {
            this.logger.error((Object)("Sending source-add for session in state " + this.state));
        }
        UtilKt.tryToSendStanza((XMPPConnection)this.connection, (Stanza)this.createAddSourceIq(sources));
    }

    public final boolean initiateSession(@NotNull List<? extends ContentPacketExtension> contents, @NotNull List<? extends ExtensionElement> additionalExtensions, @NotNull ConferenceSourceMap sources) throws SmackException.NotConnectedException {
        boolean bl;
        IQ response;
        JingleIQ jingleIQ;
        Intrinsics.checkNotNullParameter(contents, (String)"contents");
        Intrinsics.checkNotNullParameter(additionalExtensions, (String)"additionalExtensions");
        Intrinsics.checkNotNullParameter((Object)sources, (String)"sources");
        if (this.state != State.PENDING) {
            this.logger.error((Object)("Sending session-initiate for session in state " + this.state));
        }
        List contentsWithSources = this.encodeSourcesAsJson ? contents : JingleSessionKt.access$toContents(sources, contents);
        JingleIQ $this$initiateSession_u24lambda_u2d8 = jingleIQ = JingleUtilsKt.createSessionInitiate(this.localJid, this.remoteJid, this.sid, contentsWithSources);
        boolean bl2 = false;
        $this$initiateSession_u24lambda_u2d8.addExtension((ExtensionElement)GroupPacketExtension.createBundleGroup((List)$this$initiateSession_u24lambda_u2d8.getContentList()));
        Iterable $this$forEach$iv = additionalExtensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExtensionElement it = (ExtensionElement)element$iv;
            boolean bl3 = false;
            $this$initiateSession_u24lambda_u2d8.addExtension(it);
        }
        if (this.encodeSourcesAsJson) {
            $this$initiateSession_u24lambda_u2d8.addExtension((ExtensionElement)JingleSessionKt.toJsonMessageExtension(sources));
        }
        JingleIQ sessionInitiate = jingleIQ;
        this.jingleIqRequestHandler.registerSession(this);
        JingleAction jingleAction = sessionInitiate.getAction();
        Intrinsics.checkNotNullExpressionValue((Object)jingleAction, (String)"sessionInitiate.action");
        JingleStats.Companion.stanzaSent(jingleAction);
        IQ iQ = response = UtilKt.sendIqAndGetResponse(this.connection, (IQ)sessionInitiate);
        if ((iQ != null ? iQ.getType() : null) == IQ.Type.result) {
            bl = true;
        } else {
            IQ iQ2 = response;
            this.logger.error((Object)("Unexpected response to session-initiate: " + (iQ2 != null ? iQ2.toXML() : null)));
            bl = false;
        }
        return bl;
    }

    private final JingleIQ createAddSourceIq(ConferenceSourceMap sources) {
        JingleIQ jingleIQ;
        JingleIQ $this$createAddSourceIq_u24lambda_u2d10 = jingleIQ = new JingleIQ(JingleAction.SOURCEADD, this.sid);
        boolean bl = false;
        $this$createAddSourceIq_u24lambda_u2d10.setFrom(this.localJid);
        $this$createAddSourceIq_u24lambda_u2d10.setType(IQ.Type.set);
        $this$createAddSourceIq_u24lambda_u2d10.setTo(this.remoteJid);
        if (this.encodeSourcesAsJson) {
            $this$createAddSourceIq_u24lambda_u2d10.addExtension((ExtensionElement)JingleSessionKt.toJsonMessageExtension(sources));
        } else {
            Iterable $this$forEach$iv = sources.toJingle();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ContentPacketExtension it = (ContentPacketExtension)element$iv;
                boolean bl2 = false;
                $this$createAddSourceIq_u24lambda_u2d10.addContent(it);
            }
        }
        return jingleIQ;
    }

    @NotNull
    public final OrderedJsonObject debugState() {
        OrderedJsonObject orderedJsonObject;
        OrderedJsonObject $this$debugState_u24lambda_u2d11 = orderedJsonObject = new OrderedJsonObject();
        boolean bl = false;
        $this$debugState_u24lambda_u2d11.put((Object)"sid", (Object)this.sid);
        $this$debugState_u24lambda_u2d11.put((Object)"remoteJid", (Object)this.remoteJid.toString());
        $this$debugState_u24lambda_u2d11.put((Object)"state", (Object)this.state.toString());
        return orderedJsonObject;
    }

    private static final String removeSource$lambda-5(ConferenceSourceMap $sourcesToRemove) {
        Intrinsics.checkNotNullParameter((Object)$sourcesToRemove, (String)"$sourcesToRemove");
        return "Sending source-remove, sources=" + $sourcesToRemove;
    }

    private static final String addSource$lambda-6(ConferenceSourceMap $sources) {
        Intrinsics.checkNotNullParameter((Object)$sources, (String)"$sources");
        return "Sending source-add, sources=" + $sources;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/jicofo/xmpp/jingle/JingleSession$State;", "", "(Ljava/lang/String;I)V", "PENDING", "ACTIVE", "ENDED", "jicofo-common"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State PENDING = new State();
        public static final /* enum */ State ACTIVE = new State();
        public static final /* enum */ State ENDED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        static {
            $VALUES = stateArray = new State[]{State.PENDING, State.ACTIVE, State.ENDED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JingleAction.values().length];
            nArray[JingleAction.SESSION_ACCEPT.ordinal()] = 1;
            nArray[JingleAction.SESSION_INFO.ordinal()] = 2;
            nArray[JingleAction.SESSION_TERMINATE.ordinal()] = 3;
            nArray[JingleAction.TRANSPORT_ACCEPT.ordinal()] = 4;
            nArray[JingleAction.TRANSPORT_INFO.ordinal()] = 5;
            nArray[JingleAction.TRANSPORT_REJECT.ordinal()] = 6;
            nArray[JingleAction.ADDSOURCE.ordinal()] = 7;
            nArray[JingleAction.SOURCEADD.ordinal()] = 8;
            nArray[JingleAction.REMOVESOURCE.ordinal()] = 9;
            nArray[JingleAction.SOURCEREMOVE.ordinal()] = 10;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

