/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtpadapter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import net.sf.gogui.gtpadapter.GtpAdapter;
import net.sf.gogui.utils.Options;
import net.sf.gogui.utils.StringUtils;
import net.sf.gogui.version.Version;

public final class Main {
    public static void main(String[] stringArray) {
        try {
            Object object;
            String[] stringArray2 = new String[]{"config:", "emuhandicap", "emuloadsgf", "fillpasses", "gtpfile:", "help", "log:", "lowercase", "noscore", "name:", "resign:", "size:", "verbose", "version", "version1"};
            Options options = Options.parse(stringArray, stringArray2);
            if (options.isSet("help")) {
                Main.printUsage(System.out);
                return;
            }
            if (options.isSet("version")) {
                if (options.getArguments().size() > 0) {
                    Main.fail("No arguments allowed with option -version");
                }
                System.out.println("GtpAdapter " + Version.get());
                return;
            }
            boolean bl = options.isSet("verbose");
            boolean bl2 = options.isSet("noscore");
            boolean bl3 = options.isSet("version1");
            boolean bl4 = options.isSet("emuhandicap");
            boolean bl5 = options.isSet("emuloadsgf");
            boolean bl6 = options.isSet("fillpasses");
            String string = options.getString("name", null);
            String string2 = options.getString("gtpfile", null);
            boolean bl7 = options.isSet("resign");
            int n = options.getInteger("resign");
            ArrayList arrayList = options.getArguments();
            if (arrayList.size() != 1) {
                Main.printUsage(System.err);
                Main.fail();
            }
            PrintStream printStream = null;
            if (options.isSet("log")) {
                object = new File(options.getString("log"));
                printStream = new PrintStream(new FileOutputStream((File)object));
            }
            object = (String)arrayList.get(0);
            GtpAdapter gtpAdapter = new GtpAdapter((String)object, printStream, string2, bl);
            if (bl5) {
                gtpAdapter.setEmuLoadSgf();
            }
            if (bl4) {
                gtpAdapter.setEmuHandicap();
            }
            if (bl2) {
                gtpAdapter.setNoScore();
            }
            if (bl3) {
                gtpAdapter.setVersion1();
            }
            if (bl6) {
                gtpAdapter.setFillPasses();
            }
            if (string != null) {
                gtpAdapter.setName(string);
            }
            if (bl7) {
                gtpAdapter.setResign(n);
            }
            if (options.isSet("lowercase")) {
                gtpAdapter.setLowerCase();
            }
            if (options.isSet("size")) {
                int n2 = options.getInteger("size", 0, 1, 25);
                gtpAdapter.setFixedSize(n2);
            }
            gtpAdapter.mainLoop(System.in, System.out);
            gtpAdapter.close();
            if (printStream != null) {
                printStream.close();
            }
        }
        catch (Throwable throwable) {
            StringUtils.printException(throwable);
            Main.fail();
        }
    }

    private Main() {
    }

    private static void fail() {
        System.exit(-1);
    }

    private static void fail(String string) {
        System.err.println(string);
        Main.fail();
    }

    private static void printUsage(PrintStream printStream) {
        String string = "Usage: java -jar gtpadapter.jar program\n\n-config       config file\n-emuhandicap  emulate free handicap commands\n-emuloadsgf   emulate loadsgf commands\n-fillpasses   fill non-alternating moves with pass moves\n-gtpfile      file with GTP commands to send at startup\n-help         print help and exit\n-log file     log GTP stream to file\n-lowercase    translate move commands to lowercase\n-noscore      hide score commands\n-resign score resign if estimated score is below threshold\n-size         accept only this board size\n-verbose      log GTP stream to stderr\n-version      print version and exit\n-version1     report GTP version 1 in protocol_version";
        printStream.print(string);
    }
}

