/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gtp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.gogui.game.TimeSettings;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gtp.GtpError;
import net.sf.gogui.utils.StringUtils;

public final class GtpUtils {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static double[][] parseDoubleBoard(String string, int n) throws GtpError {
        try {
            double[][] dArray = new double[n][n];
            String[][] stringArray = GtpUtils.parseStringBoard(string, n);
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray[i][j] = Double.parseDouble(stringArray[i][j]);
                }
            }
            return dArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new GtpError("Floating point number expected");
        }
    }

    public static GoPoint parsePoint(String string, int n) throws GtpError {
        try {
            return GoPoint.parsePoint(string, n);
        }
        catch (GoPoint.InvalidPoint invalidPoint) {
            throw new GtpError("Invalid point " + string + " (size " + n + ")");
        }
    }

    public static GoPoint[] parsePointList(String string, int n) throws GtpError {
        try {
            return GoPoint.parsePointList(string, n);
        }
        catch (GoPoint.InvalidPoint invalidPoint) {
            throw new GtpError("Invalid point or move");
        }
    }

    public static ArrayList parsePointArrayList(String string, int n) throws GtpError {
        try {
            return GoPoint.parsePointListArrayList(string, n);
        }
        catch (GoPoint.InvalidPoint invalidPoint) {
            throw new GtpError("Invalid point or move");
        }
    }

    public static GoPoint[] parsePointString(String string, int n) {
        int n2;
        String string2 = "\\b([Pp][Aa][Ss][Ss]|[A-Ta-t](1\\d|[1-9]))\\b";
        Pattern pattern = Pattern.compile(string2, 8);
        Matcher matcher = pattern.matcher(string);
        ArrayList<GoPoint> arrayList = new ArrayList<GoPoint>(32);
        while (matcher.find()) {
            GoPoint goPoint;
            int n3 = matcher.start();
            n2 = matcher.end();
            try {
                goPoint = GtpUtils.parsePoint(string.substring(n3, n2), n);
            }
            catch (GtpError gtpError) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
            arrayList.add(goPoint);
        }
        GoPoint[] goPointArray = new GoPoint[arrayList.size()];
        for (n2 = 0; n2 < goPointArray.length; ++n2) {
            goPointArray[n2] = (GoPoint)arrayList.get(n2);
        }
        return goPointArray;
    }

    public static void parsePointStringList(String string, ArrayList arrayList, ArrayList arrayList2, int n) throws GtpError {
        arrayList.clear();
        arrayList2.clear();
        String[] stringArray = StringUtils.splitArguments(string);
        boolean bl = true;
        GoPoint goPoint = null;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("")) continue;
            if (bl) {
                goPoint = GtpUtils.parsePoint(stringArray[i], n);
                bl = false;
                continue;
            }
            bl = true;
            arrayList.add(goPoint);
            arrayList2.add(stringArray[i]);
        }
        if (!bl) {
            throw new GtpError("Missing string");
        }
    }

    public static String[][] parseStringBoard(String string, int n) throws GtpError {
        String[][] stringArray = new String[n][n];
        try {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
            for (int i = n - 1; i >= 0; --i) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    throw new GtpError("Incomplete string board");
                }
                if (string2.trim().equals("")) {
                    ++i;
                    continue;
                }
                String[] stringArray2 = StringUtils.splitArguments(string2);
                if (stringArray2.length < n) {
                    throw new GtpError("Incomplete string board");
                }
                for (int j = 0; j < n; ++j) {
                    stringArray[j][i] = stringArray2[j];
                }
            }
        }
        catch (IOException iOException) {
            throw new GtpError("I/O error");
        }
        return stringArray;
    }

    public static Move[] parseVariation(String string, GoColor goColor, int n) {
        ArrayList<Move> arrayList = new ArrayList<Move>(32);
        String[] stringArray = StringUtils.splitArguments(string);
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            GoPoint goPoint;
            String string2 = stringArray[i].toLowerCase();
            if (string2.equals("b") || string2.equals("black")) {
                goColor = GoColor.BLACK;
                bl = true;
                continue;
            }
            if (string2.equals("w") || string2.equals("white")) {
                goColor = GoColor.WHITE;
                bl = true;
                continue;
            }
            try {
                goPoint = GtpUtils.parsePoint(string2, n);
            }
            catch (GtpError gtpError) {
                continue;
            }
            if (!bl) {
                goColor = goColor.otherColor();
            }
            arrayList.add(Move.get(goPoint, goColor));
            bl = false;
        }
        Move[] moveArray = new Move[arrayList.size()];
        for (int i = 0; i < moveArray.length; ++i) {
            moveArray[i] = (Move)arrayList.get(i);
        }
        return moveArray;
    }

    public static String getPlaySequenceCommand(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("play_sequence");
        for (int i = 0; i < arrayList.size(); ++i) {
            Move move = (Move)arrayList.get(i);
            GoColor goColor = move.getColor();
            if (goColor == GoColor.BLACK) {
                stringBuffer.append(" b ");
            } else if (goColor == GoColor.WHITE) {
                stringBuffer.append(" w ");
            } else {
                stringBuffer.append(" empty ");
            }
            stringBuffer.append(GoPoint.toString(move.getPoint()));
        }
        return stringBuffer.toString();
    }

    public static String getTimeSettingsCommand(TimeSettings timeSettings) {
        long l = timeSettings.getPreByoyomi() / 1000L;
        long l2 = 0L;
        long l3 = 0L;
        if (timeSettings.getUseByoyomi()) {
            l2 = timeSettings.getByoyomi() / 1000L;
            l3 = timeSettings.getByoyomiMoves();
        }
        return "time_settings " + l + " " + l2 + " " + l3;
    }

    private GtpUtils() {
    }

    static {
        $assertionsDisabled = !GtpUtils.class.desiredAssertionStatus();
    }
}

