/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import net.sf.gogui.utils.Platform;

public class GuiTextPane {
    private boolean m_noLineSpacing;
    private final JTextComponent m_textComponent;
    private final JTextPane m_textPane;

    public GuiTextPane(boolean bl) {
        if (bl || Platform.isGnuClasspath()) {
            JTextArea jTextArea = new JTextArea();
            this.m_textComponent = jTextArea;
            if (!Platform.isGnuClasspath()) {
                jTextArea.setLineWrap(true);
                jTextArea.setWrapStyleWord(true);
            }
            this.m_textPane = null;
        } else {
            this.m_textPane = new JTextPane();
            this.m_textComponent = this.m_textPane;
        }
    }

    public void addStyle(String string, Color color) {
        this.addStyle(string, color, null, false);
    }

    public void addStyle(String string, Color color, Color color2, boolean bl) {
        if (this.m_textPane == null) {
            return;
        }
        StyledDocument styledDocument = this.m_textPane.getStyledDocument();
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        Style style = styleContext.getStyle("default");
        Style style2 = styledDocument.addStyle(string, style);
        if (color != null) {
            StyleConstants.setForeground(style2, color);
        }
        if (color2 != null) {
            StyleConstants.setBackground(style2, color2);
        }
        StyleConstants.setBold(style2, bl);
        if (this.m_noLineSpacing) {
            StyleConstants.setLineSpacing(style2, 0.0f);
        }
    }

    JTextComponent get() {
        return this.m_textComponent;
    }

    Document getDocument() {
        return this.m_textComponent.getDocument();
    }

    Style getStyle(String string) {
        if (this.m_textPane == null) {
            return null;
        }
        return this.m_textPane.getStyledDocument().getStyle(string);
    }

    public void setNoLineSpacing() {
        this.m_noLineSpacing = true;
    }

    public void setStyle(int n, int n2, String string) {
        Style style;
        if (this.m_textPane == null) {
            return;
        }
        StyledDocument styledDocument = this.m_textPane.getStyledDocument();
        if (string == null) {
            StyleContext styleContext = StyleContext.getDefaultStyleContext();
            style = styleContext.getStyle("default");
        } else {
            style = styledDocument.getStyle(string);
        }
        styledDocument.setCharacterAttributes(n, n2, style, true);
    }
}

