/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.gui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.sf.gogui.game.MarkType;
import net.sf.gogui.game.Node;
import net.sf.gogui.go.Board;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.gui.GuiBoard;

public final class GuiBoardUtils {
    public static Color getColor(String string) {
        if (string.equals("blue")) {
            return Color.blue;
        }
        if (string.equals("cyan")) {
            return Color.cyan;
        }
        if (string.equals("green")) {
            return Color.green;
        }
        if (string.equals("gray")) {
            return Color.lightGray;
        }
        if (string.equals("magenta")) {
            return Color.magenta;
        }
        if (string.equals("pink")) {
            return Color.pink;
        }
        if (string.equals("red")) {
            return Color.red;
        }
        if (string.equals("yellow")) {
            return Color.yellow;
        }
        if (string.equals("black")) {
            return Color.black;
        }
        if (string.equals("white")) {
            return Color.white;
        }
        try {
            return Color.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static boolean[][] getMarkSquare(GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        boolean[][] blArray = new boolean[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                GoPoint goPoint = GoPoint.get(i, j);
                blArray[i][j] = guiBoard.getMarkSquare(goPoint);
            }
        }
        return blArray;
    }

    public static String[][] getLabels(GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        String[][] stringArray = new String[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                GoPoint goPoint = GoPoint.get(i, j);
                stringArray[i][j] = guiBoard.getLabel(goPoint);
            }
        }
        return stringArray;
    }

    public static boolean[][] getSelects(GuiBoard guiBoard) {
        int n = guiBoard.getBoardSize();
        boolean[][] blArray = new boolean[n][n];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                GoPoint goPoint = GoPoint.get(i, j);
                blArray[i][j] = guiBoard.getSelect(goPoint);
            }
        }
        return blArray;
    }

    public static void setSelect(GuiBoard guiBoard, ArrayList arrayList, boolean bl) {
        if (arrayList == null) {
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            guiBoard.setSelect((GoPoint)arrayList.get(i), bl);
        }
    }

    public static void scoreBegin(GuiBoard guiBoard, Board board, GoPoint[] goPointArray) {
        board.scoreBegin(goPointArray);
        if (goPointArray != null) {
            for (int i = 0; i < goPointArray.length; ++i) {
                guiBoard.setCrossHair(goPointArray[i], true);
            }
        }
        GuiBoardUtils.calcScore(guiBoard, board);
    }

    public static void scoreSetDead(GuiBoard guiBoard, Board board, GoPoint goPoint) {
        GoColor goColor = board.getColor(goPoint);
        if (goColor == GoColor.EMPTY) {
            return;
        }
        ArrayList arrayList = new ArrayList(board.getNumberPoints());
        board.getStones(goPoint, goColor, arrayList);
        boolean bl = !board.scoreGetDead((GoPoint)arrayList.get(0));
        for (int i = 0; i < arrayList.size(); ++i) {
            GoPoint goPoint2 = (GoPoint)arrayList.get(i);
            board.scoreSetDead(goPoint2, bl);
            guiBoard.setCrossHair(goPoint2, bl);
        }
        GuiBoardUtils.calcScore(guiBoard, board);
    }

    public static void showBWBoard(GuiBoard guiBoard, String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                GoPoint goPoint = GoPoint.get(i, j);
                String string = stringArray[i][j].toLowerCase();
                if (string.equals("b") || string.equals("black")) {
                    guiBoard.setTerritory(goPoint, GoColor.BLACK);
                    continue;
                }
                if (string.equals("w") || string.equals("white")) {
                    guiBoard.setTerritory(goPoint, GoColor.WHITE);
                    continue;
                }
                guiBoard.setTerritory(goPoint, GoColor.EMPTY);
            }
        }
    }

    public static void showChildrenMoves(GuiBoard guiBoard, ArrayList arrayList) {
        guiBoard.clearAllLabels();
        int n = 0;
        char c = 'A';
        for (int i = 0; i < arrayList.size(); ++i) {
            GoPoint goPoint = (GoPoint)arrayList.get(i);
            String string = guiBoard.getLabel(goPoint);
            if (!string.equals("")) {
                if (string.endsWith(".")) continue;
                guiBoard.setLabel(goPoint, string + ".");
                continue;
            }
            if (n >= 26) {
                guiBoard.setLabel(goPoint, "+");
            } else {
                guiBoard.setLabel(goPoint, Character.toString(c));
            }
            if (n < 26) {
                c = (char)(c + '\u0001');
            }
            ++n;
        }
    }

    public static void showColorBoard(GuiBoard guiBoard, String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                GoPoint goPoint = GoPoint.get(i, j);
                guiBoard.setFieldBackground(goPoint, GuiBoardUtils.getColor(stringArray[i][j]));
            }
        }
    }

    public static void showDoubleBoard(GuiBoard guiBoard, double[][] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                guiBoard.setInfluence(GoPoint.get(i, j), dArray[i][j]);
            }
        }
    }

    public static void showStringBoard(GuiBoard guiBoard, String[][] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray[i].length; ++j) {
                GoPoint goPoint = GoPoint.get(i, j);
                guiBoard.setLabel(goPoint, stringArray[i][j]);
            }
        }
    }

    public static void showMarkup(GuiBoard guiBoard, Node node) {
        Map map;
        int n;
        ArrayList arrayList = node.getMarked(MarkType.MARK);
        if (arrayList != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                guiBoard.setMark((GoPoint)arrayList.get(n), true);
            }
        }
        if ((arrayList = node.getMarked(MarkType.CIRCLE)) != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                guiBoard.setMarkCircle((GoPoint)arrayList.get(n), true);
            }
        }
        if ((arrayList = node.getMarked(MarkType.SQUARE)) != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                guiBoard.setMarkSquare((GoPoint)arrayList.get(n), true);
            }
        }
        if ((arrayList = node.getMarked(MarkType.TRIANGLE)) != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                guiBoard.setMarkTriangle((GoPoint)arrayList.get(n), true);
            }
        }
        GuiBoardUtils.setSelect(guiBoard, node.getMarked(MarkType.SELECT), true);
        arrayList = node.getMarked(MarkType.TERRITORY_BLACK);
        if (arrayList != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                guiBoard.setTerritory((GoPoint)arrayList.get(n), GoColor.BLACK);
            }
        }
        if ((arrayList = node.getMarked(MarkType.TERRITORY_WHITE)) != null) {
            for (n = 0; n < arrayList.size(); ++n) {
                guiBoard.setTerritory((GoPoint)arrayList.get(n), GoColor.WHITE);
            }
        }
        if ((map = node.getLabels()) != null) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                GoPoint goPoint = (GoPoint)entry.getKey();
                String string = (String)entry.getValue();
                guiBoard.setLabel(goPoint, string);
            }
        }
    }

    public static void showPointList(GuiBoard guiBoard, GoPoint[] goPointArray) {
        guiBoard.clearAllMarkup();
        for (int i = 0; i < goPointArray.length; ++i) {
            GoPoint goPoint = goPointArray[i];
            if (goPoint == null) continue;
            guiBoard.setMarkSquare(goPoint, true);
        }
    }

    public static void showPointStringList(GuiBoard guiBoard, ArrayList arrayList, ArrayList arrayList2) {
        guiBoard.clearAllLabels();
        for (int i = 0; i < arrayList.size(); ++i) {
            GoPoint goPoint = (GoPoint)arrayList.get(i);
            String string = (String)arrayList2.get(i);
            if (goPoint == null) continue;
            guiBoard.setLabel(goPoint, string);
        }
    }

    public static void showVariation(GuiBoard guiBoard, Move[] moveArray) {
        guiBoard.clearAllLabels();
        for (int i = moveArray.length - 1; i >= 0; --i) {
            Move move = moveArray[i];
            if (move.getPoint() == null) continue;
            guiBoard.setColor(move.getPoint(), move.getColor());
            guiBoard.setLabel(move.getPoint(), Integer.toString(i + 1));
        }
    }

    public static void updateFromGoBoard(GuiBoard guiBoard, Board board, boolean bl) {
        for (int i = 0; i < board.getNumberPoints(); ++i) {
            GoPoint goPoint = board.getPoint(i);
            guiBoard.setColor(goPoint, board.getColor(goPoint));
        }
        GoPoint goPoint = null;
        int n = board.getMoveNumber();
        if (n > 0) {
            goPoint = board.getMove(n - 1).getPoint();
        }
        if (bl) {
            guiBoard.markLastMove(goPoint);
        } else {
            guiBoard.markLastMove(null);
        }
        if (goPoint != null) {
            guiBoard.setCursor(goPoint);
        } else {
            int n2 = guiBoard.getBoardSize();
            guiBoard.setCursor(GoPoint.get(n2 / 2, n2 / 2));
        }
    }

    private GuiBoardUtils() {
    }

    private static void calcScore(GuiBoard guiBoard, Board board) {
        board.calcScore();
        for (int i = 0; i < board.getNumberPoints(); ++i) {
            GoPoint goPoint = board.getPoint(i);
            GoColor goColor = board.getScore(goPoint);
            guiBoard.setTerritory(goPoint, goColor);
        }
    }
}

