/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.components.electromechanical;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.ObjectCache;
import org.diylc.common.OrientationHV;
import org.diylc.components.AbstractTransparentComponent;
import org.diylc.components.electromechanical.ToggleSwitchType;
import org.diylc.core.ComponentState;
import org.diylc.core.IDrawingObserver;
import org.diylc.core.Project;
import org.diylc.core.Theme;
import org.diylc.core.VisibilityPolicy;
import org.diylc.core.annotations.ComponentDescriptor;
import org.diylc.core.annotations.EditableProperty;
import org.diylc.core.measures.Size;
import org.diylc.core.measures.SizeUnit;
import org.diylc.utils.Constants;

@ComponentDescriptor(name="Mini Toggle Switch", category="Electromechanical", author="Branislav Stojkovic", description="Panel mounted mini toggle switch", stretchable=false, zOrder=4.0, instanceNamePrefix="SW", autoEdit=false)
public class MiniToggleSwitch
extends AbstractTransparentComponent<ToggleSwitchType> {
    private static final long serialVersionUID = 1L;
    private static Size SPACING = new Size(Double.valueOf(0.2), SizeUnit.in);
    private static Size MARGIN = new Size(Double.valueOf(0.08), SizeUnit.in);
    private static Size CIRCLE_SIZE = new Size(Double.valueOf(0.09), SizeUnit.in);
    private static Size LUG_WIDTH = new Size(Double.valueOf(0.06), SizeUnit.in);
    private static Size LUG_THICKNESS = new Size(Double.valueOf(0.02), SizeUnit.in);
    private static Color BODY_COLOR = Color.decode("#3299CC");
    private static Color BORDER_COLOR = BODY_COLOR.darker();
    private static Color CIRCLE_COLOR = Color.decode("#FFFFAA");
    protected Point[] controlPoints = new Point[]{new Point(0, 0)};
    protected transient Shape body;
    protected String name;
    protected ToggleSwitchType switchType = ToggleSwitchType.DPDT;
    private OrientationHV orientation = OrientationHV.VERTICAL;

    public MiniToggleSwitch() {
        this.updateControlPoints();
    }

    private void updateControlPoints() {
        Point firstPoint = this.controlPoints[0];
        int spacing = (int)SPACING.convertToPixels();
        switch (this.switchType) {
            case SPST: {
                this.controlPoints = new Point[]{firstPoint, new Point(firstPoint.x, firstPoint.y + spacing)};
                break;
            }
            case SPDT: {
                this.controlPoints = new Point[]{firstPoint, new Point(firstPoint.x, firstPoint.y + spacing), new Point(firstPoint.x, firstPoint.y + 2 * spacing)};
                break;
            }
            case DPDT: {
                this.controlPoints = new Point[]{firstPoint, new Point(firstPoint.x, firstPoint.y + spacing), new Point(firstPoint.x, firstPoint.y + 2 * spacing), new Point(firstPoint.x + spacing, firstPoint.y), new Point(firstPoint.x + spacing, firstPoint.y + spacing), new Point(firstPoint.x + spacing, firstPoint.y + 2 * spacing)};
                break;
            }
            case _3PDT: {
                this.controlPoints = new Point[]{firstPoint, new Point(firstPoint.x, firstPoint.y + spacing), new Point(firstPoint.x, firstPoint.y + 2 * spacing), new Point(firstPoint.x + spacing, firstPoint.y), new Point(firstPoint.x + spacing, firstPoint.y + spacing), new Point(firstPoint.x + spacing, firstPoint.y + 2 * spacing), new Point(firstPoint.x + 2 * spacing, firstPoint.y), new Point(firstPoint.x + 2 * spacing, firstPoint.y + spacing), new Point(firstPoint.x + 2 * spacing, firstPoint.y + 2 * spacing)};
                break;
            }
            case _4PDT: {
                this.controlPoints = new Point[]{firstPoint, new Point(firstPoint.x, firstPoint.y + spacing), new Point(firstPoint.x, firstPoint.y + 2 * spacing), new Point(firstPoint.x + spacing, firstPoint.y), new Point(firstPoint.x + spacing, firstPoint.y + spacing), new Point(firstPoint.x + spacing, firstPoint.y + 2 * spacing), new Point(firstPoint.x + 2 * spacing, firstPoint.y), new Point(firstPoint.x + 2 * spacing, firstPoint.y + spacing), new Point(firstPoint.x + 2 * spacing, firstPoint.y + 2 * spacing), new Point(firstPoint.x + 3 * spacing, firstPoint.y), new Point(firstPoint.x + 3 * spacing, firstPoint.y + spacing), new Point(firstPoint.x + 3 * spacing, firstPoint.y + 2 * spacing)};
                break;
            }
            case _5PDT: {
                this.controlPoints = new Point[]{firstPoint, new Point(firstPoint.x, firstPoint.y + spacing), new Point(firstPoint.x, firstPoint.y + 2 * spacing), new Point(firstPoint.x + spacing, firstPoint.y), new Point(firstPoint.x + spacing, firstPoint.y + spacing), new Point(firstPoint.x + spacing, firstPoint.y + 2 * spacing), new Point(firstPoint.x + 2 * spacing, firstPoint.y), new Point(firstPoint.x + 2 * spacing, firstPoint.y + spacing), new Point(firstPoint.x + 2 * spacing, firstPoint.y + 2 * spacing), new Point(firstPoint.x + 3 * spacing, firstPoint.y), new Point(firstPoint.x + 3 * spacing, firstPoint.y + spacing), new Point(firstPoint.x + 3 * spacing, firstPoint.y + 2 * spacing), new Point(firstPoint.x + 4 * spacing, firstPoint.y), new Point(firstPoint.x + 4 * spacing, firstPoint.y + spacing), new Point(firstPoint.x + 4 * spacing, firstPoint.y + 2 * spacing)};
            }
        }
        AffineTransform xform = AffineTransform.getRotateInstance(-1.5707963267948966, firstPoint.x, firstPoint.y);
        if (this.getOrientation() == OrientationHV.HORIZONTAL) {
            for (int i = 1; i < this.controlPoints.length; ++i) {
                xform.transform(this.controlPoints[i], this.controlPoints[i]);
            }
        }
    }

    public Point getControlPoint(int index) {
        return this.controlPoints[index];
    }

    public boolean isControlPointSticky(int index) {
        return true;
    }

    public VisibilityPolicy getControlPointVisibilityPolicy(int index) {
        return VisibilityPolicy.NEVER;
    }

    public int getControlPointCount() {
        return this.controlPoints.length;
    }

    public void setControlPoint(Point point, int index) {
        this.controlPoints[index].setLocation(point);
        this.body = null;
    }

    @EditableProperty
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @EditableProperty(name="Type")
    public ToggleSwitchType getValue() {
        return this.switchType;
    }

    public void setValue(ToggleSwitchType value) {
        this.switchType = value;
        this.updateControlPoints();
        this.body = null;
    }

    @EditableProperty
    public OrientationHV getOrientation() {
        if (this.orientation == null) {
            this.orientation = OrientationHV.VERTICAL;
        }
        return this.orientation;
    }

    public void setOrientation(OrientationHV orientation) {
        this.orientation = orientation;
        this.updateControlPoints();
        this.body = null;
    }

    public void draw(Graphics2D g2d, ComponentState componentState, boolean outlineMode, Project project, IDrawingObserver drawingObserver) {
        if (this.checkPointsClipped(g2d.getClip())) {
            return;
        }
        Shape body = this.getBody();
        Theme theme = (Theme)ConfigurationManager.getInstance().readObject("theme", (Object)Constants.DEFAULT_THEME);
        if (body != null) {
            Composite oldComposite = g2d.getComposite();
            if (this.alpha < MAX_ALPHA) {
                g2d.setComposite(AlphaComposite.getInstance(3, 1.0f * (float)this.alpha / (float)MAX_ALPHA));
            }
            g2d.setColor(outlineMode ? Constants.TRANSPARENT_COLOR : BODY_COLOR);
            g2d.fill(body);
            g2d.setComposite(oldComposite);
            g2d.setStroke(ObjectCache.getInstance().fetchBasicStroke(1));
            Color finalBorderColor = outlineMode ? (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : theme.getOutlineColor()) : (componentState == ComponentState.SELECTED || componentState == ComponentState.DRAGGING ? SELECTION_COLOR : BORDER_COLOR);
            g2d.setColor(finalBorderColor);
            g2d.draw(body);
        }
        drawingObserver.stopTracking();
        int circleDiameter = this.getClosestOdd((int)CIRCLE_SIZE.convertToPixels());
        int lugWidth = this.getClosestOdd((int)LUG_WIDTH.convertToPixels());
        int lugHeight = this.getClosestOdd((int)LUG_THICKNESS.convertToPixels());
        for (Point p : this.controlPoints) {
            if (outlineMode) {
                g2d.setColor(theme.getOutlineColor());
                g2d.drawRect(p.x - lugWidth / 2, p.y - lugHeight / 2, lugWidth, lugHeight);
                continue;
            }
            g2d.setColor(CIRCLE_COLOR);
            g2d.fillOval(p.x - circleDiameter / 2, p.y - circleDiameter / 2, circleDiameter, circleDiameter);
            g2d.setColor(METAL_COLOR);
            g2d.fillRect(p.x - lugWidth / 2, p.y - lugHeight / 2, lugWidth, lugHeight);
        }
    }

    public Shape getBody() {
        if (this.body == null) {
            Point firstPoint = this.controlPoints[0];
            int margin = (int)MARGIN.convertToPixels();
            int spacing = (int)SPACING.convertToPixels();
            switch (this.switchType) {
                case SPST: {
                    this.body = new RoundRectangle2D.Double(firstPoint.x - margin, firstPoint.y - margin, 2 * margin, 2 * margin + spacing, margin, margin);
                    break;
                }
                case SPDT: {
                    this.body = new RoundRectangle2D.Double(firstPoint.x - margin, firstPoint.y - margin, 2 * margin, 2 * margin + 2 * spacing, margin, margin);
                    break;
                }
                case DPDT: {
                    this.body = new RoundRectangle2D.Double(firstPoint.x - margin, firstPoint.y - margin, 2 * margin + spacing, 2 * margin + 2 * spacing, margin, margin);
                    break;
                }
                case _3PDT: {
                    this.body = new RoundRectangle2D.Double(firstPoint.x - margin, firstPoint.y - margin, 2 * margin + 2 * spacing, 2 * margin + 2 * spacing, margin, margin);
                    break;
                }
                case _4PDT: {
                    this.body = new RoundRectangle2D.Double(firstPoint.x - margin, firstPoint.y - margin, 2 * margin + 3 * spacing, 2 * margin + 2 * spacing, margin, margin);
                    break;
                }
                case _5PDT: {
                    this.body = new RoundRectangle2D.Double(firstPoint.x - margin, firstPoint.y - margin, 2 * margin + 4 * spacing, 2 * margin + 2 * spacing, margin, margin);
                }
            }
            if (this.getOrientation() == OrientationHV.HORIZONTAL) {
                AffineTransform xform = AffineTransform.getRotateInstance(-1.5707963267948966, firstPoint.x, firstPoint.y);
                this.body = new Area(this.body);
                ((Area)this.body).transform(xform);
            }
        }
        return this.body;
    }

    public void drawIcon(Graphics2D g2d, int width, int height) {
        int circleSize = 5 * width / 32;
        g2d.setColor(BODY_COLOR);
        g2d.fillRoundRect(width / 4, 1, width / 2, height - 2, circleSize, circleSize);
        g2d.setColor(BORDER_COLOR);
        g2d.drawRoundRect(width / 4, 1, width / 2, height - 2, circleSize, circleSize);
        for (int i = 1; i <= 3; ++i) {
            g2d.setColor(CIRCLE_COLOR);
            g2d.fillOval(width / 2 - circleSize / 2, i * height / 4 - 3, circleSize, circleSize);
            g2d.setColor(METAL_COLOR);
            g2d.drawLine(width / 2 - circleSize / 2 + 1, i * height / 4 - 1, width / 2 + circleSize / 2 - 1, i * height / 4 - 1);
        }
    }
}

