/*
 * Decompiled with CFR 0.152.
 */
package org.igoweb.igoweb.client.swing;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import org.igoweb.igoweb.Config;
import org.igoweb.util.Emitter;
import org.igoweb.util.Event;
import org.igoweb.util.swing.Defs;
import org.igoweb.util.swing.ImageViewer;
import org.igoweb.util.swing.JnlpIo;

public class AdWidget
extends ImageViewer
implements MouseListener {
    private final byte widgetId;
    private int adId = -1;
    private byte[] deferredBuf;
    private JComponent parent;
    private Object addArg;

    public AdWidget(Emitter emitter, byte widgetId, int w, int h, JComponent parent, Object addArg) {
        super(w, h);
        this.addMouseListener(this);
        this.widgetId = widgetId;
        if (emitter != null) {
            emitter.addListener(this);
        }
        this.parent = parent;
        this.addArg = addArg;
    }

    public void setImage(Image image, int adId) {
        this.adId = adId;
        this.setImage(image);
    }

    @Override
    public void handleEvent(Event event) {
        if (event.type == 26) {
            Object[] args = (Object[])event.arg;
            if ((Byte)args[0] == this.widgetId) {
                this.handleAdData((DataInputStream)args[1]);
            }
        } else if (event.type == 16) {
            ((Emitter)event.source).removeListener(this);
        }
    }

    private void handleAdData(DataInputStream in) {
        try {
            this.adId = in.readInt();
            byte[] buf = new byte[in.available()];
            in.readFully(buf);
            Toolkit tk = this.getToolkit();
            if (tk == null) {
                this.deferredBuf = buf;
            } else {
                this.setImage(tk.createImage(buf));
            }
            if (this.parent != null) {
                this.parent.add((Component)this, this.addArg);
                this.parent.revalidate();
                this.parent = null;
                this.addArg = null;
            }
        }
        catch (IOException excep) {
            throw new RuntimeException(excep);
        }
    }

    @Override
    public void addNotify() {
        Toolkit tk;
        super.addNotify();
        if (this.deferredBuf != null && (tk = this.getToolkit()) != null) {
            this.setImage(tk.createImage(this.deferredBuf));
            this.deferredBuf = null;
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (this.adId == -1) {
            return;
        }
        try {
            String url = "http://" + Config.get("webHost") + "/servlet/ad/" + this.adId;
            if (!Defs.loadWebPage(url, false)) {
                JnlpIo.showUrl(new URL(url));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

