/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URLEncoder;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.modeler.Registry;
import org.apache.coyote.Request;
import org.apache.coyote.RequestGroupInfo;
import org.apache.coyote.RequestInfo;
import org.apache.jk.common.AprAcceptor;
import org.apache.jk.common.AprConnection;
import org.apache.jk.common.JniHandler;
import org.apache.jk.common.MsgAjp;
import org.apache.jk.core.JkChannel;
import org.apache.jk.core.Msg;
import org.apache.jk.core.MsgContext;
import org.apache.tomcat.util.threads.ThreadPool;
import org.apache.tomcat.util.threads.ThreadPoolRunnable;

public class ChannelUn
extends JniHandler
implements JkChannel {
    static final int CH_OPEN = 4;
    static final int CH_CLOSE = 5;
    static final int CH_READ = 6;
    static final int CH_WRITE = 7;
    String file;
    ThreadPool tp = ThreadPool.createThreadPool((boolean)true);
    int socketNote = 1;
    int isNote = 2;
    int osNote = 3;
    int localId = 0;
    ObjectName tpOName;
    ObjectName rgOName;
    RequestGroupInfo global = new RequestGroupInfo();
    int count = 0;
    int JMXRequestNote;
    boolean running = true;
    private static Log log = LogFactory.getLog((Class)(class$org$apache$jk$common$ChannelUn == null ? (class$org$apache$jk$common$ChannelUn = ChannelUn.class$("org.apache.jk.common.ChannelUn")) : class$org$apache$jk$common$ChannelUn));
    static /* synthetic */ Class class$org$apache$jk$common$ChannelUn;

    public ThreadPool getThreadPool() {
        return this.tp;
    }

    public void setFile(String f) {
        this.file = f;
    }

    public String getFile() {
        return this.file;
    }

    public void init() throws IOException {
        File socketFile;
        if (this.file == null) {
            log.debug((Object)"No file, disabling unix channel");
            return;
        }
        if (this.wEnv != null && this.wEnv.getLocalId() != 0) {
            this.localId = this.wEnv.getLocalId();
        }
        if (this.localId != 0) {
            this.file = this.file + this.localId;
        }
        if (!(socketFile = new File(this.file)).isAbsolute()) {
            String home = this.wEnv.getJkHome();
            if (home == null) {
                log.debug((Object)"No jkhome");
            } else {
                File homef = new File(home);
                socketFile = new File(homef, this.file);
                log.debug((Object)("Making the file absolute " + socketFile));
            }
        }
        if (!socketFile.exists()) {
            try {
                FileOutputStream fos = new FileOutputStream(socketFile);
                fos.write(1);
                fos.close();
            }
            catch (Throwable t) {
                log.error((Object)("Attempting to create the file failed, disabling channel" + socketFile));
                return;
            }
        }
        if (!socketFile.delete()) {
            log.error((Object)("Can't remove socket file " + socketFile));
            return;
        }
        super.initNative("channel.un:" + this.file);
        if (this.apr == null || !this.apr.isLoaded()) {
            log.debug((Object)"Apr is not available, disabling unix channel ");
            this.apr = null;
            return;
        }
        this.setNativeAttribute("file", this.file);
        this.setNativeAttribute("listen", "10");
        if (this.next == null && this.wEnv != null) {
            if (this.nextName != null) {
                this.setNext(this.wEnv.getHandler(this.nextName));
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("dispatch");
            }
            if (this.next == null) {
                this.next = this.wEnv.getHandler("request");
            }
        }
        super.initJkComponent();
        this.JMXRequestNote = this.wEnv.getNoteId(0, "requestNote");
        if (this.domain != null) {
            try {
                this.tpOName = new ObjectName(this.domain + ":type=ThreadPool,name=" + this.getChannelName());
                Registry.getRegistry(null, null).registerComponent((Object)this.tp, this.tpOName, null);
                this.rgOName = new ObjectName(this.domain + ":type=GlobalRequestProcessor,name=" + this.getChannelName());
                Registry.getRegistry(null, null).registerComponent((Object)this.global, this.rgOName, null);
            }
            catch (Exception e) {
                log.error((Object)"Can't register threadpool");
            }
        }
        this.tp.start();
        AprAcceptor acceptAjp = new AprAcceptor(this);
        this.tp.runIt((ThreadPoolRunnable)acceptAjp);
        log.info((Object)("JK: listening on unix socket: " + this.file));
    }

    public void start() throws IOException {
    }

    public void destroy() throws IOException {
        if (this.apr == null) {
            return;
        }
        try {
            if (this.tp != null) {
                this.tp.shutdown();
            }
            super.destroyJkComponent();
            if (this.tpOName != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.tpOName);
            }
            if (this.rgOName != null) {
                Registry.getRegistry(null, null).unregisterComponent(this.rgOName);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in destroy", (Throwable)e);
        }
    }

    public void registerRequest(Request req, MsgContext ep, int count) {
        if (this.domain != null) {
            try {
                RequestInfo rp = req.getRequestProcessor();
                rp.setGlobalProcessor(this.global);
                ObjectName roname = new ObjectName(this.getDomain() + ":type=RequestProcessor,worker=" + this.getChannelName() + ",name=JkRequest" + count);
                ep.setNote(this.JMXRequestNote, roname);
                Registry.getRegistry(null, null).registerComponent((Object)rp, roname, null);
            }
            catch (Exception ex) {
                log.warn((Object)"Error registering request");
            }
        }
    }

    public int open(MsgContext ep) throws IOException {
        return super.nativeDispatch(ep.getMsg(0), ep, 4, 1);
    }

    public void close(MsgContext ep) throws IOException {
        super.nativeDispatch(ep.getMsg(0), ep, 5, 1);
    }

    public int send(Msg msg, MsgContext ep) throws IOException {
        return super.nativeDispatch(msg, ep, 7, 0);
    }

    public int receive(Msg msg, MsgContext ep) throws IOException {
        int rc = super.nativeDispatch(msg, ep, 6, 1);
        if (rc != 0) {
            log.error((Object)("receive error:   " + rc), new Throwable());
            return -1;
        }
        msg.processHeader();
        if (log.isDebugEnabled()) {
            log.debug((Object)("receive:  total read = " + msg.getLen()));
        }
        return msg.getLen();
    }

    public int flush(Msg msg, MsgContext ep) throws IOException {
        return 0;
    }

    public boolean isSameAddress(MsgContext ep) {
        return false;
    }

    void acceptConnections() {
        if (this.apr == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Accepting ajp connections on " + this.file));
        }
        while (this.running) {
            try {
                MsgContext ep = this.createMsgContext();
                int status = this.open(ep);
                if (status != 0 && status != 2) {
                    log.error((Object)("Error acceptin connection on " + this.file));
                    break;
                }
                AprConnection ajpConn = new AprConnection(this, ep);
                this.tp.runIt((ThreadPoolRunnable)ajpConn);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void processConnection(MsgContext ep) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"New ajp connection ");
        }
        try {
            int res;
            MsgAjp recv = new MsgAjp();
            while (this.running && (res = this.receive(recv, ep)) >= 0) {
                ep.setType(0);
                log.debug((Object)"Process msg ");
                int status = this.next.invoke(recv, ep);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing un channel");
            }
            try {
                Request req = ep.getRequest();
                if (req != null) {
                    ObjectName roname = (ObjectName)ep.getNote(this.JMXRequestNote);
                    if (roname != null) {
                        Registry.getRegistry(null, null).unregisterComponent(roname);
                    }
                    req.getRequestProcessor().setGlobalProcessor(null);
                }
            }
            catch (Exception ee) {
                log.error((Object)"Error, releasing connection", (Throwable)ee);
            }
            this.close(ep);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int invoke(Msg msg, MsgContext ep) throws IOException {
        int type = ep.getType();
        switch (type) {
            case 10: {
                return this.receive(msg, ep);
            }
            case 11: {
                return this.send(msg, ep);
            }
            case 12: {
                return this.flush(msg, ep);
            }
        }
        return 0;
    }

    public String getChannelName() {
        String encodedAddr = "";
        String address = this.file;
        if (address != null) {
            encodedAddr = "" + address;
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr);
        }
        return "jk-" + encodedAddr;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

