/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.storeconfig.StoreAppender;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.coyote.ProtocolHandler;
import org.apache.tomcat.util.IntrospectionUtils;

public class ConnectorStoreAppender
extends StoreAppender {
    protected static HashMap replacements = new HashMap();

    public void printAttributes(PrintWriter writer, int indent, boolean include, Object bean, StoreDescription desc) throws Exception {
        if (include && desc != null && !desc.isStandard()) {
            writer.print(" className=\"");
            writer.print(bean.getClass().getName());
            writer.print("\"");
        }
        List propertyKeys = this.getPropertyKeys((Connector)bean);
        Object bean2 = this.defaultInstance(bean);
        Iterator propertyIterator = propertyKeys.iterator();
        while (propertyIterator.hasNext()) {
            Object value2;
            String key = (String)propertyIterator.next();
            if (replacements.get(key) != null) {
                key = (String)replacements.get(key);
            }
            Object value = IntrospectionUtils.getProperty((Object)bean, (String)key);
            if (desc.isTransientAttribute(key) || value == null) continue;
            if (value instanceof InetAddress) {
                value = ((InetAddress)value).getHostAddress();
            }
            if (!this.isPersistable(value.getClass()) || value.equals(value2 = IntrospectionUtils.getProperty((Object)bean2, (String)key)) || !this.isPrintValue(bean, bean2, key, desc)) continue;
            this.printValue(writer, indent, key, value);
        }
        String protocol = ((Connector)bean).getProtocol();
        if (protocol != null && !"HTTP/1.1".equals(protocol)) {
            super.printValue(writer, indent, "protocol", protocol);
        }
    }

    protected List getPropertyKeys(Connector bean) throws IntrospectionException {
        ArrayList<String> propertyKeys = new ArrayList<String>();
        ProtocolHandler protocolHandler = bean.getProtocolHandler();
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        for (int i = 0; i < descriptors.length; ++i) {
            if (descriptors[i] instanceof IndexedPropertyDescriptor || !this.isPersistable(descriptors[i].getPropertyType()) || descriptors[i].getReadMethod() == null || descriptors[i].getWriteMethod() == null || "protocol".equals(descriptors[i].getName()) || "protocolHandlerClassName".equals(descriptors[i].getName())) continue;
            propertyKeys.add(descriptors[i].getName());
        }
        Iterator propertyIterator = protocolHandler.getAttributeNames();
        while (propertyIterator.hasNext()) {
            Object key = propertyIterator.next();
            if (propertyKeys.contains(key)) continue;
            propertyKeys.add((String)key);
        }
        return propertyKeys;
    }

    protected void storeConnectorAttribtues(PrintWriter aWriter, int indent, Object bean, StoreDescription aDesc) throws Exception {
        if (aDesc.isAttributes()) {
            this.printAttributes(aWriter, indent, false, bean, aDesc);
        }
    }

    public void printOpenTag(PrintWriter aWriter, int indent, Object bean, StoreDescription aDesc) throws Exception {
        aWriter.print("<");
        aWriter.print(aDesc.getTag());
        this.storeConnectorAttribtues(aWriter, indent, bean, aDesc);
        aWriter.println(">");
    }

    public void printTag(PrintWriter aWriter, int indent, Object bean, StoreDescription aDesc) throws Exception {
        aWriter.print("<");
        aWriter.print(aDesc.getTag());
        this.storeConnectorAttribtues(aWriter, indent, bean, aDesc);
        aWriter.println("/>");
    }

    public void printValue(PrintWriter writer, int indent, String name, Object value) {
        String repl = name;
        if (replacements.get(name) != null) {
            repl = (String)replacements.get(name);
        }
        super.printValue(writer, indent, repl, value);
    }

    public boolean isPrintValue(Object bean, Object bean2, String attrName, StoreDescription desc) {
        boolean isPrint = super.isPrintValue(bean, bean2, attrName, desc);
        if (isPrint && "jkHome".equals(attrName)) {
            File jkHomeBase;
            Connector connector = (Connector)bean;
            File catalinaBase = this.getCatalinaBase();
            isPrint = !catalinaBase.equals(jkHomeBase = this.getJkHomeBase((String)connector.getProperty("jkHome"), catalinaBase));
        }
        return isPrint;
    }

    protected File getCatalinaBase() {
        File file = new File(System.getProperty("catalina.base"));
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    protected File getJkHomeBase(String jkHome, File appBase) {
        File jkHomeBase;
        File file = new File(jkHome);
        if (!file.isAbsolute()) {
            file = new File(appBase, jkHome);
        }
        try {
            jkHomeBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            jkHomeBase = file;
        }
        return jkHomeBase;
    }

    static {
        replacements.put("backlog", "acceptCount");
        replacements.put("soLinger", "connectionLinger");
        replacements.put("soTimeout", "connectionTimeout");
        replacements.put("timeout", "connectionUploadTimeout");
        replacements.put("clientauth", "clientAuth");
        replacements.put("keystore", "keystoreFile");
        replacements.put("randomfile", "randomFile");
        replacements.put("rootfile", "rootFile");
        replacements.put("keypass", "keystorePass");
        replacements.put("keytype", "keystoreType");
        replacements.put("protocol", "sslProtocol");
        replacements.put("protocols", "sslProtocols");
    }
}

