/*
 * Decompiled with CFR 0.152.
 */
package jflex;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import jflex.Action;
import jflex.CharClasses;
import jflex.DFA;
import jflex.ErrorMessages;
import jflex.GeneratorException;
import jflex.IntCharSet;
import jflex.IntPair;
import jflex.Interval;
import jflex.LexScan;
import jflex.Macros;
import jflex.Options;
import jflex.Out;
import jflex.RegExp;
import jflex.RegExp1;
import jflex.RegExp2;
import jflex.RegExps;
import jflex.SemCheck;
import jflex.StateSet;
import jflex.StateSetEnumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NFA {
    StateSet[][] table;
    StateSet[] epsilon;
    boolean[] isFinal;
    Action[] action;
    int numStates;
    int numInput;
    int numLexStates;
    int estSize = 256;
    Macros macros;
    CharClasses classes;
    LexScan scanner;
    RegExps regExps;
    private static StateSetEnumerator states = new StateSetEnumerator();
    private static StateSet tempStateSet = new StateSet();
    private boolean[] live;
    private boolean[] visited;

    public NFA(int numInput, int estSize) {
        this.numInput = numInput;
        this.estSize = estSize;
        this.numStates = 0;
        this.epsilon = new StateSet[estSize];
        this.action = new Action[estSize];
        this.isFinal = new boolean[estSize];
        this.table = new StateSet[estSize][numInput];
    }

    public NFA(int numInput, LexScan scanner, RegExps regExps, Macros macros, CharClasses classes) {
        this(numInput, regExps.NFASize(macros) + 2 * scanner.states.number());
        this.scanner = scanner;
        this.regExps = regExps;
        this.macros = macros;
        this.classes = classes;
        this.numLexStates = scanner.states.number();
        int new_num = this.numEntryStates();
        this.ensureCapacity(new_num);
        this.numStates = new_num;
    }

    public int numEntryStates() {
        return 2 * (this.numLexStates + this.regExps.gen_look_count);
    }

    public void addStandaloneRule() {
        int start = this.numStates;
        int end = this.numStates + 1;
        for (int c = 0; c < this.classes.getNumClasses(); ++c) {
            this.addTransition(start, c, end);
        }
        for (int i = 0; i < this.numLexStates * 2; ++i) {
            this.addEpsilonTransition(i, start);
        }
        this.action[end] = new Action("System.out.print(yytext());", Integer.MAX_VALUE);
        this.isFinal[end] = true;
    }

    public void addRegExp(int regExpNum) {
        IntPair nfa = this.insertNFA(this.regExps.getRegExp(regExpNum));
        List<Integer> lexStates = this.regExps.getStates(regExpNum);
        if (lexStates.isEmpty()) {
            lexStates = this.scanner.states.getInclusiveStates();
        }
        for (Integer stateNum : lexStates) {
            if (!this.regExps.isBOL(regExpNum)) {
                this.addEpsilonTransition(2 * stateNum, nfa.start);
            }
            this.addEpsilonTransition(2 * stateNum + 1, nfa.start);
        }
        if (this.regExps.getLookAhead(regExpNum) != null) {
            Action a = this.regExps.getAction(regExpNum);
            if (a.lookAhead() == 3) {
                this.insertLookAheadChoices(nfa.end, a, this.regExps.getLookAhead(regExpNum));
                this.scanner.actions.remove(a);
            } else {
                RegExp r1 = this.regExps.getRegExp(regExpNum);
                RegExp r2 = this.regExps.getLookAhead(regExpNum);
                IntPair look = this.insertNFA(r2);
                this.addEpsilonTransition(nfa.end, look.start);
                this.action[look.end] = a;
                this.isFinal[look.end] = true;
                if (a.lookAhead() == 4) {
                    IntPair forward = this.insertNFA(r1);
                    IntPair backward = this.insertNFA(r2.rev(this.macros));
                    this.isFinal[forward.end] = true;
                    this.action[forward.end] = new Action(5);
                    this.isFinal[backward.end] = true;
                    this.action[backward.end] = new Action(6);
                    int entry = 2 * (this.regExps.getLookEntry(regExpNum) + this.numLexStates);
                    this.addEpsilonTransition(entry, forward.start);
                    this.addEpsilonTransition(entry + 1, backward.start);
                    a.setEntryState(entry);
                }
            }
        } else {
            this.action[nfa.end] = this.regExps.getAction(regExpNum);
            this.isFinal[nfa.end] = true;
        }
    }

    private void insertLookAheadChoices(int baseEnd, Action a, RegExp lookAhead) {
        if (lookAhead.type == 44) {
            RegExp2 r = (RegExp2)lookAhead;
            this.insertLookAheadChoices(baseEnd, a, r.r1);
            this.insertLookAheadChoices(baseEnd, a, r.r2);
        } else if (lookAhead.type == 52) {
            RegExp1 r = (RegExp1)lookAhead;
            this.insertLookAheadChoices(baseEnd, a, this.macros.getDefinition((String)r.content));
        } else {
            int len = SemCheck.length(lookAhead);
            if (len >= 0) {
                Action x;
                IntPair look = this.insertNFA(lookAhead);
                this.addEpsilonTransition(baseEnd, look.start);
                this.action[look.end] = x = a.copyChoice(len);
                this.isFinal[look.end] = true;
                this.scanner.actions.add(x);
            } else {
                throw new Error("When inserting lookahead expression: unkown expression type " + lookAhead.type + " in " + lookAhead);
            }
        }
    }

    private void ensureCapacity(int newNumStates) {
        int oldLength = this.epsilon.length;
        if (newNumStates < oldLength) {
            return;
        }
        int newStatesLength = Math.max(oldLength * 2, newNumStates);
        boolean[] newFinal = new boolean[newStatesLength];
        boolean[] newIsPush = new boolean[newStatesLength];
        Action[] newAction = new Action[newStatesLength];
        StateSet[][] newTable = new StateSet[newStatesLength][this.numInput];
        StateSet[] newEpsilon = new StateSet[newStatesLength];
        System.arraycopy(this.isFinal, 0, newFinal, 0, this.numStates);
        System.arraycopy(this.action, 0, newAction, 0, this.numStates);
        System.arraycopy(this.epsilon, 0, newEpsilon, 0, this.numStates);
        System.arraycopy(this.table, 0, newTable, 0, this.numStates);
        this.isFinal = newFinal;
        this.action = newAction;
        this.epsilon = newEpsilon;
        this.table = newTable;
    }

    public void addTransition(int start, int input, int dest) {
        Out.debug("Adding transition (" + start + ", " + input + ", " + dest + ")");
        int maxS = Math.max(start, dest) + 1;
        this.ensureCapacity(maxS);
        if (maxS > this.numStates) {
            this.numStates = maxS;
        }
        if (this.table[start][input] != null) {
            this.table[start][input].addState(dest);
        } else {
            this.table[start][input] = new StateSet(this.estSize, dest);
        }
    }

    public void addEpsilonTransition(int start, int dest) {
        int max = Math.max(start, dest) + 1;
        this.ensureCapacity(max);
        if (max > this.numStates) {
            this.numStates = max;
        }
        if (this.epsilon[start] != null) {
            this.epsilon[start].addState(dest);
        } else {
            this.epsilon[start] = new StateSet(this.estSize, dest);
        }
    }

    private boolean containsFinal(StateSet set) {
        states.reset(set);
        while (states.hasMoreElements()) {
            if (!this.isFinal[states.nextElement()]) continue;
            return true;
        }
        return false;
    }

    private Action getAction(StateSet set) {
        states.reset(set);
        Action maxAction = null;
        Out.debug("Determining action of : " + set);
        while (states.hasMoreElements()) {
            Action currentAction = this.action[states.nextElement()];
            if (currentAction == null) continue;
            if (maxAction == null) {
                maxAction = currentAction;
                continue;
            }
            maxAction = maxAction.getHigherPriority(currentAction);
        }
        return maxAction;
    }

    private StateSet closure(int startState) {
        StateSet notvisited = tempStateSet;
        StateSet closure = new StateSet(this.numStates, startState);
        notvisited.clear();
        notvisited.addState(startState);
        while (notvisited.containsElements()) {
            int state = notvisited.getAndRemoveElement();
            notvisited.add(closure.complement(this.epsilon[state]));
            closure.add(this.epsilon[state]);
        }
        return closure;
    }

    private StateSet closure(StateSet startStates) {
        StateSet result = new StateSet(this.numStates);
        if (startStates != null) {
            states.reset(startStates);
            while (states.hasMoreElements()) {
                result.add(this.closure(states.nextElement()));
            }
        }
        return result;
    }

    private void epsilonFill() {
        for (int i = 0; i < this.numStates; ++i) {
            this.epsilon[i] = this.closure(i);
        }
    }

    private StateSet DFAEdge(StateSet start, int input) {
        tempStateSet.clear();
        states.reset(start);
        while (states.hasMoreElements()) {
            tempStateSet.add(this.table[states.nextElement()][input]);
        }
        StateSet result = new StateSet(tempStateSet);
        states.reset(tempStateSet);
        while (states.hasMoreElements()) {
            result.add(this.epsilon[states.nextElement()]);
        }
        return result;
    }

    public DFA getDFA() {
        StateSet newState;
        HashMap<StateSet, Integer> dfaStates = new HashMap<StateSet, Integer>(this.numStates);
        ArrayList<StateSet> dfaList = new ArrayList<StateSet>(this.numStates);
        DFA dfa = new DFA(this.numEntryStates(), this.numInput, this.numLexStates);
        int numDFAStates = 0;
        int currentDFAState = 0;
        Out.println("Converting NFA to DFA : ");
        this.epsilonFill();
        for (int i = 0; i < this.numEntryStates(); ++i) {
            newState = this.epsilon[i];
            dfaStates.put(newState, numDFAStates);
            dfaList.add(newState);
            dfa.setEntryState(i, numDFAStates);
            dfa.setFinal(numDFAStates, this.containsFinal(newState));
            dfa.setAction(numDFAStates, this.getAction(newState));
            ++numDFAStates;
        }
        --numDFAStates;
        StateSet tempStateSet = NFA.tempStateSet;
        StateSetEnumerator states = NFA.states;
        newState = new StateSet(this.numStates);
        for (currentDFAState = 0; currentDFAState <= numDFAStates; ++currentDFAState) {
            StateSet currentState = (StateSet)dfaList.get(currentDFAState);
            for (int input = 0; input < this.numInput; ++input) {
                tempStateSet.clear();
                states.reset(currentState);
                while (states.hasMoreElements()) {
                    tempStateSet.add(this.table[states.nextElement()][input]);
                }
                newState.copy(tempStateSet);
                states.reset(tempStateSet);
                while (states.hasMoreElements()) {
                    newState.add(this.epsilon[states.nextElement()]);
                }
                if (!newState.containsElements()) continue;
                Integer nextDFAState = (Integer)dfaStates.get(newState);
                if (nextDFAState != null) {
                    dfa.addTransition(currentDFAState, input, nextDFAState);
                    continue;
                }
                if (Options.progress) {
                    Out.print(".");
                }
                StateSet storeState = new StateSet(newState);
                dfaStates.put(storeState, ++numDFAStates);
                dfaList.add(storeState);
                dfa.addTransition(currentDFAState, input, numDFAStates);
                dfa.setFinal(numDFAStates, this.containsFinal(storeState));
                dfa.setAction(numDFAStates, this.getAction(storeState));
            }
        }
        if (Options.verbose) {
            Out.println("");
        }
        return dfa;
    }

    public void dumpTable() {
        Out.dump(this.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.numStates; ++i) {
            result.append("State");
            if (this.isFinal[i]) {
                result.append("[FINAL");
                String l = this.action[i].lookString();
                if (!l.equals("")) {
                    result.append(", ");
                    result.append(l);
                }
                result.append("]");
            }
            result.append(" " + i + Out.NL);
            for (int input = 0; input < this.numInput; ++input) {
                if (this.table[i][input] == null || !this.table[i][input].containsElements()) continue;
                result.append("  with ").append(input).append(" in ").append(this.table[i][input]).append(Out.NL);
            }
            if (this.epsilon[i] == null || !this.epsilon[i].containsElements()) continue;
            result.append("  with epsilon in ").append(this.epsilon[i]).append(Out.NL);
        }
        return result.toString();
    }

    public void writeDot(File file) {
        try {
            PrintWriter writer = new PrintWriter(new FileWriter(file));
            writer.println(this.dotFormat());
            writer.close();
        }
        catch (IOException e) {
            Out.error(ErrorMessages.FILE_WRITE, file);
            throw new GeneratorException();
        }
    }

    public String dotFormat() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("digraph NFA {").append(Out.NL);
        result.append("rankdir = LR").append(Out.NL);
        for (i = 0; i < this.numStates; ++i) {
            if (!this.isFinal[i]) continue;
            result.append(i);
            result.append(" [shape = doublecircle]");
            result.append(Out.NL);
        }
        for (i = 0; i < this.numStates; ++i) {
            for (int input = 0; input < this.numInput; ++input) {
                if (this.table[i][input] == null) continue;
                StateSetEnumerator states = this.table[i][input].states();
                while (states.hasMoreElements()) {
                    int s = states.nextElement();
                    result.append(i).append(" -> ").append(s);
                    result.append(" [label=\"").append(this.classes.toString(input)).append("\"]").append(Out.NL);
                }
            }
            if (this.epsilon[i] == null) continue;
            StateSetEnumerator states = this.epsilon[i].states();
            while (states.hasMoreElements()) {
                int s = states.nextElement();
                result.append(i).append(" -> ").append(s).append(" [style=dotted]").append(Out.NL);
            }
        }
        result.append("}").append(Out.NL);
        return result.toString();
    }

    private void insertLetterNFA(boolean caseless, int ch, int start, int end) {
        if (caseless) {
            IntCharSet set = new IntCharSet(ch);
            IntCharSet caselessSet = set.getCaseless(this.scanner.getUnicodeProperties());
            for (Interval interval : caselessSet.getIntervals()) {
                for (int elem = interval.start; elem <= interval.end; ++elem) {
                    this.addTransition(start, this.classes.getClassCode(ch), end);
                }
            }
        } else {
            this.addTransition(start, this.classes.getClassCode(ch), end);
        }
    }

    private IntPair insertStringNFA(boolean caseless, String str) {
        int start = this.numStates;
        int i = 0;
        int pos = 0;
        while (pos < str.length()) {
            int ch = str.codePointAt(pos);
            if (caseless) {
                IntCharSet set = new IntCharSet(ch);
                IntCharSet caselessSet = set.getCaseless(this.scanner.getUnicodeProperties());
                for (Interval interval : caselessSet.getIntervals()) {
                    for (int elem = interval.start; elem <= interval.end; ++elem) {
                        this.addTransition(i + start, this.classes.getClassCode(elem), i + start + 1);
                    }
                }
            } else {
                this.addTransition(i + start, this.classes.getClassCode(ch), i + start + 1);
            }
            pos += Character.charCount(ch);
            ++i;
        }
        return new IntPair(start, i + start);
    }

    private void insertClassNFA(List<Interval> intervals, int start, int end) {
        if (intervals == null) {
            return;
        }
        for (int aCl : this.classes.getClassCodes(intervals)) {
            this.addTransition(start, aCl, end);
        }
    }

    private void insertNotClassNFA(List<Interval> intervals, int start, int end) {
        for (int input : this.classes.getNotClassCodes(intervals)) {
            this.addTransition(start, input, end);
        }
    }

    private IntPair complement(IntPair nfa) {
        StateSet currentState;
        int dfaStart = nfa.end + 1;
        this.epsilonFill();
        HashMap<StateSet, Integer> dfaStates = new HashMap<StateSet, Integer>(this.numStates);
        ArrayList<StateSet> dfaList = new ArrayList<StateSet>(this.numStates);
        int numDFAStates = 0;
        int currentDFAState = 0;
        StateSet newState = this.epsilon[nfa.start];
        dfaStates.put(newState, numDFAStates);
        dfaList.add(newState);
        for (currentDFAState = 0; currentDFAState <= numDFAStates; ++currentDFAState) {
            currentState = (StateSet)dfaList.get(currentDFAState);
            for (int input = 0; input < this.numInput; ++input) {
                newState = this.DFAEdge(currentState, input);
                if (!newState.containsElements()) continue;
                Integer nextDFAState = (Integer)dfaStates.get(newState);
                if (nextDFAState != null) {
                    this.addTransition(dfaStart + currentDFAState, input, dfaStart + nextDFAState);
                    continue;
                }
                if (Options.dump) {
                    Out.print("+");
                }
                dfaStates.put(newState, ++numDFAStates);
                dfaList.add(newState);
                this.addTransition(dfaStart + currentDFAState, input, dfaStart + numDFAStates);
            }
        }
        int start = dfaStart + numDFAStates + 1;
        int error = dfaStart + numDFAStates + 2;
        int end = dfaStart + numDFAStates + 3;
        this.addEpsilonTransition(start, dfaStart);
        for (int i = 0; i < this.numInput; ++i) {
            this.addTransition(error, i, error);
        }
        this.addEpsilonTransition(error, end);
        for (int s = 0; s <= numDFAStates; ++s) {
            currentState = (StateSet)dfaList.get(s);
            currentDFAState = dfaStart + s;
            if (!currentState.isElement(nfa.end)) {
                this.addEpsilonTransition(currentDFAState, end);
            }
            for (int i = 0; i < this.numInput; ++i) {
                if (this.table[currentDFAState][i] != null) continue;
                this.addTransition(currentDFAState, i, error);
            }
        }
        if (this.live == null || this.live.length < this.numStates) {
            this.live = new boolean[2 * this.numStates];
            this.visited = new boolean[2 * this.numStates];
        }
        this.removeDead(dfaStart, end);
        return new IntPair(start, end);
    }

    private void removeDead(int start, int end) {
        if (this.visited[start] || this.live[start]) {
            return;
        }
        this.visited[start] = true;
        if (this.closure(start).isElement(end)) {
            this.live[start] = true;
        }
        for (int i = 0; i < this.numInput; ++i) {
            StateSet nextState = this.closure(this.table[start][i]);
            StateSetEnumerator states = nextState.states();
            while (states.hasMoreElements()) {
                int next = states.nextElement();
                if (next == start) continue;
                this.removeDead(next, end);
                if (this.live[next]) {
                    this.live[start] = true;
                    continue;
                }
                this.table[start][i] = null;
            }
        }
        StateSet nextState = this.closure(this.epsilon[start]);
        StateSetEnumerator states = nextState.states();
        while (states.hasMoreElements()) {
            int next = states.nextElement();
            if (next == start) continue;
            this.removeDead(next, end);
            if (!this.live[next]) continue;
            this.live[start] = true;
        }
    }

    private void insertCCLNFA(RegExp regExp, int start, int end) {
        switch (regExp.type) {
            case 44: {
                RegExp2 r = (RegExp2)regExp;
                this.insertCCLNFA(r.r1, start, end);
                this.insertCCLNFA(r.r2, start, end);
                return;
            }
            case 55: {
                this.insertClassNFA((List)((RegExp1)regExp).content, start, end);
                return;
            }
            case 56: {
                this.insertNotClassNFA((List)((RegExp1)regExp).content, start, end);
                return;
            }
            case 50: {
                this.insertLetterNFA(false, (Integer)((RegExp1)regExp).content, start, end);
                return;
            }
            case 59: {
                this.insertLetterNFA(true, (Integer)((RegExp1)regExp).content, start, end);
                return;
            }
            case 52: {
                this.insertCCLNFA(this.macros.getDefinition((String)((RegExp1)regExp).content), start, end);
                return;
            }
        }
        throw new Error("Unknown expression type " + regExp.type + " in NFA construction");
    }

    public IntPair insertNFA(RegExp regExp) {
        if (regExp.isCharClass(this.macros)) {
            int start = this.numStates;
            int end = this.numStates + 1;
            this.ensureCapacity(end + 1);
            if (end + 1 > this.numStates) {
                this.numStates = end + 1;
            }
            this.insertCCLNFA(regExp, start, end);
            return new IntPair(start, end);
        }
        switch (regExp.type) {
            case 44: {
                RegExp2 r = (RegExp2)regExp;
                IntPair nfa1 = this.insertNFA(r.r1);
                IntPair nfa2 = this.insertNFA(r.r2);
                int start = nfa2.end + 1;
                int end = nfa2.end + 2;
                this.addEpsilonTransition(start, nfa1.start);
                this.addEpsilonTransition(start, nfa2.start);
                this.addEpsilonTransition(nfa1.end, end);
                this.addEpsilonTransition(nfa2.end, end);
                return new IntPair(start, end);
            }
            case 57: {
                RegExp2 r = (RegExp2)regExp;
                IntPair nfa1 = this.insertNFA(r.r1);
                IntPair nfa2 = this.insertNFA(r.r2);
                this.addEpsilonTransition(nfa1.end, nfa2.start);
                return new IntPair(nfa1.start, nfa2.end);
            }
            case 42: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int start = nfa1.end + 1;
                int end = nfa1.end + 2;
                this.addEpsilonTransition(nfa1.end, end);
                this.addEpsilonTransition(start, nfa1.start);
                this.addEpsilonTransition(start, end);
                this.addEpsilonTransition(nfa1.end, nfa1.start);
                return new IntPair(start, end);
            }
            case 43: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                int start = nfa1.end + 1;
                int end = nfa1.end + 2;
                this.addEpsilonTransition(nfa1.end, end);
                this.addEpsilonTransition(start, nfa1.start);
                this.addEpsilonTransition(nfa1.end, nfa1.start);
                return new IntPair(start, end);
            }
            case 45: {
                IntPair nfa1 = this.insertNFA((RegExp)((RegExp1)regExp).content);
                this.addEpsilonTransition(nfa1.start, nfa1.end);
                return new IntPair(nfa1.start, nfa1.end);
            }
            case 48: {
                return this.complement(this.insertNFA((RegExp)((RegExp1)regExp).content));
            }
            case 49: {
                return this.insertNFA(regExp.resolveTilde(this.macros));
            }
            case 51: {
                return this.insertStringNFA(false, (String)((RegExp1)regExp).content);
            }
            case 58: {
                return this.insertStringNFA(true, (String)((RegExp1)regExp).content);
            }
            case 52: {
                return this.insertNFA(this.macros.getDefinition((String)((RegExp1)regExp).content));
            }
        }
        throw new Error("Unknown expression type " + regExp.type + " in NFA construction");
    }
}

