/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public class Accumulator<E>
implements Iterable<E> {
    private volatile int nextIndex;
    private volatile int presentCount;
    private final Object[] values;
    private static final AtomicIntegerFieldUpdater<Accumulator> nextIndexUpdater = AtomicIntegerFieldUpdater.newUpdater(Accumulator.class, "nextIndex");
    private static final AtomicIntegerFieldUpdater<Accumulator> presentCountUpdater = AtomicIntegerFieldUpdater.newUpdater(Accumulator.class, "presentCount");

    public Accumulator(int size) {
        this.values = new Object[size];
    }

    public void add(E item) {
        int insertPos;
        do {
            if ((insertPos = this.nextIndex) < this.values.length) continue;
            throw new IllegalStateException();
        } while (!nextIndexUpdater.compareAndSet(this, insertPos, insertPos + 1));
        this.values[insertPos] = item;
        boolean volatileWrite = false;
        while (true) {
            int cur;
            if ((cur = this.presentCount) != insertPos && (cur == this.values.length || this.values[cur] == null)) {
                if (!volatileWrite && cur < insertPos && !presentCountUpdater.compareAndSet(this, cur, cur)) {
                    volatileWrite = true;
                    continue;
                }
                return;
            }
            presentCountUpdater.compareAndSet(this, cur, cur + 1);
            volatileWrite = true;
        }
    }

    public boolean isEmpty() {
        return this.presentCount == 0;
    }

    public int size() {
        return this.presentCount;
    }

    public int capacity() {
        return this.values.length;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int p = 0;

            @Override
            public boolean hasNext() {
                return this.p < Accumulator.this.presentCount;
            }

            @Override
            public E next() {
                return Accumulator.this.values[this.p++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public E get(int i) {
        if (i >= this.presentCount) {
            throw new IndexOutOfBoundsException();
        }
        return (E)this.values[i];
    }
}

