/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.repair.messages;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.repair.RepairJobDesc;
import org.apache.cassandra.repair.messages.RepairMessage;

public class SyncRequest
extends RepairMessage {
    public static RepairMessage.MessageSerializer serializer = new SyncRequestSerializer();
    public final InetAddress initiator;
    public final InetAddress src;
    public final InetAddress dst;
    public final Collection<Range<Token>> ranges;

    public SyncRequest(RepairJobDesc desc, InetAddress initiator, InetAddress src, InetAddress dst, Collection<Range<Token>> ranges) {
        super(RepairMessage.Type.SYNC_REQUEST, desc);
        this.initiator = initiator;
        this.src = src;
        this.dst = dst;
        this.ranges = ranges;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SyncRequest)) {
            return false;
        }
        SyncRequest req = (SyncRequest)o;
        return this.messageType == req.messageType && this.desc.equals(req.desc) && this.initiator.equals(req.initiator) && this.src.equals(req.src) && this.dst.equals(req.dst) && this.ranges.equals(req.ranges);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageType, this.desc, this.initiator, this.src, this.dst, this.ranges});
    }

    public String toString() {
        return "SyncRequest{initiator=" + this.initiator + ", src=" + this.src + ", dst=" + this.dst + ", ranges=" + this.ranges + "} " + super.toString();
    }

    public static class SyncRequestSerializer
    implements RepairMessage.MessageSerializer<SyncRequest> {
        @Override
        public void serialize(SyncRequest message, DataOutputPlus out, int version) throws IOException {
            RepairJobDesc.serializer.serialize(message.desc, out, version);
            CompactEndpointSerializationHelper.serialize(message.initiator, out);
            CompactEndpointSerializationHelper.serialize(message.src, out);
            CompactEndpointSerializationHelper.serialize(message.dst, out);
            out.writeInt(message.ranges.size());
            for (Range<Token> range : message.ranges) {
                MessagingService.validatePartitioner(range);
                AbstractBounds.tokenSerializer.serialize(range, out, version);
            }
        }

        @Override
        public SyncRequest deserialize(DataInputPlus in, int version) throws IOException {
            RepairJobDesc desc = RepairJobDesc.serializer.deserialize(in, version);
            InetAddress owner = CompactEndpointSerializationHelper.deserialize(in);
            InetAddress src = CompactEndpointSerializationHelper.deserialize(in);
            InetAddress dst = CompactEndpointSerializationHelper.deserialize(in);
            int rangesCount = in.readInt();
            ArrayList<Range<Token>> ranges = new ArrayList<Range<Token>>(rangesCount);
            for (int i = 0; i < rangesCount; ++i) {
                ranges.add((Range)AbstractBounds.tokenSerializer.deserialize(in, MessagingService.globalPartitioner(), version));
            }
            return new SyncRequest(desc, owner, src, dst, ranges);
        }

        @Override
        public long serializedSize(SyncRequest message, int version) {
            long size = RepairJobDesc.serializer.serializedSize(message.desc, version);
            size += (long)(3 * CompactEndpointSerializationHelper.serializedSize(message.initiator));
            size += (long)TypeSizes.sizeof(message.ranges.size());
            for (Range<Token> range : message.ranges) {
                size += AbstractBounds.tokenSerializer.serializedSize(range, version);
            }
            return size;
        }
    }
}

