/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.JavaEnvUtils;

public class Touch
extends Task {
    private File file;
    private long millis = -1L;
    private String dateTime;
    private Vector filesets = new Vector();
    private FileUtils fileUtils = FileUtils.newFileUtils();

    public void setFile(File file) {
        this.file = file;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public void setDatetime(String dateTime) {
        this.dateTime = dateTime;
    }

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        long savedMillis = this.millis;
        if (this.file == null && this.filesets.size() == 0) {
            throw new BuildException("Specify at least one source - a file or a fileset.");
        }
        if (this.file != null && this.file.exists() && this.file.isDirectory()) {
            throw new BuildException("Use a fileset to touch directories.");
        }
        try {
            if (this.dateTime != null) {
                DateFormat df = DateFormat.getDateTimeInstance(3, 3, Locale.US);
                try {
                    this.setMillis(df.parse(this.dateTime).getTime());
                    if (this.millis < 0L) {
                        throw new BuildException("Date of " + this.dateTime + " results in negative " + "milliseconds value " + "relative to epoch " + "(January 1, 1970, " + "00:00:00 GMT).");
                    }
                }
                catch (ParseException pe) {
                    throw new BuildException(pe.getMessage(), pe, this.location);
                }
            }
            this.touch();
        }
        finally {
            this.millis = savedMillis;
        }
    }

    protected void touch() throws BuildException {
        if (this.file != null && !this.file.exists()) {
            this.log("Creating " + this.file, 2);
            try {
                this.fileUtils.createNewFile(this.file);
            }
            catch (IOException ioe) {
                throw new BuildException("Could not create " + this.file, ioe, this.location);
            }
        }
        if (this.millis >= 0L && JavaEnvUtils.isJavaVersion("1.1")) {
            this.log("modification time of files cannot be set in JDK 1.1", 1);
            return;
        }
        boolean resetMillis = false;
        if (this.millis < 0L) {
            resetMillis = true;
            this.millis = System.currentTimeMillis();
        }
        if (this.file != null) {
            this.touch(this.file);
        }
        for (int i = 0; i < this.filesets.size(); ++i) {
            int j;
            FileSet fs = (FileSet)this.filesets.elementAt(i);
            DirectoryScanner ds = fs.getDirectoryScanner(this.project);
            File fromDir = fs.getDir(this.project);
            String[] srcFiles = ds.getIncludedFiles();
            String[] srcDirs = ds.getIncludedDirectories();
            for (j = 0; j < srcFiles.length; ++j) {
                this.touch(new File(fromDir, srcFiles[j]));
            }
            for (j = 0; j < srcDirs.length; ++j) {
                this.touch(new File(fromDir, srcDirs[j]));
            }
        }
        if (resetMillis) {
            this.millis = -1L;
        }
    }

    protected void touch(File file) throws BuildException {
        if (!file.canWrite()) {
            throw new BuildException("Can not change modification date of read-only file " + file);
        }
        if (JavaEnvUtils.isJavaVersion("1.1")) {
            return;
        }
        this.fileUtils.setFileLastModified(file, this.millis);
    }
}

