/* -*- mode: c++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

/*
 Copyright (C) 2015 Peter Caspers

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it
 under the terms of the QuantLib license.  You should have received a
 copy of the license along with this program; if not, please email
 <quantlib-dev@lists.sf.net>. The license is also available online at
 <http://quantlib.org/license.shtml>.

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

/*! \file gaussian1dsmilesection.hpp
    \brief smile section generated by a gaussian 1d model
*/

#ifndef quantlib_gaussian1dsmilesection_hpp
#define quantlib_gaussian1dsmilesection_hpp

#include <ql/termstructures/volatility/smilesection.hpp>
#include <ql/indexes/swapindex.hpp>
#include <ql/indexes/iborindex.hpp>
#include <ql/models/shortrate/onefactormodels/gaussian1dmodel.hpp>
#include <ql/pricingengines/swaption/gaussian1dswaptionengine.hpp>
#include <ql/pricingengines/capfloor/gaussian1dcapfloorengine.hpp>

namespace QuantLib {

/*! smile section based on a gaussian 1d model instance
    if curves are attached to the swap or ibor index, these are used to adjust
    the model's yield term structure, if not the model's yield term structure
    is used directly */

class Gaussian1dSmileSection : public SmileSection {
  public:
    Gaussian1dSmileSection(
        const Date &fixingDate, const boost::shared_ptr<SwapIndex> &swapIndex,
        const boost::shared_ptr<Gaussian1dModel> &model, const DayCounter &dc,
        const boost::shared_ptr<Gaussian1dSwaptionEngine> swaptionEngine =
            boost::shared_ptr<Gaussian1dSwaptionEngine>());
    Gaussian1dSmileSection(
        const Date &fixingDate, const boost::shared_ptr<IborIndex> &swapIndex,
        const boost::shared_ptr<Gaussian1dModel> &model, const DayCounter &dc,
        const boost::shared_ptr<Gaussian1dCapFloorEngine> capEngine =
            boost::shared_ptr<Gaussian1dCapFloorEngine>());

    // the minimum strike is zero only because we are
    // returning a lognormal section
    Real minStrike() const { return 0.0; }
    Real maxStrike() const { return QL_MAX_REAL; }

    Real atmLevel() const;
    Real optionPrice(Rate strike, Option::Type = Option::Call,
                     Real discount = 1.0) const;

  protected:
    Real volatilityImpl(Rate strike) const;

  private:
    Real atm_, annuity_;
    Date fixingDate_;
    boost::shared_ptr<SwapIndex> swapIndex_;
    boost::shared_ptr<IborIndex> iborIndex_;
    boost::shared_ptr<Gaussian1dModel> model_;
    boost::shared_ptr<PricingEngine> engine_;
};
}

#endif
