/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.generator;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class Generator {
    public static final int MAX_CONTENT_LENGTH = 65535;
    protected final ByteBufferPool byteBufferPool;

    public Generator(ByteBufferPool byteBufferPool) {
        this.byteBufferPool = byteBufferPool;
    }

    protected Result generateContent(int id, ByteBuffer content, boolean recycle, boolean lastContent, Callback callback, FCGI.FrameType frameType) {
        id &= 0xFFFF;
        int contentLength = content == null ? 0 : content.remaining();
        Result result = new Result(this.byteBufferPool, callback);
        while (contentLength > 0 || lastContent) {
            ByteBuffer buffer = this.byteBufferPool.acquire(8, false);
            BufferUtil.clearToFill((ByteBuffer)buffer);
            result = result.append(buffer, true);
            buffer.put((byte)1);
            buffer.put((byte)frameType.code);
            buffer.putShort((short)id);
            int length = Math.min(65535, contentLength);
            buffer.putShort((short)length);
            buffer.putShort((short)0);
            buffer.flip();
            if (contentLength == 0) break;
            int limit = content.limit();
            content.limit(content.position() + length);
            ByteBuffer slice = content.slice();
            result = result.append(slice, false);
            content.position(content.limit());
            content.limit(limit);
            if (!recycle || (contentLength -= length) != 0) continue;
            result = result.append(content, true);
        }
        return result;
    }

    public static class Result
    implements Callback {
        private final List<Callback> callbacks = new ArrayList<Callback>(2);
        private final List<ByteBuffer> buffers = new ArrayList<ByteBuffer>(8);
        private final List<Boolean> recycles = new ArrayList<Boolean>(8);
        private final ByteBufferPool byteBufferPool;

        public Result(ByteBufferPool byteBufferPool, Callback callback) {
            this.byteBufferPool = byteBufferPool;
            this.callbacks.add(callback);
        }

        public Result append(ByteBuffer buffer, boolean recycle) {
            if (buffer != null) {
                this.buffers.add(buffer);
                this.recycles.add(recycle);
            }
            return this;
        }

        public Result join(Result that) {
            this.callbacks.addAll(that.callbacks);
            this.buffers.addAll(that.buffers);
            this.recycles.addAll(that.recycles);
            return this;
        }

        public ByteBuffer[] getByteBuffers() {
            return this.buffers.toArray(new ByteBuffer[this.buffers.size()]);
        }

        public void succeeded() {
            this.recycle();
            for (int i = 0; i < this.callbacks.size(); ++i) {
                Callback callback = this.callbacks.get(i);
                if (callback == null) continue;
                callback.succeeded();
            }
        }

        public void failed(Throwable x) {
            this.recycle();
            for (int i = 0; i < this.callbacks.size(); ++i) {
                Callback callback = this.callbacks.get(i);
                if (callback == null) continue;
                callback.failed(x);
            }
        }

        protected void recycle() {
            for (int i = 0; i < this.buffers.size(); ++i) {
                ByteBuffer buffer = this.buffers.get(i);
                if (!this.recycles.get(i).booleanValue()) continue;
                this.byteBufferPool.release(buffer);
            }
        }
    }
}

