/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.variantcontext;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class VariantContextComparator
implements Comparator<VariantContext>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, Integer> contigIndexLookup;

    public static List<String> getSequenceNameList(SAMSequenceDictionary dictionary) {
        ArrayList<String> list = new ArrayList<String>();
        for (SAMSequenceRecord record : dictionary.getSequences()) {
            list.add(record.getSequenceName());
        }
        return list;
    }

    public VariantContextComparator(List<String> contigs) {
        if (contigs.isEmpty()) {
            throw new IllegalArgumentException("One or more contigs must be in the contig list.");
        }
        HashMap<String, Integer> protoContigIndexLookup = new HashMap<String, Integer>();
        int index = 0;
        for (String contig : contigs) {
            protoContigIndexLookup.put(contig, index++);
        }
        if (protoContigIndexLookup.size() != contigs.size()) {
            throw new IllegalArgumentException("There are duplicate contigs/chromosomes in the input contig list.");
        }
        this.contigIndexLookup = Collections.unmodifiableMap(protoContigIndexLookup);
    }

    public VariantContextComparator(Collection<VCFContigHeaderLine> headerLines) {
        if (headerLines.isEmpty()) {
            throw new IllegalArgumentException("One or more header lines must be in the header line collection.");
        }
        HashMap<String, Integer> protoContigIndexLookup = new HashMap<String, Integer>();
        for (VCFContigHeaderLine headerLine : headerLines) {
            protoContigIndexLookup.put(headerLine.getID(), headerLine.getContigIndex());
        }
        if (protoContigIndexLookup.size() != headerLines.size()) {
            throw new IllegalArgumentException("There are duplicate contigs/chromosomes in the input header line collection.");
        }
        HashSet protoIndexValues = new HashSet(protoContigIndexLookup.values());
        if (protoIndexValues.size() != headerLines.size()) {
            throw new IllegalArgumentException("One or more contigs share the same index number.");
        }
        this.contigIndexLookup = Collections.unmodifiableMap(protoContigIndexLookup);
    }

    public VariantContextComparator(SAMSequenceDictionary dictionary) {
        this(VariantContextComparator.getSequenceNameList(dictionary));
    }

    @Override
    public int compare(VariantContext firstVariantContext, VariantContext secondVariantContext) {
        int contigCompare = this.contigIndexLookup.get(firstVariantContext.getContig()) - this.contigIndexLookup.get(secondVariantContext.getContig());
        return contigCompare != 0 ? contigCompare : firstVariantContext.getStart() - secondVariantContext.getStart();
    }

    public boolean isCompatible(Collection<VCFContigHeaderLine> headerLines) {
        for (VCFContigHeaderLine headerLine : headerLines) {
            Integer existingIndex = this.contigIndexLookup.get(headerLine.getID());
            if (existingIndex != null && headerLine.getContigIndex().intValue() == existingIndex.intValue()) continue;
            return false;
        }
        return true;
    }
}

