/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import java.io.Serializable;

public final class Murmur3
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int seed;

    public Murmur3(int seed) {
        this.seed = seed;
    }

    public int hashUnencodedChars(CharSequence input) {
        int h1 = this.seed;
        int length = input.length();
        for (int i = 1; i < length; i += 2) {
            int k1 = input.charAt(i - 1) | input.charAt(i) << 16;
            k1 = Murmur3.mixK1(k1);
            h1 = Murmur3.mixH1(h1, k1);
        }
        if ((length & 1) == 1) {
            int k1 = input.charAt(length - 1);
            k1 = Murmur3.mixK1(k1);
            h1 ^= k1;
        }
        return Murmur3.fmix(h1, 2 * length);
    }

    private int hashInt(int input) {
        if (input == 0) {
            return 0;
        }
        int k1 = Murmur3.mixK1(input);
        int h1 = Murmur3.mixH1(this.seed, k1);
        return Murmur3.fmix(h1, 4);
    }

    private int hashLong(long input) {
        if (input == 0L) {
            return 0;
        }
        int low = (int)input;
        int high = (int)(input >>> 32);
        int k1 = Murmur3.mixK1(low);
        int h1 = Murmur3.mixH1(this.seed, k1);
        k1 = Murmur3.mixK1(high);
        h1 = Murmur3.mixH1(h1, k1);
        return Murmur3.fmix(h1, 8);
    }

    private static int mixK1(int k1) {
        int c1 = -862048943;
        int c2 = 461845907;
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        h1 ^= length;
        h1 ^= h1 >>> 16;
        h1 *= -2048144789;
        h1 ^= h1 >>> 13;
        h1 *= -1028477387;
        h1 ^= h1 >>> 16;
        return h1;
    }
}

