/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.seekablestream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;

public class ByteArraySeekableStream
extends SeekableStream {
    private byte[] bytes;
    private long position = 0L;

    public ByteArraySeekableStream(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public long length() {
        return this.bytes.length;
    }

    @Override
    public long position() throws IOException {
        return this.position;
    }

    @Override
    public void seek(long position) throws IOException {
        if (position < 0L) {
            throw new IllegalArgumentException("Cannot seek to a negative position, position=" + position + ".");
        }
        this.position = position;
    }

    @Override
    public int read() throws IOException {
        if (this.position < (long)this.bytes.length) {
            return 0xFF & this.bytes[(int)this.position++];
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len + off > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position >= (long)this.bytes.length) {
            return -1;
        }
        if (this.position + (long)len > (long)this.bytes.length) {
            len = (int)((long)this.bytes.length - this.position);
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.bytes, (int)this.position, b, off, len);
        this.position += (long)len;
        return len;
    }

    @Override
    public void close() throws IOException {
        this.bytes = null;
        this.position = -1L;
    }

    @Override
    public boolean eof() throws IOException {
        return this.position >= (long)this.bytes.length;
    }

    @Override
    public String getSource() {
        return null;
    }
}

