/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.example;

import htsjdk.samtools.DefaultSAMRecordFactory;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ExampleSamUsage {
    public static SeekableStream myIndexSeekableStream() {
        throw new UnsupportedOperationException();
    }

    public void openSamExamples() throws MalformedURLException {
        SamReader reader = SamReaderFactory.makeDefault().open(new File("/my.bam"));
        SamReader readerFromConfiguredFactory = SamReaderFactory.make().enable(SamReaderFactory.Option.DONT_MEMORY_MAP_INDEX).validationStringency(ValidationStringency.SILENT).samRecordFactory(DefaultSAMRecordFactory.getInstance()).open(new File("/my.bam"));
        SamReader complicatedReader = SamReaderFactory.makeDefault().open(SamInputResource.of(new URL("http://broadinstitute.org/my.bam")).index(ExampleSamUsage.myIndexSeekableStream()));
        SamReaderFactory factory = SamReaderFactory.makeDefault().enable(SamReaderFactory.Option.VALIDATE_CRC_CHECKSUMS).validationStringency(ValidationStringency.LENIENT);
        SamInputResource resource = SamInputResource.of(new File("/my.bam")).index(new URL("http://broadinstitute.org/my.bam.bai"));
        SamReader myReader = factory.open(resource);
        for (SAMRecord samRecord : myReader) {
            System.err.print(samRecord);
        }
    }

    public void convertReadNamesToUpperCase(File inputSamOrBamFile, File outputSamOrBamFile) throws IOException {
        SamReader reader = SamReaderFactory.makeDefault().open(inputSamOrBamFile);
        SAMFileWriter outputSam = new SAMFileWriterFactory().makeSAMOrBAMWriter(reader.getFileHeader(), true, outputSamOrBamFile);
        for (SAMRecord samRecord : reader) {
            samRecord.setReadName(samRecord.getReadName().toUpperCase());
            outputSam.addAlignment(samRecord);
        }
        outputSam.close();
        reader.close();
    }
}

