/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMIndexContent;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.seekablestream.SeekableStream;

class CachingBamFileIndexOptimizedForMerging
extends CachingBAMFileIndex {
    CachingBamFileIndexOptimizedForMerging(SeekableStream stream, SAMSequenceDictionary dictionary) {
        super(stream, dictionary);
    }

    @Override
    protected BAMIndexContent query(int referenceSequence, int startPos, int endPos) {
        this.seek(4L);
        int sequenceCount = this.readInteger();
        if (referenceSequence >= sequenceCount) {
            return null;
        }
        this.skipToSequence(referenceSequence);
        int binCount = this.readInteger();
        if (binCount == 0) {
            return null;
        }
        return super.query(referenceSequence, startPos, endPos);
    }
}

