/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.broad.igv.charts.ScatterPlotUtils;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;

public class RegionMenu
extends JPopupMenu {
    RegionOfInterest roi;
    ReferenceFrame frame;

    public RegionMenu(RegionOfInterest roi, ReferenceFrame frame) {
        this(roi, frame, null);
    }

    public RegionMenu(final RegionOfInterest roi, final ReferenceFrame frame, String title) {
        JMenuItem item;
        Set<TrackType> loadedTypes;
        this.roi = roi;
        this.frame = frame;
        if (title != null) {
            JLabel heading = new JLabel("<html>&nbsp;<b>" + title);
            this.add(heading);
            this.addSeparator();
        }
        if ((loadedTypes = IGV.getInstance().getLoadedTypes()).contains((Object)TrackType.COPY_NUMBER) || loadedTypes.contains((Object)TrackType.ALLELE_SPECIFIC_COPY_NUMBER) || loadedTypes.contains((Object)TrackType.CNV)) {
            item = new JMenuItem("Sort by amplification");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IGV.getInstance().sortByRegionScore(roi, RegionScoreType.AMPLIFICATION, frame);
                }
            });
            this.add(item);
            item = new JMenuItem("Sort by deletion");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IGV.getInstance().sortByRegionScore(roi, RegionScoreType.DELETION, frame);
                    IGV.getInstance().getContentPane().repaint();
                }
            });
            this.add(item);
            item = new JMenuItem("Sort by breakpoint amplitudes");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IGV.getInstance().sortByRegionScore(roi, RegionScoreType.FLUX, frame);
                    IGV.getInstance().getContentPane().repaint();
                }
            });
            this.add(item);
        }
        if (loadedTypes.contains((Object)TrackType.GENE_EXPRESSION)) {
            item = new JMenuItem("Sort by expression");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IGV.getInstance().sortByRegionScore(roi, RegionScoreType.EXPRESSION, frame);
                    IGV.getInstance().getContentPane().repaint();
                }
            });
            this.add(item);
        }
        if (loadedTypes.contains((Object)TrackType.MUTATION)) {
            item = new JMenuItem("Sort by mutation count");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IGV.getInstance().sortByRegionScore(roi, RegionScoreType.MUTATION_COUNT, frame);
                    IGV.getInstance().getContentPane().repaint();
                }
            });
            this.add(item);
        }
        item = new JMenuItem("Sort by value");
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGV.getInstance().sortByRegionScore(roi, RegionScoreType.SCORE, frame);
                IGV.getInstance().getContentPane().repaint();
            }
        });
        this.add(item);
        if (ScatterPlotUtils.hasPlottableTracks()) {
            this.addSeparator();
            item = new JMenuItem("Scatter Plot ...");
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String chr = roi.getChr();
                    int start = roi.getStart();
                    int end = roi.getEnd();
                    int zoom = frame.getZoom();
                    ScatterPlotUtils.openPlot(chr, start, end, zoom);
                }
            });
            this.add(item);
        }
    }
}

