/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.broad.igv.feature.LocusScore;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.track.DataTrack;
import org.broad.igv.track.LoadedDataInterval;
import org.broad.igv.track.Range;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.ScalableTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MergedTracks
extends DataTrack
implements ScalableTrack {
    private static double DEFAULT_ALPHA = 0.5;
    private Collection<DataTrack> memberTracks;
    private double alpha;

    public MergedTracks(String id, String name, Collection<DataTrack> inputTracks) {
        super(null, id, name);
        this.initTrackList(inputTracks);
        this.autoScale = this.getAutoScale();
        this.setTrackAlphas(DEFAULT_ALPHA);
    }

    public MergedTracks() {
        this.alpha = DEFAULT_ALPHA;
    }

    public void setMemberTracks(Collection<DataTrack> inputTracks) {
        this.initTrackList(inputTracks);
    }

    private void initTrackList(Collection<DataTrack> inputTracks) {
        String group;
        this.memberTracks = new ArrayList<DataTrack>(inputTracks.size());
        for (DataTrack inputTrack : inputTracks) {
            if (inputTrack instanceof MergedTracks) {
                this.memberTracks.addAll(((MergedTracks)inputTrack).getMemberTracks());
                continue;
            }
            this.memberTracks.add(inputTrack);
        }
        if (this.memberTracks != null && this.memberTracks.size() > 1 && (group = this.memberTracks.iterator().next().getAttributeValue("AUTOSCALE GROUP")) != null) {
            for (Track track : this.memberTracks) {
                if (group.equals(track.getAttributeValue("AUTOSCALE GROUP"))) continue;
                this.removeAttribute("AUTOSCALE GROUP");
                group = null;
                break;
            }
            if (group != null) {
                this.setAttributeValue("AUTOSCALE GROUP", group);
            }
        }
        this.setTrackAlphas(this.alpha);
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return this.memberTracks.stream().allMatch(t -> t.isReadyToPaint(frame));
    }

    @Override
    public synchronized void load(ReferenceFrame referenceFrame) {
        for (DataTrack t : this.memberTracks) {
            if (t.isReadyToPaint(referenceFrame)) continue;
            t.load(referenceFrame);
        }
    }

    @Override
    public Collection<ResourceLocator> getResourceLocators() {
        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>(this.memberTracks.size());
        for (DataTrack memTrack : this.memberTracks) {
            locators.addAll(memTrack.getResourceLocators());
        }
        return locators;
    }

    public Collection<DataTrack> getMemberTracks() {
        return this.memberTracks;
    }

    public void setTrackAlphas(double alpha) {
        this.alpha = alpha;
        if (this.memberTracks != null) {
            int iAlpha = (int)Math.floor(alpha * 255.0);
            for (Track track : this.memberTracks) {
                track.setColor(ColorUtilities.modifyAlpha(track.getColor(), iAlpha));
                track.setAltColor(ColorUtilities.modifyAlpha(track.getAltColor(), iAlpha));
            }
        }
    }

    public double getTrackAlpha() {
        return this.alpha;
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        for (Track track : this.memberTracks) {
            track.render(context, rect);
        }
    }

    @Override
    public int getHeight() {
        int height = super.getHeight();
        for (Track track : this.memberTracks) {
            height = Math.max(height, track.getHeight());
        }
        return height;
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        for (Track track : this.memberTracks) {
            track.setHeight(height);
        }
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        super.setDataRange(axisDefinition);
        for (Track track : this.memberTracks) {
            track.setDataRange(axisDefinition);
        }
    }

    @Override
    public DataRange getDataRange() {
        if (this.dataRange == null) {
            this.dataRange = DataRange.getFromTracks(this.memberTracks);
        }
        return this.dataRange;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        StringBuilder builder = new StringBuilder(this.memberTracks.size() + 2);
        builder.append(this.getName());
        builder.append("<br/>--------------<br/>");
        for (Track track : this.memberTracks) {
            String curS = track.getValueStringAt(chr, position, mouseX, mouseY, frame);
            if (curS == null) continue;
            builder.append(curS);
            builder.append("<br/>--------------<br/>");
        }
        return builder.toString();
    }

    @Override
    public LoadedDataInterval<List<LocusScore>> getSummaryScores(String chr, int startLocation, int endLocation, int zoom) {
        return null;
    }

    @Override
    public void setRendererClass(Class rc) {
        super.setRendererClass(rc);
        for (Track track : this.memberTracks) {
            track.setRendererClass(rc);
        }
    }

    @Override
    public boolean getAutoScale() {
        boolean autoScale = true;
        for (Track track : this.memberTracks) {
            autoScale &= track.getAutoScale();
        }
        return autoScale;
    }

    @Override
    public void setAutoScale(boolean autoScale) {
        for (Track track : this.memberTracks) {
            track.setAutoScale(autoScale);
        }
    }

    @Override
    public void setAttributeValue(String name, String value) {
        super.setAttributeValue(name, value);
        if (name.equals("AUTOSCALE GROUP") && this.memberTracks != null) {
            for (Track track : this.memberTracks) {
                track.setAttributeValue(name, value);
            }
        }
    }

    @Override
    public void removeAttribute(String name) {
        super.removeAttribute(name);
        if (name.equals("AUTOSCALE GROUP")) {
            for (Track track : this.memberTracks) {
                track.removeAttribute(name);
            }
        }
    }

    @Override
    public String getAttributeValue(String attributeName) {
        if (super.getAttributeValue(attributeName) != null) {
            return super.getAttributeValue(attributeName);
        }
        if (this.memberTracks.size() > 0) {
            Object value = null;
            for (Track track : this.memberTracks) {
                String nm = track.getAttributeValue(attributeName);
                if (nm == null) continue;
                if (value == null) {
                    value = nm;
                    continue;
                }
                if (((String)value).equals(nm)) continue;
                value = (String)value + " / " + nm;
            }
            return value;
        }
        return null;
    }

    @Override
    public ContinuousColorScale getColorScale() {
        return super.getColorScale();
    }

    @Override
    public void setColorScale(ContinuousColorScale colorScale) {
        super.setColorScale(colorScale);
        for (Track track : this.memberTracks) {
            track.setColorScale(colorScale);
        }
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
        super.setWindowFunction(type);
        for (Track track : this.memberTracks) {
            track.setWindowFunction(type);
        }
    }

    @Override
    public void setShowDataRange(boolean showDataRange) {
        super.setShowDataRange(showDataRange);
        for (DataTrack track : this.memberTracks) {
            track.setShowDataRange(showDataRange);
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        List<Track> selfAsList = Arrays.asList(this);
        menu.add(TrackMenuUtils.getTrackRenameItem(selfAsList));
        JMenu setPosColorMenu = new JMenu("Change Track Color (Positive Values)");
        JMenu setNegColorMenu = new JMenu("Change Track Color (Negative Values)");
        for (DataTrack track : this.memberTracks) {
            ColorIcon posColorIcon = new ColorIcon(track.getColor());
            JMenuItem posItem = new JMenuItem(track.getName(), posColorIcon);
            posItem.addActionListener(new ChangeTrackColorActionListener(track, ChangeTrackMethod.POSITIVE));
            setPosColorMenu.add(posItem);
            ColorIcon negColorIcon = new ColorIcon(track.getAltColor());
            JMenuItem negItem = new JMenuItem(track.getName(), negColorIcon);
            negItem.addActionListener(new ChangeTrackColorActionListener(track, ChangeTrackMethod.NEGATIVE));
            setNegColorMenu.add(negItem);
        }
        menu.add(setPosColorMenu);
        menu.add(setNegColorMenu);
        menu.add(TrackMenuUtils.getChangeTrackHeightItem(selfAsList));
        menu.add(TrackMenuUtils.getChangeFontSizeItem(selfAsList));
        menu.addSeparator();
        TrackMenuUtils.addDataItems(menu, selfAsList, true);
        for (Component c : menu.getComponents()) {
            if (!(c instanceof JMenuItem)) continue;
            String text = ((JMenuItem)c).getText();
            String string = text = text != null ? text.toLowerCase() : "null";
            if (!text.contains("heatmap")) continue;
            c.setEnabled(false);
        }
        return menu;
    }

    @Override
    public Range getInViewRange(ReferenceFrame referenceFrame) {
        ArrayList<LocusScore> scores = new ArrayList<LocusScore>();
        for (DataTrack track : this.memberTracks) {
            scores.addAll(track.getInViewScores(referenceFrame));
        }
        if (scores.size() > 0) {
            float min = Float.MAX_VALUE;
            float max = -3.4028235E38f;
            for (LocusScore score : scores) {
                float value = score.getScore();
                if (Float.isNaN(value)) continue;
                min = Math.min(value, min);
                max = Math.max(value, max);
            }
            return new Range(min, max);
        }
        return null;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        if (this.alpha != DEFAULT_ALPHA) {
            element.setAttribute("alpha", String.valueOf(this.alpha));
        }
        for (DataTrack track : this.memberTracks) {
            Element trackElement = document.createElement("Track");
            track.marshalXML(document, trackElement);
            element.appendChild(trackElement);
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        if (element.hasAttribute("alpha")) {
            this.alpha = Double.valueOf(element.getAttribute("alpha"));
        }
    }

    @Override
    public void dispose() {
    }

    public JDialog getAlphaDialog() {
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JSlider theSlider = (JSlider)changeEvent.getSource();
                double alpha = (double)theSlider.getValue() / 100.0;
                MergedTracks.this.setTrackAlphas(alpha);
                IGV.getInstance().getContentPane().repaint();
            }
        };
        JOptionPane optionPane = new JOptionPane();
        int initialValue = (int)Math.floor(this.getTrackAlpha() * 100.0);
        JSlider slider = new JSlider(0, 100, initialValue);
        slider.setMajorTickSpacing(10);
        slider.setPaintTicks(false);
        slider.setPaintLabels(false);
        slider.addChangeListener(changeListener);
        optionPane.setMessage(new Object[]{"Adjust transparency: ", slider});
        optionPane.setMessageType(3);
        optionPane.setOptionType(2);
        JDialog dialog = optionPane.createDialog(IGV.getMainFrame(), "Transparency");
        return dialog;
    }

    private static class ColorIcon
    implements Icon {
        private Color color;
        private int iconSize;

        ColorIcon(Color color) {
            this(color, 16);
        }

        ColorIcon(Color color, int iconSize) {
            this.color = color;
            this.iconSize = iconSize;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics cg = g.create();
            cg.setColor(this.color);
            if (this.iconSize > c.getHeight()) {
                this.iconSize = c.getHeight();
            }
            cg.fillRect(x, y, this.iconSize, this.iconSize);
        }

        @Override
        public int getIconWidth() {
            return this.iconSize;
        }

        @Override
        public int getIconHeight() {
            return this.iconSize;
        }
    }

    private static class ChangeTrackColorActionListener
    implements ActionListener {
        private Track mTrack;
        private ChangeTrackMethod method;

        private ChangeTrackColorActionListener(Track track, ChangeTrackMethod method) {
            this.mTrack = track;
            this.method = method;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            switch (this.method) {
                case POSITIVE: {
                    TrackMenuUtils.changeTrackColor(Arrays.asList(this.mTrack));
                    break;
                }
                case NEGATIVE: {
                    TrackMenuUtils.changeAltTrackColor(Arrays.asList(this.mTrack));
                    break;
                }
                default: {
                    throw new IllegalStateException("Method not understood: " + this.method);
                }
            }
        }
    }

    private static enum ChangeTrackMethod {
        POSITIVE,
        NEGATIVE;

    }
}

