/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.tdf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.util.StringUtils;

public class TDFEntity {
    Map<String, String> attributes;
    private String name;

    public TDFEntity(String name) {
        this.name = name;
        this.attributes = new HashMap<String, String>();
    }

    public TDFEntity(String name, Map<String, String> attributes) {
        this.name = name;
        this.attributes = attributes;
    }

    public Set<String> getAttributeNames() {
        return this.attributes.keySet();
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    void writeAttributes(BufferedByteWriter dos) throws IOException {
        dos.putInt(this.attributes.size());
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            this.writeString(dos, entry.getKey());
            this.writeString(dos, entry.getValue());
        }
    }

    void readAttributes(ByteBuffer byteBuffer) throws IOException {
        int nAttributes = byteBuffer.getInt();
        while (nAttributes-- > 0) {
            String key = StringUtils.readString(byteBuffer);
            String value = StringUtils.readString(byteBuffer);
            this.setAttribute(key, value);
        }
    }

    public void writeString(BufferedByteWriter dos, String s) throws IOException {
        dos.putNullTerminatedString(s);
    }

    public String getName() {
        return this.name;
    }
}

