/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gwas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.gwas.EQTLCodec;
import org.broad.igv.gwas.EQTLFeature;
import org.broad.igv.tdf.BufferedByteWriter;
import org.broad.igv.tools.sort.Sorter;
import org.broad.igv.tools.sort.SorterFactory;
import org.broad.igv.util.CompressionUtils;

public class EqtlPreprocessor {
    static int version = 0;
    long indexPositionPosition;
    int bytesWritten;
    BufferedByteWriter currentChrBuffer;
    String currentChr;
    private FileOutputStream fos;
    private Map<String, IndexEntry> chrPositionMap;
    private CompressionUtils compressionUtils;

    public static void main(String[] args) throws IOException {
        File[] files;
        for (File file : files = new File(args[0]).listFiles()) {
            if (!file.getName().endsWith(".eqtl")) continue;
            File sortedFile = new File(file.getAbsolutePath() + ".sorted.eqtl");
            Sorter sorter = SorterFactory.getSorter(file, sortedFile);
            sorter.run();
            new EqtlPreprocessor().process(sortedFile.getAbsolutePath(), file.getAbsolutePath() + ".bin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String inputFile, String outputFile) throws IOException {
        this.bytesWritten = 0;
        BufferedReader br = null;
        this.fos = null;
        this.currentChr = null;
        this.currentChrBuffer = null;
        this.chrPositionMap = new HashMap<String, IndexEntry>();
        this.compressionUtils = new CompressionUtils();
        EQTLCodec codec = new EQTLCodec(null);
        try {
            this.fos = new FileOutputStream(outputFile);
            this.writeHeader();
            br = new BufferedReader(new FileReader(inputFile));
            String nextLine = br.readLine();
            while ((nextLine = br.readLine()) != null) {
                EQTLFeature feature = codec.decode(nextLine);
                String chr = feature.getChr();
                if (!chr.equals(this.currentChr)) {
                    if (this.currentChrBuffer != null) {
                        System.out.println(this.currentChr);
                        this.writeChrBuffer();
                    }
                    this.currentChr = chr;
                    this.currentChrBuffer = new BufferedByteWriter();
                }
                this.currentChrBuffer.put(feature.encodeBinary());
            }
            if (this.currentChrBuffer != null) {
                this.writeChrBuffer();
            }
            long position = this.bytesWritten;
            int nBytes = this.writeIndex();
            this.fos.close();
            this.writeIndexPosition(outputFile, position, nBytes);
        }
        finally {
            if (br != null) {
                br.close();
            }
        }
    }

    private void writeChrBuffer() throws IOException {
        byte[] rawBytes;
        byte[] compressedBytes = rawBytes = this.currentChrBuffer.getBytes();
        int position = this.bytesWritten;
        int size = compressedBytes.length;
        this.write(compressedBytes);
        this.chrPositionMap.put(this.currentChr, new IndexEntry(position, size));
    }

    private int writeIndex() throws IOException {
        BufferedByteWriter buff = new BufferedByteWriter();
        buff.putInt(this.chrPositionMap.size());
        for (Map.Entry<String, IndexEntry> entry : this.chrPositionMap.entrySet()) {
            IndexEntry ie = entry.getValue();
            buff.putNullTerminatedString(entry.getKey());
            buff.putLong(ie.position);
            buff.putInt(ie.size);
        }
        byte[] bytes = buff.getBytes();
        this.write(bytes);
        return bytes.length;
    }

    private void writeHeader() throws IOException {
        byte[] magicNumber = new byte[]{69, 81, 84, 76};
        BufferedByteWriter buffer = new BufferedByteWriter();
        buffer.put(magicNumber);
        buffer.putInt(version);
        this.indexPositionPosition = buffer.bytesWritten();
        buffer.putLong(0L);
        buffer.putInt(0);
        byte[] bytes = buffer.getBytes();
        this.write(bytes);
    }

    private void writeIndexPosition(String file, long indexPosition, int nbytes) {
        try {
            RandomAccessFile raf = new RandomAccessFile(file, "rw");
            raf.getChannel().position(this.indexPositionPosition);
            BufferedByteWriter buffer = new BufferedByteWriter();
            buffer.putLong(indexPosition);
            buffer.putInt(nbytes);
            raf.write(buffer.getBytes());
            raf.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void write(byte[] bytes) throws IOException {
        this.fos.write(bytes);
        this.bytesWritten += bytes.length;
    }

    static class IndexEntry {
        long position;
        int size;

        IndexEntry(long position, int size) {
            this.position = position;
            this.size = size;
        }
    }
}

