/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import org.apache.log4j.Logger;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeNode;
import org.broad.igv.bbfile.RPTreeNodeItem;
import org.broad.igv.bbfile.RPTreeNodeProxy;

public class RPTreeChildNodeItem
extends RPTreeNodeItem {
    private static Logger log = Logger.getLogger(RPTreeChildNodeItem.class);
    private RPTreeNode childNode;
    private RPTreeNodeProxy childNodeProxy;

    public RPTreeChildNodeItem(int startChromID, int startBase, int endChromID, int endBase, RPTreeNode childNode) {
        super(new RPChromosomeRegion(startChromID, startBase, endChromID, endBase));
        this.childNode = childNode;
    }

    public RPTreeChildNodeItem(int startChromID, int startBase, int endChromID, int endBase, RPTreeNodeProxy childNodeProxy) {
        super(new RPChromosomeRegion(startChromID, startBase, endChromID, endBase));
        this.childNodeProxy = childNodeProxy;
    }

    public RPTreeNode getChildNode() {
        if (this.childNode == null) {
            RPTreeNodeProxy proxy = this.childNodeProxy;
            this.childNode = RPTree.readRPTreeNode(proxy.fis, proxy.fileOffset, proxy.isLowToHigh, true);
        }
        return this.childNode;
    }

    @Override
    public void print() {
        super.print();
        this.childNode.printItems();
    }
}

