/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.net;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public class SyncPipe
implements Runnable {
    private final Logger logger;
    private final boolean quiet;
    private final OutputStream ostrm_;
    private final InputStream istrm_;

    public SyncPipe(InputStream istrm, OutputStream ostrm, Logger logger) {
        this(false, istrm, ostrm, logger);
    }

    public SyncPipe(boolean quiet, InputStream istrm, OutputStream ostrm, Logger logger) {
        this.quiet = quiet;
        this.istrm_ = istrm;
        this.ostrm_ = ostrm;
        this.logger = logger;
    }

    @Override
    public void run() {
        try {
            byte[] buffer = new byte[1024];
            int length = 0;
            while ((length = this.istrm_.read(buffer)) != -1) {
                if (this.quiet) continue;
                this.ostrm_.write(buffer, 0, length);
            }
            if (!this.quiet) {
                this.ostrm_.flush();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)this.istrm_);
        }
    }
}

