/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.net;

import edu.cornell.med.icb.net.SyncPipe;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.util.Collection;
import org.apache.log4j.Logger;

public class CommandExecutor {
    private static final Logger LOG = Logger.getLogger(CommandExecutor.class);
    private String remoteServer;
    private String username;
    boolean quiet;
    final boolean local;

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public CommandExecutor(String username, String remoteServer) {
        this.remoteServer = remoteServer;
        this.username = username;
        this.local = false;
    }

    public CommandExecutor() {
        this.local = true;
    }

    public int scpFromRemote(String remotePath, String localFilename) throws IOException, InterruptedException {
        if (this.local) {
            throw new IOException("This instance of CommandExecutor can be used only for local commands");
        }
        return this.exec(String.format("scp -p -o StrictHostKeyChecking=no %s@%s:%s %s", this.username, this.remoteServer, remotePath, localFilename), new String[0]);
    }

    public int scpDirFromRemote(String remotePath, String localPath) throws IOException, InterruptedException {
        if (this.local) {
            throw new IOException("This instance of CommandExecutor can be used only for local commands");
        }
        return this.exec(String.format("scp -r -p -o StrictHostKeyChecking=no %s@%s:%s %s", this.username, this.remoteServer, remotePath, localPath), new String[0]);
    }

    public int scpToRemote(String localFilename, String remotePath) throws IOException, InterruptedException {
        if (this.local) {
            throw new IOException("This instance of CommandExecutor can be used only for local commands");
        }
        return this.exec(String.format("scp -p -o StrictHostKeyChecking=no %s %s@%s:%s", localFilename, this.username, this.remoteServer, remotePath), new String[0]);
    }

    public int scpDirToRemote(String localPath, String remotePath) throws IOException, InterruptedException {
        if (this.local) {
            throw new IOException("This instance of CommandExecutor can be used only for local commands");
        }
        return this.exec(String.format("scp -r -p -o StrictHostKeyChecking=no %s %s@%s:%s", localPath, this.username, this.remoteServer, remotePath), new String[0]);
    }

    public int ssh(String command, String ... envp) throws IOException, InterruptedException {
        if (this.local) {
            throw new IOException("This instance of CommandExecutor can be used only for local commands");
        }
        StringBuilder exportStatement = new StringBuilder();
        boolean hasExports = false;
        if (envp.length > 0) {
            hasExports = true;
            exportStatement.append("bash -c '");
            for (String varAssignment : envp) {
                exportStatement.append("export ");
                exportStatement.append(varAssignment);
            }
        }
        Object[] statement = String.format("ssh -o StrictHostKeyChecking=no %s@%s", this.username, this.remoteServer).split(" ");
        if (hasExports) {
            exportStatement.append(" ; ");
        }
        exportStatement.append(command);
        if (hasExports) {
            exportStatement.append('\'');
        }
        String middle = exportStatement.toString();
        ObjectArrayList commands = new ObjectArrayList();
        commands.addAll((Collection)new ObjectArrayList(statement));
        commands.add((Object)middle);
        LOG.debug((Object)commands.toString());
        return this.exec((String[])commands.toArray((Object[])new String[commands.size()]), envp);
    }

    public int exec(String command, String ... envp) throws IOException, InterruptedException {
        return this.exec(command, Runtime.getRuntime(), command.split(" "), envp);
    }

    public int exec(String[] commands, String ... envp) throws IOException, InterruptedException {
        return this.exec(ObjectArrayList.wrap((Object[])commands).toString(), Runtime.getRuntime(), commands, envp);
    }

    private int exec(String command, Runtime rt, String[] commands, String[] envp) throws IOException, InterruptedException {
        Process pr = rt.exec(commands, envp);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("executing command: " + command));
        }
        new Thread(new SyncPipe(this.quiet, pr.getErrorStream(), System.err, LOG)).start();
        new Thread(new SyncPipe(this.quiet, pr.getInputStream(), System.out, LOG)).start();
        int exitVal = pr.waitFor();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Remote command  exited with error code " + exitVal));
        }
        return exitVal;
    }
}

