/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.IOException;
import org.campagnelab.goby.counts.CountsAggregatorI;
import org.campagnelab.goby.counts.CountsReaderI;

public class UnionDumpIterator
implements CountsAggregatorI {
    private CountsReaderI[] readers;
    IntArrayList[] positions;
    IntArrayList[] counts;
    IntArrayList[] lengths;
    int[] sizes;
    int numReaders;
    private int position = 0;
    private boolean hasNextTransition;
    private int index;
    private int[] count;
    private int length;
    private int maxSize;
    private int beforePosition;
    private boolean doneOnNext;

    public UnionDumpIterator(CountsReaderI ... countReader) throws IOException {
        this.readers = countReader;
        this.positions = new IntArrayList[this.readers.length];
        this.counts = new IntArrayList[this.readers.length];
        this.sizes = new int[this.readers.length];
        int i = 0;
        this.numReaders = this.readers.length;
        this.count = new int[this.numReaders];
        for (CountsReaderI reader : this.readers) {
            this.counts[i] = new IntArrayList();
            this.positions[i] = new IntArrayList();
            int position = -1;
            while (reader.hasNextTransition()) {
                reader.nextTransition();
                int count = reader.getCount();
                int length = reader.getLength();
                int pos = reader.getPosition();
                for (int j = 0; j < length; ++j) {
                    this.counts[i].add(count);
                    ++position;
                }
            }
            this.sizes[i] = this.counts[i].size();
            this.maxSize = Math.max(this.sizes[i], this.maxSize);
            ++i;
        }
    }

    @Override
    public int getPosition() {
        return this.beforePosition;
    }

    @Override
    public boolean hasNextTransition() throws IOException {
        if (this.hasNextTransition) {
            return true;
        }
        if (this.position > this.maxSize) {
            this.beforePosition = this.position - 1;
            return false;
        }
        this.beforePosition = this.position;
        while (this.sameCounts(this.position, this.position + 1) && this.position < this.maxSize) {
            ++this.position;
        }
        this.length = this.position - this.beforePosition + 1;
        for (int i = 0; i < this.numReaders; ++i) {
            int count;
            this.count[i] = count = this.beforePosition >= this.sizes[i] ? 0 : this.counts[i].getInt(this.beforePosition);
        }
        ++this.position;
        if (this.position >= this.maxSize) {
            --this.length;
        }
        this.hasNextTransition = true;
        return true;
    }

    private boolean sameCounts(int position, int nextPos) {
        if (position == -1) {
            return true;
        }
        for (int i = 0; i < this.numReaders; ++i) {
            if (nextPos < this.sizes[i] && this.counts[i].getInt(position) != this.counts[i].getInt(nextPos)) {
                return false;
            }
            if (nextPos != this.sizes[i] || this.counts[i].getInt(position) == 0 || nextPos == this.maxSize) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int getCount(int readerIndex) {
        return this.count[readerIndex];
    }

    @Override
    public void nextTransition() throws IOException {
        if (!this.hasNextTransition()) {
            throw new IllegalStateException("No such element");
        }
        this.hasNextTransition = false;
    }

    @Override
    public int getCount() {
        int count = 0;
        for (int i = 0; i < this.numReaders; ++i) {
            count += this.getCount(i);
        }
        return count;
    }

    @Override
    public void skipTo(int position) throws IOException {
        for (CountsReaderI reader : this.readers) {
            reader.skipTo(position);
        }
    }

    @Override
    public void reposition(int position) throws IOException {
        throw new UnsupportedOperationException("this implementation does not support this method.");
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void close() throws IOException {
        int index = 0;
        for (CountsReaderI reader : this.readers) {
            this.counts[index].clear();
            this.positions[index].clear();
            reader.close();
            ++index;
        }
    }
}

