/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.counts;

import it.unimi.dsi.io.OutputBitStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.counts.CountsWriterI;

public class CountsWriter
implements CountsWriterI {
    private static final Log LOG = LogFactory.getLog(CountsWriter.class);
    private OutputBitStream out;
    private int previousCount;
    private boolean dataAlreadyWritten;
    private int numberOfCountsWritten;
    private int bitsWritten;
    private int position;
    private long numberOfBasesSeen;
    private int numberOfSitesSeen;
    private int initialCount;

    public CountsWriter(OutputStream output, int initialCount) throws IOException {
        this.out = new OutputBitStream(output);
        this.setInitialCount(initialCount);
    }

    public CountsWriter(OutputStream output) throws IOException {
        this(output, 1);
    }

    private void setInitialCount(int count) throws IOException {
        if (this.dataAlreadyWritten) {
            throw new IllegalStateException("Data must not have been written before setting initial count.");
        }
        this.initialCount = count;
        this.previousCount = count;
        this.bitsWritten += this.out.writeDelta(this.previousCount + 1);
    }

    @Override
    public long getNumberOfBitsWritten() {
        return this.bitsWritten;
    }

    @Override
    public int getNumberOfTransitions() {
        return this.numberOfCountsWritten;
    }

    @Override
    public void appendCount(int count, int lengthConstant) throws IOException {
        assert (lengthConstant > 0) : "length must be greater than zero.";
        int deltaCount = count - this.previousCount;
        int deltaCountEncoded = CountsWriter.encodeDeltaCount(deltaCount);
        assert (deltaCountEncoded > 0) : " delta count integer must not be zero";
        this.bitsWritten += this.out.writeGamma(deltaCountEncoded);
        this.bitsWritten += this.out.writeGamma(lengthConstant);
        this.dataAlreadyWritten = true;
        this.previousCount = count;
        ++this.numberOfCountsWritten;
        this.position += lengthConstant;
        this.numberOfBasesSeen += (long)(count * lengthConstant);
        if (count != 0) {
            this.numberOfSitesSeen += lengthConstant;
        }
    }

    protected static int encodeDeltaCount(int deltaCount) {
        int deltaCountEncoded = deltaCount < 0 ? -deltaCount * 2 + 1 : deltaCount * 2;
        return deltaCountEncoded;
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            this.bitsWritten += this.out.writeGamma(277492431);
            this.out.flush();
            this.out.close();
            this.out = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("bits written: " + this.bitsWritten));
                LOG.debug((Object)("bytes written: " + this.bitsWritten / 8));
                LOG.debug((Object)("number of transitions: " + this.numberOfCountsWritten));
                LOG.debug((Object)("bits/count_transition (average): " + (float)this.bitsWritten / (float)this.numberOfCountsWritten));
            }
        }
    }

    @Override
    public long getNumberOfBasesSeen() {
        return this.numberOfBasesSeen;
    }

    @Override
    public long getNumberOfSitesSeen() {
        return this.numberOfSitesSeen;
    }

    @Override
    public int getInitialCount() {
        return this.initialCount;
    }
}

