/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ProgressLoggerInterface;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.Comparator;
import org.campagnelab.goby.alignments.SamRecordGenomicPositionComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedSortingSamBamWriter
implements SAMFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(BufferedSortingSamBamWriter.class);
    private final SAMFileWriter delegate;
    private final ObjectHeapPriorityQueue<SAMRecord> heap;
    private static final int DEFAULT_CAPACITY = 1000;
    private static final Comparator<SAMRecord> GENOMIC_POSITION_COMPARATOR = new SamRecordGenomicPositionComparator();
    private int capacity;
    private int frontTargetIndex;
    private int frontPosition;
    private boolean check = true;

    public BufferedSortingSamBamWriter(SAMFileWriter destination, int capacity) {
        this.capacity = capacity;
        this.delegate = destination;
        this.heap = new ObjectHeapPriorityQueue(capacity, GENOMIC_POSITION_COMPARATOR);
    }

    public BufferedSortingSamBamWriter(SAMFileWriter destination) {
        this(destination, 1000);
    }

    public void addAlignment(SAMRecord entry) {
        while (this.heap.size() > this.capacity) {
            SAMRecord queueEntry = (SAMRecord)this.heap.dequeue();
            this.checkFront(queueEntry);
            this.delegate.addAlignment(queueEntry);
        }
        this.heap.enqueue((Object)entry);
    }

    private void checkFront(SAMRecord entry) {
        if (this.check) {
            int targetIndex = entry.getReferenceIndex();
            int position = entry.getAlignmentStart();
            if (targetIndex < this.frontTargetIndex || targetIndex == this.frontTargetIndex && position < this.frontPosition) {
                LOG.warn("Local sorting strategy failed to restore sort order. The destination will be unsorted. You must sort the output manually to restore sort order.");
                this.check = false;
            }
            if (this.frontTargetIndex != targetIndex) {
                this.frontPosition = 0;
            }
            this.frontTargetIndex = Math.max(this.frontTargetIndex, targetIndex);
            this.frontPosition = Math.max(this.frontPosition, position);
        }
    }

    public SAMFileHeader getFileHeader() {
        return this.delegate.getFileHeader();
    }

    public void setProgressLogger(ProgressLoggerInterface progressLoggerInterface) {
    }

    public void close() {
        while (!this.heap.isEmpty()) {
            SAMRecord queueEntry = (SAMRecord)this.heap.dequeue();
            this.checkFront(queueEntry);
            this.delegate.addAlignment(queueEntry);
        }
        this.delegate.close();
    }
}

