/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.util;

import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Longs;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.UnflaggedOption;
import com.martiansoftware.jsap.stringparsers.ForNameStringParser;
import com.martiansoftware.jsap.stringparsers.IntSizeStringParser;
import it.unimi.dsi.bits.Fast;
import it.unimi.dsi.fastutil.Size64;
import it.unimi.dsi.fastutil.io.BinIO;
import it.unimi.dsi.io.FastBufferedReader;
import it.unimi.dsi.lang.MutableString;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;

public class BloomFilter<T>
implements Serializable,
Size64 {
    private static final long serialVersionUID = 4L;
    private static final long LOG2_LONG_SIZE = 6L;
    public static final Funnel<byte[]> BYTE_ARRAY_FUNNEL = Funnels.byteArrayFunnel();
    public static final Funnel<CharSequence> STRING_FUNNEL = Funnels.unencodedCharsFunnel();
    public static final Funnel<Integer> INTEGER_FUNNEL = Funnels.integerFunnel();
    public static final Funnel<Long> LONG_FUNNEL = Funnels.longFunnel();
    public static final long MAX_BITS = 137438953408L;
    private final long m;
    private final int d;
    private final long[] bits;
    private final HashFunction hashFunction;
    private long size;
    private final Funnel<T> funnel;

    protected BloomFilter(long n, int d, Funnel<T> funnel) {
        this.d = d;
        this.funnel = funnel;
        long wantedNumberOfBits = (long)Math.ceil((double)n * ((double)d / Math.log(2.0)));
        if (wantedNumberOfBits > 137438953408L) {
            throw new IllegalArgumentException("The wanted number of bits (" + wantedNumberOfBits + ") is larger than " + 137438953408L);
        }
        this.bits = new long[(int)((wantedNumberOfBits + 64L - 1L) / 64L)];
        this.m = (long)Math.max(1, this.bits.length) * 64L;
        this.hashFunction = Hashing.murmur3_128();
    }

    public static <T> BloomFilter<T> create(long n, Funnel<T> funnel) {
        return new BloomFilter<T>(n, Fast.ceilLog2(n), funnel);
    }

    public static <T> BloomFilter<T> create(long n, int d, Funnel<T> funnel) {
        return new BloomFilter<T>(n, d, funnel);
    }

    public static <T> BloomFilter<T> create(long n, double precision, Funnel<T> funnel) {
        return new BloomFilter<T>(n, Math.max(0, (int)Math.ceil(-Fast.log2(precision))), funnel);
    }

    public static BloomFilter<Void> create(long n) {
        return BloomFilter.create(n, null);
    }

    public static BloomFilter<Void> create(long n, int d) {
        return BloomFilter.create(n, d, null);
    }

    public static BloomFilter<Void> create(long n, double precision) {
        return BloomFilter.create(n, precision, null);
    }

    private static boolean get(long[] bits, long hash, long m) {
        long index = (hash & Long.MAX_VALUE) % m;
        return (bits[(int)(index >> 6)] & 1L << (int)index) != 0L;
    }

    private static boolean set(long[] bits, long hash, long m) {
        long index = (hash & Long.MAX_VALUE) % m;
        int unit = (int)(index >> 6);
        long mask = 1L << (int)index;
        boolean result = (bits[unit] & mask) != 0L;
        int n = unit;
        bits[n] = bits[n] | mask;
        return result;
    }

    public boolean add(CharSequence s) {
        return this.add(s, STRING_FUNNEL);
    }

    public boolean add(byte[] a) {
        return this.add(a, BYTE_ARRAY_FUNNEL);
    }

    public boolean add(char[] a) {
        return this.add(new String(a), STRING_FUNNEL);
    }

    public boolean add(int x) {
        return this.add(x, INTEGER_FUNNEL);
    }

    public boolean add(long x) {
        return this.add(x, LONG_FUNNEL);
    }

    public boolean add(T e) {
        return this.add(e, this.funnel);
    }

    public <V> boolean add(V e, Funnel<V> funnel) {
        return this.addHash(this.hashFunction.newHasher().putObject(e, funnel).hash().asBytes());
    }

    public boolean addHash(byte[] hash) {
        long hash0 = Longs.fromBytes((byte)hash[0], (byte)hash[1], (byte)hash[2], (byte)hash[3], (byte)hash[4], (byte)hash[5], (byte)hash[6], (byte)hash[7]);
        long hash1 = Longs.fromBytes((byte)hash[8], (byte)hash[9], (byte)hash[10], (byte)hash[11], (byte)hash[12], (byte)hash[13], (byte)hash[14], (byte)hash[15]);
        long[] bits = this.bits;
        boolean alreadySet = true;
        long m = this.m;
        int i = this.d;
        while (i-- != 0) {
            alreadySet &= BloomFilter.set(bits, hash0 + (long)i * hash1, m);
        }
        if (!alreadySet) {
            ++this.size;
        }
        return !alreadySet;
    }

    public boolean contains(CharSequence s) {
        return this.contains(s, STRING_FUNNEL);
    }

    public boolean contains(byte[] a) {
        return this.contains(a, BYTE_ARRAY_FUNNEL);
    }

    public boolean contains(char[] a) {
        return this.contains(new String(a), STRING_FUNNEL);
    }

    public boolean contains(int x) {
        return this.contains(x, INTEGER_FUNNEL);
    }

    public boolean contains(long x) {
        return this.contains(x, LONG_FUNNEL);
    }

    public boolean contains(T e) {
        return this.contains(e, this.funnel);
    }

    private <V> boolean contains(V e, Funnel<V> funnel) {
        return this.containsHash(this.hashFunction.newHasher().putObject(e, funnel).hash().asBytes());
    }

    public boolean containsHash(byte[] hash) {
        long hash0 = Longs.fromBytes((byte)hash[0], (byte)hash[1], (byte)hash[2], (byte)hash[3], (byte)hash[4], (byte)hash[5], (byte)hash[6], (byte)hash[7]);
        long hash1 = Longs.fromBytes((byte)hash[8], (byte)hash[9], (byte)hash[10], (byte)hash[11], (byte)hash[12], (byte)hash[13], (byte)hash[14], (byte)hash[15]);
        long[] bits = this.bits;
        long m = this.m;
        int i = this.d;
        while (i-- != 0) {
            if (BloomFilter.get(bits, hash0 + (long)i * hash1, m)) continue;
            return false;
        }
        return true;
    }

    public void clear() {
        Arrays.fill(this.bits, 0L);
        this.size = 0L;
    }

    public long size64() {
        return this.size;
    }

    @Deprecated
    public int size() {
        return (int)Math.min(Integer.MAX_VALUE, this.size);
    }

    public static void main(String[] arg) throws IOException, JSAPException, NoSuchMethodException {
        SimpleJSAP jsap = new SimpleJSAP(BloomFilter.class.getName(), "Creates a Bloom filter reading from standard input a newline-separated list of terms.", new Parameter[]{new FlaggedOption("bufferSize", (StringParser)IntSizeStringParser.getParser(), "64Ki", false, 'b', "buffer-size", "The size of the I/O buffer used to read terms."), new FlaggedOption("encoding", (StringParser)ForNameStringParser.getParser(Charset.class), "UTF-8", false, 'e', "encoding", "The term file encoding."), new UnflaggedOption("bloomFilter", (StringParser)JSAP.STRING_PARSER, JSAP.NO_DEFAULT, true, false, "The filename for the serialised front-coded list."), new UnflaggedOption("size", (StringParser)JSAP.INTSIZE_PARSER, JSAP.NO_DEFAULT, true, false, "The size of the filter (i.e., the expected number of elements in the filter; usually, the number of terms)."), new UnflaggedOption("precision", (StringParser)JSAP.INTEGER_PARSER, JSAP.NO_DEFAULT, true, false, "The precision of the filter.")});
        JSAPResult jsapResult = jsap.parse(arg);
        if (jsap.messagePrinted()) {
            return;
        }
        int bufferSize = jsapResult.getInt("bufferSize");
        String filterName = jsapResult.getString("bloomFilter");
        Charset encoding = (Charset)jsapResult.getObject("encoding");
        BloomFilter<Void> filter = BloomFilter.create((long)jsapResult.getInt("size"), jsapResult.getInt("precision"));
        ProgressLogger pl = new ProgressLogger();
        pl.itemsName = "terms";
        pl.start("Reading terms...");
        MutableString s = new MutableString();
        FastBufferedReader reader = new FastBufferedReader((Reader)new InputStreamReader(System.in, encoding), bufferSize);
        while (reader.readLine(s) != null) {
            filter.add(s);
            pl.lightUpdate();
        }
        pl.done();
        reader.close();
        BinIO.storeObject(filter, (CharSequence)filterName);
    }
}

