/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.ParseException;
import java.util.List;

public abstract class Parameter {
    private String id = null;
    private String usageName = null;
    private boolean locked = false;
    private String[] defaultValue = null;
    private String help = null;

    public Parameter(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    protected final void setLocked(boolean locked) {
        this.locked = locked;
    }

    protected final boolean locked() {
        return this.locked;
    }

    protected final void enforceParameterLock() {
        if (this.locked) {
            throw new IllegalStateException("Parameter '" + this.getID() + "' may not be changed.");
        }
    }

    protected final void _setDefault(String defaultValue) {
        if (defaultValue == JSAP.NO_DEFAULT) {
            this.defaultValue = null;
        } else {
            this.defaultValue = new String[1];
            this.defaultValue[0] = defaultValue;
        }
    }

    protected final void _setDefault(String[] defaultValues) {
        this.defaultValue = defaultValues;
    }

    public final void addDefault(String defaultValue) {
        if (defaultValue != JSAP.NO_DEFAULT) {
            if (this.defaultValue == null) {
                this.defaultValue = new String[0];
            }
            int defaultValueCount = this.defaultValue.length + 1;
            String[] newDefaultValue = new String[defaultValueCount];
            for (int i = 0; i < defaultValueCount - 1; ++i) {
                newDefaultValue[i] = this.defaultValue[i];
            }
            newDefaultValue[defaultValueCount - 1] = defaultValue;
            this.defaultValue = newDefaultValue;
        }
    }

    protected final void _setUsageName(String usageName) {
        this.usageName = usageName;
    }

    public final String getUsageName() {
        return this.usageName == null ? this.id : this.usageName;
    }

    public final String[] getDefault() {
        return this.defaultValue;
    }

    protected abstract List parse(String var1) throws ParseException;

    public abstract String getSyntax();

    public final String getUsage() {
        return this.getSyntax();
    }

    public final String getHelp() {
        return this.help == null ? "" : this.help;
    }

    public final Parameter setHelp(String help) {
        this.help = help;
        return this;
    }
}

