# This file was created from xpl/multfree.xpl, do not edit!
#########################################################################
##
#W  multfree.tst              GAP applications              Thomas Breuer
##
#H  @(#)$Id: multfree.tst,v 1.6 2001/12/08 11:27:16 gap Exp $
##
#Y  Copyright 2000,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,   Germany
##
##  In order to run the tests, one starts {GAP} from the `tst` subdirectory
##  of the `pkg/ctbllib` directory, and calls `ReadTest( "multfree.tst" );`.
##

gap> START_TEST("$Id: multfree.xpl,v 1.6 2001/12/08 11:27:16 gap Exp $");

gap> Read( "multfree.dat" );
--------------------------------------------------------------------
Loading the Database of Multiplicity-Free Permutation Characters
of the Sporadic Simple Groups and Their Automorphism Groups,
by T. Breuer and K. Lux;
call `MultFreePermChars( <name> )' for accessing the data
for the group whose character table has identifier <name>.
--------------------------------------------------------------------
gap> info:= MultFreePermChars( "M11" );
[ rec( group := "$M_{11}$", character := Character( CharacterTable( "M11" ), 
        [ 11, 3, 2, 3, 1, 0, 1, 1, 0, 0 ] ), rank := 2, 
      subgroup := "$A_6.2_3$", ATLAS := "1a+10a" ), 
  rec( group := "$M_{11}$", character := Character( CharacterTable( "M11" ), 
        [ 22, 6, 4, 2, 2, 0, 0, 0, 0, 0 ] ), rank := 3, 
      subgroup := "$A_6 \\leq A_6.2_3$", ATLAS := "1a+10a+11a" ), 
  rec( group := "$M_{11}$", character := Character( CharacterTable( "M11" ), 
        [ 12, 4, 3, 0, 2, 1, 0, 0, 1, 1 ] ), rank := 2, 
      subgroup := "$L_2(11)$", ATLAS := "1a+11a" ), 
  rec( group := "$M_{11}$", character := Character( CharacterTable( "M11" ), 
        [ 144, 0, 0, 0, 4, 0, 0, 0, 1, 1 ] ), rank := 6, 
      subgroup := "$11:5 \\leq L_2(11)$", ATLAS := "1a+11a+16ab+45a+55a" ), 
  rec( group := "$M_{11}$", character := Character( CharacterTable( "M11" ), 
        [ 55, 7, 1, 3, 0, 1, 1, 1, 0, 0 ] ), rank := 3, 
      subgroup := "$3^2:Q_8.2$", ATLAS := "1a+10a+44a" ), 
  rec( group := "$M_{11}$", character := Character( CharacterTable( "M11" ), 
        [ 110, 6, 2, 2, 0, 0, 2, 2, 0, 0 ] ), rank := 4, 
      subgroup := "$3^2:8 \\leq 3^2:Q_8.2$", ATLAS := "1a+10a+44a+55a" ), 
  rec( group := "$M_{11}$", character := Character( CharacterTable( "M11" ), 
        [ 66, 10, 3, 2, 1, 1, 0, 0, 0, 0 ] ), rank := 4, 
      subgroup := "$A_5.2$", ATLAS := "1a+10a+11a+44a" ) ]
gap> List( info, x -> x.rank );
[ 2, 3, 2, 6, 3, 4, 4 ]
gap> chars:= List( info, x -> x.character );;
gap> degrees:= List( chars, x -> x[1] );
[ 11, 22, 12, 144, 55, 110, 66 ]
gap> tbl:= CharacterTable( "M11" );
CharacterTable( "M11" )
gap> Display( tbl, rec( chars:= chars ) );
M11

     2   4  4  1  3  .  1  3  3   .   .
     3   2  1  2  .  .  1  .  .   .   .
     5   1  .  .  .  1  .  .  .   .   .
    11   1  .  .  .  .  .  .  .   1   1

        1a 2a 3a 4a 5a 6a 8a 8b 11a 11b
    2P  1a 1a 3a 2a 5a 3a 4a 4a 11b 11a
    3P  1a 2a 1a 4a 5a 2a 8a 8b 11a 11b
    5P  1a 2a 3a 4a 1a 6a 8b 8a 11a 11b
   11P  1a 2a 3a 4a 5a 6a 8a 8b  1a  1a

Y.1     11  3  2  3  1  .  1  1   .   .
Y.2     22  6  4  2  2  .  .  .   .   .
Y.3     12  4  3  .  2  1  .  .   1   1
Y.4    144  .  .  .  4  .  .  .   1   1
Y.5     55  7  1  3  .  1  1  1   .   .
Y.6    110  6  2  2  .  .  2  2   .   .
Y.7     66 10  3  2  1  1  .  .   .   .
gap> subgroups:= List( info, x -> x.subgroup );
[ "$A_6.2_3$", "$A_6 \\leq A_6.2_3$", "$L_2(11)$", "$11:5 \\leq L_2(11)$", 
  "$3^2:Q_8.2$", "$3^2:8 \\leq 3^2:Q_8.2$", "$A_5.2$" ]
gap> Print( subgroups[2], "\n" );
$A_6 \leq A_6.2_3$
gap> info:= MultFreePermChars( "M12.2" );;
gap> Length( info );
13
gap> info[1];
rec( group := "$M_{12}.2$", 
  character := Character( CharacterTable( "M12.2" ), 
    [ 24, 0, 8, 6, 0, 4, 4, 0, 2, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 ] ), 
  rank := 3, subgroup := "$M_{11}$", ATLAS := "1a^{\\pm}+11ab" )
gap> info[2];
rec( group := "$M_{12}.2$", 
  character := Character( CharacterTable( "M12.2" ), 
    [ 144, 0, 16, 9, 0, 0, 4, 0, 1, 0, 0, 1, 12, 4, 0, 0, 2, 2, 0, 1, 1 ] ), 
  rank := 4, subgroup := "$L_2(11).2$", ATLAS := "1a^++11ab+55a^++66a^+" )
gap> m12:= CharacterTable( "M12" );;
gap> m122:= UnderlyingCharacterTable( info[1].character );;
gap> fus:= GetFusionMap( m12, m122 );
[ 1, 2, 3, 4, 5, 6, 6, 7, 8, 9, 10, 10, 11, 12, 12 ]
gap> outer:= Difference( [ 1 .. NrConjugacyClasses( m122 ) ], fus );
[ 13, 14, 15, 16, 17, 18, 19, 20, 21 ]
gap> info[1].character{ outer };
[ 0, 0, 0, 0, 0, 0, 0, 0, 0 ]
gap> info[2].character{ outer };
[ 12, 4, 0, 0, 2, 2, 0, 1, 1 ]
gap> info[4];
rec( group := "$M_{12}.2$", 
  character := Character( CharacterTable( "M12.2" ), 
    [ 264, 24, 24, 12, 0, 4, 4, 0, 0, 2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ] ), 
  rank := 7, subgroup := "$A_6.2_2 \\leq A_6.2^2$", 
  ATLAS := "1a^{\\pm}+11ab+54a^{\\pm}+66a^{\\pm}" )
gap> info[9];
rec( group := "$M_{12}.2$", 
  character := Character( CharacterTable( "M12.2" ), 
    [ 792, 32, 24, 0, 6, 0, 2, 2, 0, 0, 2, 0, 0, 0, 8, 0, 0, 0, 2, 0, 0 ] ), 
  rank := 11, subgroup := "$(2 \\times A_5).2 \\leq (2^2 \\times A_5).2$", 
  ATLAS := "1a^++16ab+45a^++54a^{\\pm}+55a^-+66a^{\\pm}+99a^-+144a^++176a^-" )
gap> info:= MultFreePermChars( "all" );;
gap> Length( info );
267
gap> Length( Set( info ) );
262
gap> chars:= List( info, x -> x.character );;
gap> Length( Set( chars ) );
261
gap> distrib:= List( info, x -> Position( chars, x.character ) );;
gap> ambiguous:= Filtered( InverseMap( distrib ), IsList );
[ [ 12, 15 ], [ 40, 41 ], [ 83, 84 ], [ 88, 90 ], [ 132, 133 ], [ 202, 203 ] ]
gap> except:= Filtered( ambiguous, x -> info[ x[1] ] <> info[ x[2] ] );
[ [ 83, 84 ] ]
gap> ambiguous:= Difference( ambiguous, except );;
gap> info{ except[1] };
[ rec( ATLAS := "1a+22a+230a", 
      character := Character( CharacterTable( "M23" ), 
        [ 253, 29, 10, 5, 3, 2, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0 ] ), 
      group := "$M_{23}$", rank := 3, subgroup := "$L_3(4).2_2$" ), 
  rec( ATLAS := "1a+22a+230a", 
      character := Character( CharacterTable( "M23" ), 
        [ 253, 29, 10, 5, 3, 2, 1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0 ] ), 
      group := "$M_{23}$", rank := 3, subgroup := "$2^4:A_7$" ) ]
gap> ambiginfo:= info{ List( ambiguous, x -> x[1] ) };;
gap> for pair in ambiginfo do
>      Print( pair.group, ", ", pair.subgroup, ", ", pair.ATLAS, "\n" );
> od;
$M_{12}$, $A_6.2_1 \leq A_6.2^2$, 1a+11ab+54a+55a
$M_{22}$, $A_7$, 1a+21a+154a
$HS$, $U_3(5).2$, 1a+175a
$McL$, $M_{22}$, 1a+22a+252a+1750a
$Fi_{22}$, $O_7(3)$, 1a+429a+13650a
gap> Collected( List( info, x -> x.rank ) );
[ [ 2, 11 ], [ 3, 31 ], [ 4, 25 ], [ 5, 43 ], [ 6, 24 ], [ 7, 21 ], 
  [ 8, 26 ], [ 9, 16 ], [ 10, 17 ], [ 11, 9 ], [ 12, 9 ], [ 13, 8 ], 
  [ 14, 4 ], [ 15, 3 ], [ 16, 3 ], [ 17, 5 ], [ 18, 5 ], [ 19, 2 ], 
  [ 20, 2 ], [ 23, 1 ], [ 26, 1 ], [ 34, 1 ] ]
gap> max:= Filtered( info, x -> x.rank = 34 );;
gap> max[1].group;  max[1].subgroup;  max[1].character[1]; 
"$F_{3+}.2$"
"$O_{10}^-(2) \\leq O_{10}^-(2).2$"
100354720284
gap> nonsimple:= Filtered( info,
>        x -> not IsSimple( UnderlyingCharacterTable( x.character ) ) );;
gap> Length( nonsimple );
120
gap> ind:= Filtered( nonsimple, x -> ScalarProduct( x.character,
>              Irr( UnderlyingCharacterTable( x.character ) )[2] ) = 1 );;
gap> Length( ind );
48
gap> ind[1];
rec( ATLAS := "1a^{\\pm}+11ab", 
  character := Character( CharacterTable( "M12.2" ), 
    [ 24, 0, 8, 6, 0, 4, 4, 0, 2, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 ] ), 
  group := "$M_{12}.2$", rank := 3, subgroup := "$M_{11}$" )
gap> ForAll( ind, x -> x.ATLAS{ [ 1 .. 8 ] } = "1a^{\\pm}" );
true
#############################################################################
##
#F  MultFreeFromTOM( <tbl> )
##
##  For a character table <tbl> for which the table of marks is available in
##  the {\GAP} library,
##  `MultFreeFromTOM' returns the list of all multiplicity-free permutation
##  characters of <tbl>.
##
gap> BindGlobal( "MultFreeFromTOM", function( tbl )
>     local tom,     # the table of marks
>           fus,     # fusion map from `t' to `tom'
>           perms;   # perm. characters of `t'
> 
>     if IsBound( tbl!.tomidentifier ) or HasUnderlyingGroup( tbl ) then
>       tom:= TableOfMarks( tbl );
>     else
>       Error( "no table of marks for character table <tbl> available" );
>     fi;
>     fus:= FusionCharTableTom( tbl, tom );
>     if ForAll( fus, IsInt ) then
>       perms:= PermCharsTom( tbl, tom );
>       return Filtered( perms,
>                  x -> ForAll( Irr( tbl ),
>                               y -> ScalarProduct( tbl, x, y ) <= 1 ) );
>     else
>       Error( "no unique fusion from <tbl> to the table of marks" );
>     fi;
> end );
############################################################################
##
#F  MultFree( <G>, <H> )
##
##  Let <G> and <H> be character tables of groups $G$ and $H$, respectively,
##  such that $H$ is a subgroup of $G$ and the class fusion from <H> to <G>
##  is stored on <H>.
##  `MultFree' returns the list of all multiplicity-free characters
##  $\varphi^G$ of $G$ such that $\varphi$ is a possible permutation
##  character of $H$.
##
gap> BindGlobal( "MultFree", function( G, H )
>     local triv,     # $1_H$
>           permch,   # $(1_H)^G$
>           scpr1H,   # decomposition of $(1_H)^G$
>           rat,      # rational irreducible characters of $H$
>           ind,      # induced rational irreducible characters
>           mat,      # decomposition of `ind'
>           allowed,  # indices of possible constituents
>           S0,       # $S_0$
>           scprS0,   # decomposition of characters in $S_0$,
>                     # induced to $G$, with $Irr(G)$
>           C,        # function that computes $C(S,\psi)$
>           cand;     # list of multiplicity-free candidates, result
> 
>     # Compute $(1_H)^G$ and its decomposition.
>     triv   := TrivialCharacter( H );
>     permch := Induced( H, G, [ triv ] );
>     scpr1H := MatScalarProducts( G, Irr( G ), permch )[1];
> 
>     # If $(1_H)^G$ is not multiplicity-free then we are done.
>     if Maximum( scpr1H ) > 1 then
>       return [];
>     fi;
> 
>     # Compute the set $S_0$ of all possible nontrivial
>     # rational constituents of a multiplicity free candidate,
>     # that is, all those rational irreducible characters of
>     # $H$ that induce multiplicity freely to $G$,
>     # and orthogonal to $(1_H)^G$.
>     rat:= RationalizedMat( Irr( H ) );
>     ind:= Induced( H, G, rat );
>     mat:= MatScalarProducts( G, Irr( G ), ind );
>     allowed:= Filtered( [ 1.. Length( mat ) ],
>                         x ->     mat[x] * scpr1H = 0
>                              and Maximum( mat[x] ) = 1 );
>     S0     := rat{ allowed };
>     scprS0 := mat{ allowed };
> 
>     # Define the function that does the recursion.
>     C:= function( S, psi, scprS, scprpsi )
> 
>       local chi,          # $\chi$
>             scprchi,      # decomposition of $\chi^G$
>             Sprime,       # $S^{\prime}$
>             scprSprime,   # decomposition of characters in $S^{\prime}$,
>                           # induced to $G$
>             allowed;      # indices of possible constituents
> 
>       if IsEmpty( S ) then
> 
>         # Test whether `psi' is a possible permutation character.
>         if     TestPerm1( H, psi ) = 0
>            and TestPerm2( H, psi ) = 0
>            and TestPerm3( H, [ psi ] ) <> [] then
>           return [ psi ];
>         else
>           return [];
>         fi;
> 
>       else
> 
>         # Construct the set $S^{\prime}$ for a character $\chi$.
>         chi        := S[1];
>         scprchi    := scprS[1];
>         allowed    := Filtered( [ 2 .. Length( S ) ],
>                                 i -> Maximum( scprchi + scprS[i] ) <= 1 );
>         Sprime     := S{ allowed };
>         scprSprime := scprS{ allowed };
> 
>         # Enter the recursion.
>         return Concatenation(
>            C( Sprime, psi + chi,
>               scprSprime, scprpsi + scprchi ),
>            C( S{ [ 2 .. Length( S ) ] }, psi,
>               scprS{ [ 2 .. Length( S ) ] }, scprpsi ) );
> 
>       fi;
>     end;
> 
>     # Compute $C( S_0, 1_H )$.
>     cand:= C( S0, triv, scprS0, scpr1H );
> 
>     # Induce the candidates to $G$, and return the sorted list.
>     cand:= Induced( H, G, cand );
>     Sort( cand );
>     return cand;
> end );
gap> tbl:= CharacterTable( "A5" );;
gap> chars:= MultFreeFromTOM( tbl );
[ Character( CharacterTable( "A5" ), [ 12, 0, 0, 2, 2 ] ), 
  Character( CharacterTable( "A5" ), [ 10, 2, 1, 0, 0 ] ), 
  Character( CharacterTable( "A5" ), [ 6, 2, 0, 1, 1 ] ), 
  Character( CharacterTable( "A5" ), [ 5, 1, 2, 0, 0 ] ), 
  Character( CharacterTable( "A5" ), [ 1, 1, 1, 1, 1 ] ) ]
gap> PermCharInfo( tbl, chars ).ATLAS;
[ "1a+3ab+5a", "1a+4a+5a", "1a+5a", "1a+4a", "1a" ]
gap> tbl:= CharacterTable( "M12.2" );;
gap> chars:= MultFreeFromTOM( tbl );;
gap> lib:= MultFreePermChars( "M12.2" );;
gap> Length( lib );  Length( chars );
13
15
gap> Difference( chars, List( lib, x -> x.character ) );
[ Character( CharacterTable( "M12.2" ), [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1 ] ), Character( CharacterTable( "M12.2" ), 
    [ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 ] ) ]
gap> tblsimple:= CharacterTable( "M12" );;
gap> PermCharInfoRelative( tblsimple, tbl, chars ).ATLAS;
[ "1a^++16ab+45a^-+54a^{\\pm}+55a^{\\pm}bc+66a^++99a^{\\pm}+144a^++176a^+", 
  "1a^++11ab+45a^-+54a^{\\pm}+55a^++66a^{\\pm}+99a^-+120a^{\\pm}+144a^{\\pm}",
  "1a^{\\pm}+11ab+45a^{\\pm}+54a^{\\pm}+55a^{\\pm}bc+99a^{\\pm}+120a^{\\pm}", 
  "1a^++16ab+45a^++54a^{\\pm}+55a^-+66a^{\\pm}+99a^-+144a^++176a^-", 
  "1a^++16ab+45a^-+54a^{\\pm}+66a^++99a^-+144a^+", 
  "1a^++11ab+54a^{\\pm}+55a^++66a^++99a^-+144a^+", 
  "1a^{\\pm}+11ab+54a^{\\pm}+55a^{\\pm}+99a^{\\pm}", 
  "1a^++16ab+45a^++54a^{\\pm}+66a^++144a^+", 
  "1a^{\\pm}+11ab+54a^{\\pm}+66a^{\\pm}", "1a^++16ab+45a^++66a^+", 
  "1a^++11ab+55a^++66a^+", "1a^{\\pm}+11ab+54a^{\\pm}", "1a^{\\pm}+11ab", 
  "1a^{\\pm}", "1a^+" ]
gap> tbl:= CharacterTable( "M11" );;
gap> perms:= PermChars( tbl );;
gap> multfree:= Filtered( perms,
>        x -> ForAll( Irr( tbl ), chi -> ScalarProduct( chi, x ) <= 1 ) );
[ Character( CharacterTable( "M11" ), [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 ] ), 
  Character( CharacterTable( "M11" ), [ 11, 3, 2, 3, 1, 0, 1, 1, 0, 0 ] ), 
  Character( CharacterTable( "M11" ), [ 12, 4, 3, 0, 2, 1, 0, 0, 1, 1 ] ), 
  Character( CharacterTable( "M11" ), [ 22, 6, 4, 2, 2, 0, 0, 0, 0, 0 ] ), 
  Character( CharacterTable( "M11" ), [ 55, 7, 1, 3, 0, 1, 1, 1, 0, 0 ] ), 
  Character( CharacterTable( "M11" ), [ 66, 10, 3, 2, 1, 1, 0, 0, 0, 0 ] ), 
  Character( CharacterTable( "M11" ), [ 110, 6, 2, 2, 0, 0, 2, 2, 0, 0 ] ), 
  Character( CharacterTable( "M11" ), [ 144, 0, 0, 0, 4, 0, 0, 0, 1, 1 ] ) ]
gap> Length( multfree );
8
gap> tbl:= CharacterTable( "M11" );
CharacterTable( "M11" )
gap> maxes:= Maxes( tbl );
[ "A6.2_3", "L2(11)", "3^2:Q8.2", "A5.2", "2.S4" ]
gap> name:= maxes[1];;
gap> MultFree( tbl, CharacterTable( name ) );
[ Character( CharacterTable( "M11" ), [ 11, 3, 2, 3, 1, 0, 1, 1, 0, 0 ] ), 
  Character( CharacterTable( "M11" ), [ 22, 6, 4, 2, 2, 0, 0, 0, 0, 0 ] ), 
  Character( CharacterTable( "M11" ), [ 110, 6, 2, 2, 0, 0, 2, 2, 0, 0 ] ) ]
gap> cand:= [];;
gap> for name in maxes do
>      max:= CharacterTable( name );
>      Append( cand, List( MultFree( tbl, max ),
>                     chi -> [ name, Size( tbl ) / Size( max ), chi ] ) );
> od;
gap> cand;
[ [ "A6.2_3", 11, Character( CharacterTable( "M11" ), 
        [ 11, 3, 2, 3, 1, 0, 1, 1, 0, 0 ] ) ], 
  [ "A6.2_3", 11, Character( CharacterTable( "M11" ), 
        [ 22, 6, 4, 2, 2, 0, 0, 0, 0, 0 ] ) ], 
  [ "A6.2_3", 11, Character( CharacterTable( "M11" ), 
        [ 110, 6, 2, 2, 0, 0, 2, 2, 0, 0 ] ) ], 
  [ "L2(11)", 12, Character( CharacterTable( "M11" ), 
        [ 12, 4, 3, 0, 2, 1, 0, 0, 1, 1 ] ) ], 
  [ "L2(11)", 12, Character( CharacterTable( "M11" ), 
        [ 144, 0, 0, 0, 4, 0, 0, 0, 1, 1 ] ) ], 
  [ "3^2:Q8.2", 55, Character( CharacterTable( "M11" ), 
        [ 55, 7, 1, 3, 0, 1, 1, 1, 0, 0 ] ) ], 
  [ "3^2:Q8.2", 55, Character( CharacterTable( "M11" ), 
        [ 110, 6, 2, 2, 0, 0, 2, 2, 0, 0 ] ) ], 
  [ "A5.2", 66, Character( CharacterTable( "M11" ), 
        [ 66, 10, 3, 2, 1, 1, 0, 0, 0, 0 ] ) ] ]
gap> Length( cand );  Length( Set( cand, x -> x[3] ) );
8
7
gap> max1:= CharacterTable( maxes[1] );;
gap> perms1:= PermChars( max1, [ 2 ] );
[ Character( CharacterTable( "A6.2_3" ), [ 2, 2, 2, 2, 2, 0, 0, 0 ] ) ]
gap> perms1[1]^tbl = cand[2][3];
true
gap> max2:= CharacterTable( maxes[2] );;
gap> perms2:= PermChars( max2, [ 12 ] );
[ Character( CharacterTable( "L2(11)" ), [ 12, 0, 0, 2, 2, 0, 1, 1 ] ) ]
gap> perms2[1]^tbl = cand[5][3];
true
gap> PermChars( max1, [ 10 ] );
[ Character( CharacterTable( "A6.2_3" ), [ 10, 2, 1, 2, 0, 0, 2, 2 ] ), 
  Character( CharacterTable( "A6.2_3" ), [ 10, 2, 1, 2, 0, 2, 0, 0 ] ) ]
gap> OrdersClassRepresentatives( max1 );
[ 1, 2, 3, 4, 5, 4, 8, 8 ]
gap> max3:= CharacterTable( maxes[3] );;
gap> classes:= SizesConjugacyClasses( max3 );;
gap> Filtered( ClassPositionsOfNormalSubgroups( max3 ),
>              x -> Sum( classes{ x } ) = Size( max3 ) / 2 );
[ [ 1, 2, 4, 5, 6 ], [ 1, 2, 3, 4, 5, 7 ], [ 1, 2, 4, 5, 8, 9 ] ]
gap> perms3:= PermChars( max3, [ 2 ] );
[ Character( CharacterTable( "3^2:Q8.2" ), [ 2, 2, 0, 2, 2, 0, 0, 2, 2 ] ), 
  Character( CharacterTable( "3^2:Q8.2" ), [ 2, 2, 0, 2, 2, 2, 0, 0, 0 ] ), 
  Character( CharacterTable( "3^2:Q8.2" ), [ 2, 2, 2, 2, 2, 0, 2, 0, 0 ] ) ]
gap> induced:= List( perms3, x -> x^tbl );
[ Character( CharacterTable( "M11" ), [ 110, 6, 2, 2, 0, 0, 2, 2, 0, 0 ] ), 
  Character( CharacterTable( "M11" ), [ 110, 6, 2, 6, 0, 0, 0, 0, 0, 0 ] ), 
  Character( CharacterTable( "M11" ), [ 110, 14, 2, 2, 0, 2, 0, 0, 0, 0 ] ) ]
gap> Position( induced, cand[3][3] );
1
gap> info:= MultFreePermChars( "M12.2" );;
gap> perms:= Set( List( info, x -> x.character ) );;
gap> Length( info );  Length( perms );
13
13
gap> tbl:= CharacterTable( "M12.2" );;
gap> maxes:= Maxes( tbl );
[ "M12", "L2(11).2", "M12.2M3", "A5.2", "3^(1+2):D8", "(2^2xA5):2", 
  "D8.(S4x2)", "4^2:D12.2", "S4xS3" ]
gap> cand:= [];;
gap> for name in maxes do
>      max:= CharacterTable( name );
>      Append( cand, List( MultFree( tbl, max ),
>                     chi -> [ name, Size( tbl ) / Size( max ), chi ] ) );
> od;
gap> Length( cand );  Length( Set( List( cand, x -> x[3] ) ) );
25
17
gap> toexclude:= Set( Filtered( cand, x -> not x[3] in perms ) );
[ [ "M12", 2, Character( CharacterTable( "M12.2" ), 
        [ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0 ] ) ], 
  [ "M12", 2, Character( CharacterTable( "M12.2" ), 
        [ 440, 0, 24, 8, 8, 8, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
         ] ) ], 
  [ "M12", 2, Character( CharacterTable( "M12.2" ), [ 1320, 0, 8, 6, 0, 8, 0, 
          0, 2, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 ] ) ], 
  [ "M12", 2, Character( CharacterTable( "M12.2" ), 
        [ 1320, 0, 24, 6, 0, 4, 0, 0, 6, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 
         ] ) ] ]
gap> m12:= CharacterTable( "M12" );;
gap> subcand:= [];;
gap> submaxes:= Maxes( m12 );
[ "M11", "M12M2", "A6.2^2", "M12M4", "L2(11)", "3^2.2.S4", "M12M7", "2xS5", 
  "M8.S4", "4^2:D12", "A4xS3" ]
gap> for name in submaxes do
>      max:= CharacterTable( name );
>      Append( subcand, MultFree( m12, max ) );
> od;
gap> induced:= List( subcand, x -> x^tbl );;
gap> Intersection( induced, List( toexclude, x -> x[3] ) );
[  ]

gap> STOP_TEST( "multfree.tst", 75612500 );

#############################################################################
##
#E

