/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.apollo.openwire.command;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.activemq.apollo.openwire.codec.OpenWireFormat;
import org.apache.activemq.apollo.openwire.command.ActiveMQMessage;
import org.apache.activemq.apollo.openwire.command.Message;
import org.apache.activemq.apollo.openwire.support.OpenwireException;
import org.apache.activemq.apollo.openwire.support.Settings;
import org.apache.activemq.apollo.util.ClassLoadingAwareObjectInputStream;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.fusesource.hawtbuf.ByteArrayOutputStream;

public class ActiveMQObjectMessage
extends ActiveMQMessage {
    public static final byte DATA_STRUCTURE_TYPE = 26;
    static final ClassLoader ACTIVEMQ_CLASSLOADER = ActiveMQObjectMessage.class.getClassLoader();
    protected transient Serializable object;

    public Message copy() {
        ActiveMQObjectMessage copy = new ActiveMQObjectMessage();
        this.copy(copy);
        return copy;
    }

    private void copy(ActiveMQObjectMessage copy) {
        this.storeContent();
        super.copy(copy);
        copy.object = null;
    }

    public void beforeMarshall(OpenWireFormat wireFormat) throws IOException {
        super.beforeMarshall(wireFormat);
        this.storeContent();
    }

    public void storeContent() {
        Buffer bodyAsBytes = this.getContent();
        if (bodyAsBytes == null && this.object != null) {
            try {
                ByteArrayOutputStream bytesOut;
                Object os = bytesOut = new ByteArrayOutputStream();
                if (Settings.enable_compression()) {
                    this.compressed = true;
                    os = new DeflaterOutputStream((OutputStream)os);
                }
                DataOutputStream dataOut = new DataOutputStream((OutputStream)os);
                ObjectOutputStream objOut = new ObjectOutputStream(dataOut);
                objOut.writeObject(this.object);
                objOut.flush();
                objOut.reset();
                objOut.close();
                this.setContent(bytesOut.toBuffer());
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe.getMessage(), ioe);
            }
        }
    }

    public byte getDataStructureType() {
        return 26;
    }

    public String getJMSXMimeType() {
        return "jms/object-message";
    }

    public void clearBody() throws OpenwireException {
        super.clearBody();
        this.object = null;
    }

    public void setObject(Serializable newObject) throws OpenwireException {
        this.checkReadOnlyBody();
        this.object = newObject;
        this.setContent(null);
        this.storeContent();
    }

    public Serializable getObject() throws OpenwireException {
        if (this.object == null && this.getContent() != null) {
            try {
                Buffer content = this.getContent();
                Object is = new ByteArrayInputStream(content);
                if (this.isCompressed()) {
                    is = new InflaterInputStream((InputStream)is);
                }
                DataInputStream dataIn = new DataInputStream((InputStream)is);
                ClassLoadingAwareObjectInputStream objIn = new ClassLoadingAwareObjectInputStream((InputStream)dataIn);
                try {
                    this.object = (Serializable)objIn.readObject();
                }
                catch (ClassNotFoundException ce) {
                    throw new OpenwireException("Failed to build body from content. Serializable class not available to broker. Reason: " + ce, ce);
                }
                finally {
                    dataIn.close();
                }
            }
            catch (IOException e) {
                throw new OpenwireException("Failed to build body from bytes. Reason: " + e, e);
            }
        }
        return this.object;
    }

    public void clearMarshalledState() {
        super.clearMarshalledState();
        this.object = null;
    }

    public void onMessageRolledBack() {
        super.onMessageRolledBack();
        this.object = null;
    }

    public String toString() {
        try {
            this.getObject();
        }
        catch (OpenwireException openwireException) {
            // empty catch block
        }
        return super.toString();
    }
}

