/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.cram.common.CRAMVersion;
import htsjdk.samtools.cram.io.CRC32OutputStream;
import htsjdk.samtools.cram.io.CramInt;
import htsjdk.samtools.cram.io.CramIntArray;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.io.LTF8;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentContext;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ContainerHeader {
    private final AlignmentContext alignmentContext;
    private final int recordCount;
    private final long globalRecordCounter;
    private final long baseCount;
    private final int blockCount;
    private List<Integer> landmarks;
    private int checksum = 0;
    private int containerBlocksByteSize;

    public ContainerHeader(AlignmentContext alignmentContext, int blockCount, int containerBlocksByteSize, int recordCount, long globalRecordCounter, long baseCount, List<Integer> landmarks, int checksum) {
        this.alignmentContext = alignmentContext;
        this.blockCount = blockCount;
        this.containerBlocksByteSize = containerBlocksByteSize;
        this.recordCount = recordCount;
        this.globalRecordCounter = globalRecordCounter;
        this.baseCount = baseCount;
        this.landmarks = landmarks;
        this.checksum = checksum;
    }

    public ContainerHeader(AlignmentContext alignmentContext, int blockCount, int recordCount, long globalRecordCounter, int baseCount) {
        this(alignmentContext, blockCount, 0, recordCount, globalRecordCounter, baseCount, new ArrayList<Integer>(), 0);
    }

    public ContainerHeader(CRAMVersion cramVersion, InputStream inputStream) {
        this.containerBlocksByteSize = CramInt.readInt32(inputStream);
        ReferenceContext refContext = new ReferenceContext(ITF8.readUnsignedITF8(inputStream));
        int alignmentStart = ITF8.readUnsignedITF8(inputStream);
        int alignmentSpan = ITF8.readUnsignedITF8(inputStream);
        this.alignmentContext = new AlignmentContext(refContext, alignmentStart, alignmentSpan);
        this.recordCount = ITF8.readUnsignedITF8(inputStream);
        this.globalRecordCounter = LTF8.readUnsignedLTF8(inputStream);
        this.baseCount = LTF8.readUnsignedLTF8(inputStream);
        this.blockCount = ITF8.readUnsignedITF8(inputStream);
        this.landmarks = CramIntArray.arrayAsList(inputStream);
        this.checksum = cramVersion.getMajor() >= 3 ? CramInt.readInt32(inputStream) : 0;
    }

    public static ContainerHeader makeSAMFileHeaderContainer(int containerBlocksByteSize) {
        return new ContainerHeader(AlignmentContext.UNMAPPED_UNPLACED_CONTEXT, 1, containerBlocksByteSize, 0, 0L, 0L, Collections.emptyList(), 0);
    }

    public int getContainerBlocksByteSize() {
        return this.containerBlocksByteSize;
    }

    public void setContainerBlocksByteSize(int containerBlocksByteSize) {
        this.containerBlocksByteSize = containerBlocksByteSize;
    }

    public AlignmentContext getAlignmentContext() {
        return this.alignmentContext;
    }

    public int getNumberOfRecords() {
        return this.recordCount;
    }

    public long getGlobalRecordCounter() {
        return this.globalRecordCounter;
    }

    public long getBaseCount() {
        return this.baseCount;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public List<Integer> getLandmarks() {
        return this.landmarks;
    }

    public void setLandmarks(List<Integer> landmarks) {
        this.landmarks = landmarks;
    }

    public int getChecksum() {
        return this.checksum;
    }

    public int write(CRAMVersion cramVersion, OutputStream outputStream) {
        CRC32OutputStream crc32OutputStream = new CRC32OutputStream(outputStream);
        int length = (CramInt.writeInt32(this.getContainerBlocksByteSize(), crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(this.alignmentContext.getReferenceContext().getReferenceContextID(), crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(this.alignmentContext.getAlignmentStart(), crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(this.alignmentContext.getAlignmentSpan(), crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(this.getNumberOfRecords(), crc32OutputStream) + 7) / 8;
        length += (LTF8.writeUnsignedLTF8(this.getGlobalRecordCounter(), crc32OutputStream) + 7) / 8;
        length += (LTF8.writeUnsignedLTF8(this.getBaseCount(), crc32OutputStream) + 7) / 8;
        length += (ITF8.writeUnsignedITF8(this.getBlockCount(), crc32OutputStream) + 7) / 8;
        length += (CramIntArray.write(this.getLandmarks(), (OutputStream)crc32OutputStream) + 7) / 8;
        if (cramVersion.getMajor() >= 3) {
            try {
                outputStream.write(crc32OutputStream.getCrc32_LittleEndian());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
            length += 4;
        }
        return length;
    }

    public String toString() {
        return String.format("%s, nRecords=%d, nBlocks=%d, nBases=%d, globalCounter=%d", this.alignmentContext, this.recordCount, this.blockCount, this.baseCount, this.globalRecordCounter);
    }

    public boolean isEOF() {
        boolean v3 = this.containerBlocksByteSize == 15 && this.alignmentContext.getReferenceContext().isUnmappedUnplaced() && this.alignmentContext.getAlignmentStart() == 4542278 && this.blockCount == 1 && this.recordCount == 0;
        boolean v2 = this.containerBlocksByteSize == 11 && this.alignmentContext.getReferenceContext().isUnmappedUnplaced() && this.alignmentContext.getAlignmentStart() == 4542278 && this.blockCount == 1 && this.recordCount == 0;
        return v3 || v2;
    }
}

