/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.perms;

import it.unimi.dsi.fastutil.io.FastBufferedInputStream;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.alignments.perms.PermutationReaderInterface;
import org.campagnelab.goby.alignments.perms.PermutationWriter;

public class PermutationReader
implements PermutationReaderInterface {
    private static final Log LOG = LogFactory.getLog(PermutationWriter.class);
    private FastBufferedInputStream input;
    private String basename;
    private static final Comparator<? super Block> SMALL_INDEX_COMPARATOR = new CompareSmallIndex();
    private DataInputStream dataInput;
    private Block[] indexBlocks;
    private Block singletonQuery;

    public PermutationReader(String basename) throws IOException {
        block2: {
            this.singletonQuery = new Block();
            this.basename = AlignmentReaderImpl.getBasename(basename);
            FastBufferedInputStream inputStream = null;
            String filename = basename + ".perm";
            try {
                inputStream = new FastBufferedInputStream((InputStream)new FileInputStream(filename));
                this.dataInput = new DataInputStream((InputStream)inputStream);
                this.input = inputStream;
                this.makeIndex(inputStream);
            }
            catch (FileNotFoundException e) {
                String error = String.format("A permutation file called %s could not be found, but is required to reconstruct original query indices to complete this task.", filename);
                LOG.error((Object)error, (Throwable)e);
                inputStream = null;
                if ($assertionsDisabled || inputStream != null) break block2;
                throw new AssertionError((Object)error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeIndex(FastBufferedInputStream inputStream) throws IOException {
        this.input.position(0L);
        ObjectArrayList blocks = new ObjectArrayList();
        try (DataInputStream dataInput = new DataInputStream((InputStream)new FastBufferedInputStream((InputStream)new FileInputStream(this.basename + ".perm")));){
            long offset = 0L;
            while (dataInput.available() > 0) {
                Block block = new Block();
                block.offset = offset;
                block.n = dataInput.readInt();
                block.firstSmallIndex = dataInput.readInt();
                dataInput.skip((long)block.n * 4L);
                blocks.add((Object)block);
                offset += (long)block.n * 4L + 8L;
            }
            Collections.sort(blocks, SMALL_INDEX_COMPARATOR);
            this.indexBlocks = (Block[])blocks.toArray((Object[])new Block[blocks.size()]);
        }
    }

    @Override
    public int getQueryIndex(int smallIndex) throws IOException {
        this.singletonQuery.firstSmallIndex = smallIndex;
        int ip = Arrays.binarySearch(this.indexBlocks, this.singletonQuery, SMALL_INDEX_COMPARATOR);
        if (ip >= 0) {
            Block block = this.indexBlocks[ip];
            this.seek(block.offset + 4L);
            int first = this.dataInput.readInt();
            assert (first == smallIndex) : "assertion failed at smallIndex=" + smallIndex;
            int queryIndex = this.dataInput.readInt();
            return queryIndex;
        }
        int index = -(ip + 1);
        int off = index - 1;
        if (off < 0) {
            return -1;
        }
        Block block = this.indexBlocks[off];
        int soffset = smallIndex - block.firstSmallIndex;
        if (soffset < 0 || block.firstSmallIndex + block.n < smallIndex) {
            return -1;
        }
        this.seek(block.offset + 8L + (long)soffset * 4L);
        int queryIndex = this.dataInput.readInt();
        return queryIndex;
    }

    private void seek(long offset) throws IOException {
        this.input.position(offset);
    }

    private static class CompareSmallIndex
    implements Comparator<Block> {
        private CompareSmallIndex() {
        }

        @Override
        public int compare(Block a, Block b) {
            return a.firstSmallIndex - b.firstSmallIndex;
        }
    }

    static class Block {
        int firstSmallIndex;
        int n;
        long offset;

        Block() {
        }
    }
}

