/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import com.martiansoftware.jsap.JSAPResult;
import edu.cornell.med.icb.identifier.DoubleIndexedIdentifier;
import it.unimi.dsi.fastutil.ints.IntLinkedOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.lang.MutableString;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AlignmentReader;
import org.campagnelab.goby.alignments.AlignmentReaderFactory;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.DefaultAlignmentReaderFactory;
import org.campagnelab.goby.alignments.FileSlice;
import org.campagnelab.goby.alignments.GenomicRange;

public abstract class IterateAlignments {
    private static final Log LOG = LogFactory.getLog(IterateAlignments.class);
    private boolean filterByReferenceNames;
    private ObjectSet<String> includeReferenceNames = new ObjectOpenHashSet();
    private IntSortedSet referencesToProcess;
    private DoubleIndexedIdentifier referenceIds;
    private AlignmentReaderFactory alignmentReaderFactory = new DefaultAlignmentReaderFactory();

    public void parseIncludeReferenceArgument(JSAPResult jsapResult) {
        String includeReferenceNameCommas = jsapResult.getString("include-reference-names");
        this.parseIncludeReferenceArgument(includeReferenceNameCommas);
    }

    public void parseIncludeReferenceArgument(String includeReferenceNameCommas) {
        if (includeReferenceNameCommas != null) {
            this.includeReferenceNames = new ObjectOpenHashSet();
            this.includeReferenceNames.addAll(Arrays.asList(includeReferenceNameCommas.split("[,]")));
            LOG.info((Object)"Will iterate through the following sequences:");
            for (String name : this.includeReferenceNames) {
                System.out.println(name);
            }
            this.filterByReferenceNames = true;
        }
    }

    public void iterate(long startOffset, long endOffset, String basename) throws IOException {
        this.iterateOverOneAlignment(new FileSlice(startOffset, endOffset, basename), basename);
    }

    public void iterate(String ... basenames) throws IOException {
        for (String basename : basenames) {
            this.iterateOverOneAlignment(FileSlice.COMPLETE_FILE(basename), basename);
        }
    }

    public void iterate(Collection<String> basenames) throws IOException {
        for (String basename : basenames) {
            this.iterateOverOneAlignment(FileSlice.COMPLETE_FILE(basename), basename);
        }
    }

    public void iterate(GenomicRange range, String ... basenames) throws IOException {
        if (range == null) {
            this.iterate(basenames);
        } else {
            for (String basename : basenames) {
                this.iterateOverOneAlignment(this.alignmentReaderFactory.getSlice(basename, range), basename, range.startReferenceIndex, range.startPosition);
            }
        }
    }

    public void iterate(FileSlice slice, String ... basenames) throws IOException {
        for (String basename : basenames) {
            this.iterateOverOneAlignment(slice, basename);
        }
    }

    private void iterateOverOneAlignment(FileSlice slice, String basename) throws IOException {
        this.iterateOverOneAlignment(slice, basename, 0, 0);
    }

    private void iterateOverOneAlignment(FileSlice slice, String basename, int minTargetIndex, int minPosition) throws IOException {
        assert (slice == null || slice.basename == null || slice.basename.equals(basename)) : "basename must match in slice.";
        AlignmentReader reader = this.alignmentReaderFactory.createReader(basename, slice.startOffset, slice.endOffset);
        reader.readHeader();
        int numberOfReferences = reader.getNumberOfTargets();
        this.referenceIds = new DoubleIndexedIdentifier(reader.getTargetIdentifiers());
        reader.close();
        LOG.debug((Object)String.format("Alignment contains %d reference sequences", numberOfReferences));
        this.processNumberOfReferences(basename, numberOfReferences);
        this.referencesToProcess = new IntLinkedOpenHashSet();
        for (int referenceIndex = minTargetIndex; referenceIndex < numberOfReferences; ++referenceIndex) {
            MutableString referenceId = this.referenceIds.getId(referenceIndex);
            if (referenceId == null) continue;
            String referenceName = referenceId.toString();
            if (this.filterByReferenceNames) {
                if (!this.includeReferenceNames.contains((Object)referenceName)) continue;
                this.referencesToProcess.add(referenceIndex);
                continue;
            }
            this.referencesToProcess.add(referenceIndex);
        }
        AlignmentReader alignmentReader = this.alignmentReaderFactory.createReader(basename, slice.startOffset, slice.endOffset);
        alignmentReader.readHeader();
        for (int referenceIndex = minTargetIndex; referenceIndex < numberOfReferences; ++referenceIndex) {
            if (!this.referencesToProcess.contains(referenceIndex)) continue;
            this.prepareDataStructuresForReference(alignmentReader, referenceIndex);
        }
        LOG.debug((Object)("Loading the alignment " + basename));
        if (alignmentReader.isSorted()) {
            Alignments.AlignmentEntry alignmentEntry;
            alignmentReader.readIndex();
            alignmentReader.reposition(minTargetIndex, minPosition);
            LOG.debug((Object)"The alignment is sorted, iteration will use the faster skipTo method.");
            int currentMinTargetIndex = this.referencesToProcess.firstInt();
            while ((alignmentEntry = alignmentReader.skipTo(currentMinTargetIndex, 0)) != null) {
                int referenceIndex = alignmentEntry.getTargetIndex();
                if (this.referencesToProcess.contains(referenceIndex)) {
                    this.processAlignmentEntry(alignmentReader, alignmentEntry);
                }
                if (referenceIndex <= currentMinTargetIndex) continue;
                boolean success = this.referencesToProcess.remove(currentMinTargetIndex);
                assert (success) : "removing an element from referencesToProcess must succeed. ";
                if (!this.referencesToProcess.isEmpty()) {
                    currentMinTargetIndex = this.referencesToProcess.firstInt();
                    continue;
                }
                break;
            }
        } else {
            for (Alignments.AlignmentEntry alignmentEntry : alignmentReader) {
                int referenceIndex = alignmentEntry.getTargetIndex();
                if (!this.referencesToProcess.contains(referenceIndex)) continue;
                this.processAlignmentEntry(alignmentReader, alignmentEntry);
            }
        }
        alignmentReader.close();
    }

    public abstract void processAlignmentEntry(AlignmentReader var1, Alignments.AlignmentEntry var2);

    public void prepareDataStructuresForReference(AlignmentReader alignmentReader, int referenceIndex) {
    }

    public void processNumberOfReferences(String basename, int numberOfReferences) throws IOException {
    }

    protected CharSequence getReferenceId(int targetIndex) {
        return this.referenceIds.getId(targetIndex);
    }

    public void setAlignmentReaderFactory(AlignmentReaderFactory factory) {
        this.alignmentReaderFactory = factory;
    }
}

